/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.debug.ui.ECommonsDebugUIResources;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class ECommonsDebugUIImageDescriptor
extends CompositeImageDescriptor {
    public static final int ENABLED = 1;
    public static final int INSTALLED = 2;
    public static final int SCRIPT = 16;
    public static final int CONDITIONAL = 256;
    public static final int ENTRY = 4096;
    public static final int EXIT = 8192;
    private final ImageDescriptor baseImage;
    private final int flags;
    private @Nullable Point size;

    public ECommonsDebugUIImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.baseImage = (ImageDescriptor)ObjectUtils.nonNullAssert((Object)baseImage);
        this.flags = flags;
    }

    protected final ImageDescriptor getBaseImage() {
        return this.baseImage;
    }

    protected final int getFlags() {
        return this.flags;
    }

    protected final Point getSize() {
        Point size = this.size;
        if (size == null) {
            CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(this.getBaseImage());
            this.size = size = new Point(data.getWidth(), data.getHeight());
        }
        return size;
    }

    protected void drawCompositeImage(int width, int height) {
        CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(this.getBaseImage());
        this.drawImage((ImageDataProvider)data, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        CompositeImageDescriptor.CachedImageDataProvider data;
        int y;
        int x;
        int flags = this.getFlags();
        if (flags == 0) {
            return;
        }
        ECommonsDebugUIResources commonsUIResources = ECommonsDebugUIResources.INSTANCE;
        if ((flags & 0x12) == 2) {
            x = 0;
            y = this.getSize().y;
            data = this.createCachedImageDataProvider(commonsUIResources.getImageDescriptor((flags & 1) != 0 ? "org.eclipse.statet.ecommons.debug/images/ovr/Breakpoint.Installed" : "org.eclipse.statet.ecommons.debug/images/ovr/Breakpoint.Installed.disabled"));
            this.drawImage((ImageDataProvider)data, 0, y -= data.getHeight());
        }
        if ((flags & 0x100) != 0) {
            x = 0;
            y = 0;
            data = this.createCachedImageDataProvider(commonsUIResources.getImageDescriptor((flags & 1) != 0 ? "org.eclipse.statet.ecommons.debug/images/ovr/Breakpoint.Conditional" : "org.eclipse.statet.ecommons.debug/images/ovr/Breakpoint.Conditional.disabled"));
            this.drawImage((ImageDataProvider)data, 0, 0);
        }
        if ((flags & 0x1000) != 0) {
            x = this.getSize().x;
            y = 0;
            data = this.createCachedImageDataProvider(commonsUIResources.getImageDescriptor((flags & 1) != 0 ? "org.eclipse.statet.ecommons.debug/images/ovr/Breakpoint.MethodEntry" : "org.eclipse.statet.ecommons.debug/images/ovr/Breakpoint.MethodEntry.disabled"));
            x -= data.getWidth();
            this.drawImage((ImageDataProvider)data, --x, 0);
        }
        if ((flags & 0x2000) != 0) {
            x = this.getSize().x;
            y = this.getSize().y;
            data = this.createCachedImageDataProvider(commonsUIResources.getImageDescriptor((flags & 1) != 0 ? "org.eclipse.statet.ecommons.debug/images/ovr/Breakpoint.MethodExit" : "org.eclipse.statet.ecommons.debug/images/ovr/Breakpoint.MethodExit.disabled"));
            x -= data.getWidth();
            this.drawImage((ImageDataProvider)data, --x, y -= data.getHeight());
        }
    }

    public int hashCode() {
        return this.baseImage.hashCode() ^ this.flags;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass())) {
            ECommonsDebugUIImageDescriptor other = (ECommonsDebugUIImageDescriptor)((Object)obj);
            return this.baseImage.equals(other.baseImage) && this.flags == other.flags;
        }
        return false;
    }
}

