/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.core.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.docmlet.wikitext.core.WikitextBuildParticipant;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSuModelContainer;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocWorkspaceSourceUnit;
import org.eclipse.statet.internal.redocs.wikitext.r.core.model.WikidocRweaveSuModelContainer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.RProjects;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.model.RModelIndexUpdate;
import org.eclipse.statet.redocs.wikitext.r.core.model.WikidocRweaveSourceUnit;

public class WikitextRweaveTexBuildParticipant
extends WikitextBuildParticipant {
    private static final ImList<String> WIKITEXT_R_MODEL_TYPES = ImCollections.newList((Object)"WikidocRweave");
    private RModelIndexUpdate rIndexUpdate;

    public void init() {
        super.init();
        RProject rProject = RProjects.getRProject((IProject)this.getWikitextProject().getProject());
        if (rProject != null) {
            this.setEnabled(true);
            this.rIndexUpdate = new RModelIndexUpdate(rProject, WIKITEXT_R_MODEL_TYPES, this.getBuildType() == 6);
        }
    }

    public void clear(IFile file) throws CoreException {
        file.deleteMarkers("org.eclipse.statet.r.resourceMarkers.Tasks", false, 2);
    }

    public void docUnitUpdated(WikidocWorkspaceSourceUnit sourceUnit, IProgressMonitor monitor) throws CoreException {
        if (sourceUnit instanceof WikidocRweaveSourceUnit) {
            WikidocRweaveSourceUnit unit = (WikidocRweaveSourceUnit)sourceUnit;
            WikidocRweaveSuModelContainer modelContainer = (WikidocRweaveSuModelContainer)((Object)unit.getAdapter(WikidocSuModelContainer.class));
            if (modelContainer != null) {
                this.rIndexUpdate.update((IRSourceUnit)unit, RModel.getRModelInfo((ISourceUnitModelInfo)modelContainer.getCurrentModel()));
            } else {
                this.rIndexUpdate.remove((IRSourceUnit)unit);
            }
        }
    }

    public void docUnitRemoved(IFile file, IProgressMonitor monitor) throws CoreException {
        this.rIndexUpdate.remove(file);
    }

    public void docFinished(IProgressMonitor monitor) throws CoreException {
        this.rIndexUpdate.submit(monitor);
    }
}

