/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.datafilter.FilterSet;
import org.eclipse.statet.internal.r.ui.datafilter.FilterType;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.internal.r.ui.datafilterview.ExpandableRowComposite;
import org.eclipse.statet.internal.r.ui.datafilterview.FilterClient;
import org.eclipse.statet.internal.r.ui.datafilterview.Messages;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableContainer;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VariableComposite
extends ExpandableRowComposite {
    private final VariableContainer site;
    private RDataTableColumn column;
    private final MenuManager menuManager;
    private boolean active;

    public VariableComposite(Composite parent, VariableContainer site, RDataTableColumn column) {
        super(parent, 0, 1073741842);
        this.site = site;
        this.setColumn(column);
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                VariableComposite.this.fillMenu(manager);
            }
        });
        this.setMenu(this.menuManager.createContextMenu((Control)this));
    }

    @Override
    public void setClient(Control client) {
        if (!(client instanceof FilterClient)) {
            throw new IllegalArgumentException();
        }
        super.setClient(client);
        this.updateImage(false);
    }

    public void layout(Control[] changed, int flags) {
        super.layout(changed, flags);
        this.getParent().layout(new Control[]{this});
        if (this.isExpanded()) {
            this.site.getVariableComposite().reflow(true);
        }
    }

    public VariableContainer getContainer() {
        return this.site;
    }

    public FilterClient getClient() {
        return (FilterClient)super.getClient();
    }

    public void setColumn(RDataTableColumn column) {
        this.column = column;
        this.updateImage(true);
        this.setText(this.column.getName());
    }

    protected void updateImage(boolean force) {
        boolean isActive = this.isFilterActive();
        if (!force && this.active == isActive) {
            return;
        }
        Image image = this.site.getLabelProvider().getImage(this.column);
        if (isActive) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
            imageDescriptorArray[1] = SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/ovr/light-yellow");
            DecorationOverlayIcon descriptor = new DecorationOverlayIcon(image, imageDescriptorArray);
            image = RUIPlugin.getInstance().getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
            this.active = true;
        } else {
            this.active = false;
        }
        this.setImage(image);
    }

    private boolean isFilterActive() {
        FilterClient client = this.getClient();
        if (client != null) {
            String rExpression = client.getFilter().getFilterRExpression();
            return rExpression != null && !rExpression.isEmpty();
        }
        return false;
    }

    public RDataTableColumn getColumn() {
        return this.column;
    }

    protected void fillMenu(IMenuManager menu) {
        VariableFilter currentFilter = this.getClient().getFilter();
        FilterSet filterSet = currentFilter.getSet();
        ImList<FilterType> filters = filterSet.getAvailableFilters(this.column);
        int i = 0;
        while (i < filters.size()) {
            final FilterType filterType = (FilterType)filters.get(i);
            SimpleContributionItem item = new SimpleContributionItem(filterType.getLabel(), null, 16){

                protected void execute() throws ExecutionException {
                    VariableComposite.this.setFilterType(filterType);
                }
            };
            item.setChecked(currentFilter.getType() == filterType);
            menu.add((IContributionItem)item);
            ++i;
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new SimpleContributionItem(Messages.Variable_Clear_label, null){

            protected void execute() throws ExecutionException {
                VariableComposite.this.getClient().getFilter().reset();
            }
        });
    }

    protected void setFilterType(FilterType type) {
        VariableFilter currentFilter = this.getClient().getFilter();
        if (currentFilter.getType() == type) {
            return;
        }
        FilterSet filterSet = currentFilter.getSet();
        filterSet.replace(currentFilter, type);
        this.layout(new Control[]{this.getClient()});
    }
}

