/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.internal.Tracing;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.ui.internal.Activator;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ReferencesView
extends ViewPart {
    private Object viewInput;
    private IContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private TreeViewer viewer;
    private boolean showInverseReferences = false;
    protected Map<TransactionalEditingDomain, IContentProvider> modelCrossReferenceContentProviders = new WeakHashMap<TransactionalEditingDomain, IContentProvider>();
    protected Map<TransactionalEditingDomain, ILabelProvider> modelLabelProviders = new WeakHashMap<TransactionalEditingDomain, ILabelProvider>();
    private Action action1;
    private Action action2;
    private Action doubleClickAction;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.contentProvider = this.createModelCrossReferenceContentProvider();
        if (this.contentProvider != null) {
            this.viewer.setContentProvider(this.contentProvider);
        }
        if (this.labelProvider != null) {
            this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void setViewInput(Object viewInput) {
        this.viewInput = viewInput;
        this.labelProvider = this.getModelLabelProvider(viewInput);
        if (this.labelProvider != null) {
            this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.viewer.setInput(viewInput);
    }

    protected IContentProvider createModelCrossReferenceContentProvider() {
        return new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof EObject) {
                    final EObject parentEObject = (EObject)parentElement;
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)parentEObject);
                    if (editingDomain != null) {
                        try {
                            return (Object[])TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<Object[]>(){

                                public void run() {
                                    Collection<EObject> eCrossReferences = this.getECrossReferences(parentEObject, ReferencesView.this.showInverseReferences);
                                    this.setResult(eCrossReferences.toArray(new EObject[eCrossReferences.size()]));
                                }
                            });
                        }
                        catch (InterruptedException ex) {
                            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                        }
                    } else {
                        Collection<EObject> eCrossReferences = this.getECrossReferences(parentEObject, ReferencesView.this.showInverseReferences);
                        return eCrossReferences.toArray(new EObject[eCrossReferences.size()]);
                    }
                }
                return new Object[0];
            }

            protected Collection<EObject> getECrossReferences(EObject eObject, boolean inverse) {
                if (inverse) {
                    ArrayList<EObject> eInverseCrossReferences = new ArrayList<EObject>();
                    Collection inverseReferences = EObjectUtil.getInverseReferences((EObject)eObject, (boolean)true);
                    for (EStructuralFeature.Setting inverseReference : inverseReferences) {
                        eInverseCrossReferences.add(inverseReference.getEObject());
                    }
                    return eInverseCrossReferences;
                }
                return eObject.eCrossReferences();
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }
        };
    }

    protected ILabelProvider getModelLabelProvider(Object element) {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)element);
        if (editingDomain != null) {
            ILabelProvider modelLabelProvider = this.modelLabelProviders.get(editingDomain);
            if (modelLabelProvider == null) {
                modelLabelProvider = this.createModelLabelProvider(editingDomain);
                this.modelLabelProviders.put(editingDomain, modelLabelProvider);
            }
            return modelLabelProvider;
        }
        if (element instanceof EObject && ((EObject)element).eIsProxy()) {
            return new AdapterFactoryLabelProvider(this.getAdapterFactory(editingDomain));
        }
        return null;
    }

    protected ILabelProvider createModelLabelProvider(final TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        AdapterFactory adapterFactory = this.getAdapterFactory(editingDomain);
        return new TransactionalAdapterFactoryLabelProvider(editingDomain, adapterFactory){

            protected <T> T run(RunnableWithResult<? extends T> run) {
                try {
                    return (T)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, run);
                }
                catch (Exception e) {
                    Tracing.catching(TransactionalAdapterFactoryLabelProvider.class, (String)"run", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        };
    }

    protected AdapterFactory getAdapterFactory(TransactionalEditingDomain editingDomain) {
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ReferencesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                ReferencesView.this.showMessage("Action 1 executed");
            }
        };
        this.action1.setText("Action 1");
        this.action1.setToolTipText("Action 1 tooltip");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action(){

            public void run() {
                ReferencesView.this.showMessage("Action 2 executed");
            }
        };
        this.action2.setText("Action 2");
        this.action2.setToolTipText("Action 2 tooltip");
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ReferencesView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ReferencesView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ReferencesView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Sample View", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

