/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.components;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.WorkflowComponentWithModelSlot;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;

public class ModelLoader
extends WorkflowComponentWithModelSlot {
    private String projectName;
    private String metaModelDescriptorId;

    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        this.checkRequiredConfigProperty("project", this.projectName, issues);
        this.checkRequiredConfigProperty("metaModelDescriptorId", this.metaModelDescriptorId, issues);
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        try {
            Job.getJobManager().join(IExtendedPlatformConstants.FAMILY_LONG_RUNNING, null);
        }
        catch (Exception exception) {}
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.projectName);
        if (!project.exists()) {
            issues.addError("Project '" + this.projectName + "' does not exist in the workspace " + workspace.getRoot().getLocation().toFile());
            return;
        }
        if (!project.isAccessible()) {
            issues.addError("Project '" + this.projectName + "' is not accessible in the workspace " + workspace.getRoot().getLocation().toFile());
            return;
        }
        ArrayList modelRoots = new ArrayList();
        IMetaModelDescriptor mmd = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(this.metaModelDescriptorId);
        if (mmd == null) {
            issues.addError("Metamodel Descriptor '" + this.metaModelDescriptorId + "' unknown");
            return;
        }
        Collection models = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project, mmd);
        if (models.isEmpty()) {
            issues.addError("Project '" + this.projectName + "' does not contain any " + mmd.getName() + " models");
            return;
        }
        IModelDescriptor modelDescriptor = (IModelDescriptor)models.iterator().next();
        ModelLoadManager.INSTANCE.loadModel(modelDescriptor, false, null);
        for (Resource resource : modelDescriptor.getLoadedResources(true)) {
            modelRoots.addAll(resource.getContents());
            issues.addInfo("Loaded resource " + resource.getURI());
        }
        if (modelRoots.isEmpty()) {
            issues.addError("Project '" + this.projectName + "' does not contain" + mmd.getName() + "resources");
            return;
        }
        ctx.set(this.getModelSlot(), modelRoots);
    }

    public void setProject(String projectName) {
        this.projectName = projectName;
    }

    public String getProject() {
        return this.projectName;
    }

    public void setMetaModelDescriptor(String metaModelDescriptorId) {
        this.metaModelDescriptorId = metaModelDescriptorId;
    }

    public String getMetaModelDesriptor() {
        return this.metaModelDescriptorId;
    }
}

