/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.actions.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.explorer.actions.filters.BasicCommandParameterFilter;
import org.eclipse.sphinx.emf.explorer.actions.filters.ICommandParameterFilter;
import org.eclipse.sphinx.emf.ui.actions.ExtendedCopyAction;
import org.eclipse.sphinx.emf.ui.actions.ExtendedCutAction;
import org.eclipse.sphinx.emf.ui.actions.ExtendedDeleteAction;
import org.eclipse.sphinx.emf.ui.actions.ExtendedPasteAction;
import org.eclipse.sphinx.emf.ui.actions.providers.BasicActionProvider;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicModelEditActionProvider
extends BasicActionProvider {
    protected CutAction cutAction;
    protected CopyAction copyAction;
    protected PasteAction pasteAction;
    protected DeleteAction deleteAction;
    protected Collection<IAction> createChildActions;
    protected Map<String, Collection<IAction>> createChildSubmenuActions;
    protected Collection<IAction> createSiblingActions;
    protected Map<String, Collection<IAction>> createSiblingSubmenuActions;
    private ICommandParameterFilter newChildOrSiblingItemFilter;

    public void doInit() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.cutAction = this.createCutAction();
        Assert.isNotNull((Object)this.cutAction);
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.cutAction.setActiveWorkbenchPart(this.workbenchPart);
        this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.copyAction = this.createCopyAction();
        Assert.isNotNull((Object)this.copyAction);
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setActiveWorkbenchPart(this.workbenchPart);
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.pasteAction = this.createPasteAction();
        Assert.isNotNull((Object)this.pasteAction);
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setActiveWorkbenchPart(this.workbenchPart);
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.deleteAction = this.createDeleteAction();
        Assert.isNotNull((Object)this.deleteAction);
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setActiveWorkbenchPart(this.workbenchPart);
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void fillContextMenu(IMenuManager menuManager) {
        super.fillContextMenu(menuManager);
        this.updateActions(this.getContext().getSelection());
        MenuManager createChildMenuManager = new MenuManager("New Child");
        this.populateManager((IContributionManager)createChildMenuManager, this.createChildSubmenuActions, null);
        this.populateManager((IContributionManager)createChildMenuManager, this.createChildActions, null);
        menuManager.appendToGroup("group.new", (IContributionItem)createChildMenuManager);
        MenuManager createSiblingMenuManager = new MenuManager("New Sibling");
        this.populateManager((IContributionManager)createSiblingMenuManager, this.createSiblingSubmenuActions, null);
        this.populateManager((IContributionManager)createSiblingMenuManager, this.createSiblingActions, null);
        menuManager.appendToGroup("group.new", (IContributionItem)createSiblingMenuManager);
        menuManager.appendToGroup("group.edit", (IContributionItem)new ActionContributionItem((IAction)this.cutAction));
        menuManager.appendToGroup("group.edit", (IContributionItem)new ActionContributionItem((IAction)this.copyAction));
        menuManager.appendToGroup("group.edit", (IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
        menuManager.appendToGroup("group.edit", (IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.updateActions(this.getContext().getSelection());
        if (!this.isActivePropertySheet()) {
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.cutAction != null) {
            this.cutAction.setEditingDomain(null);
        }
        if (this.copyAction != null) {
            this.copyAction.setEditingDomain(null);
        }
        if (this.pasteAction != null) {
            this.pasteAction.setEditingDomain(null);
        }
        if (this.deleteAction != null) {
            this.deleteAction.setEditingDomain(null);
        }
    }

    protected void updateActions(ISelection selection) {
        TransactionalEditingDomain editingDomain = this.getEditingDomainFromSelection(selection);
        this.cutAction.setEditingDomain((EditingDomain)editingDomain);
        this.copyAction.setEditingDomain((EditingDomain)editingDomain);
        this.pasteAction.setEditingDomain((EditingDomain)editingDomain);
        this.deleteAction.setEditingDomain((EditingDomain)editingDomain);
        IStructuredSelection structuredSelection = SelectionUtil.getStructuredSelection((ISelection)selection);
        this.cutAction.selectionChanged(structuredSelection);
        this.copyAction.selectionChanged(structuredSelection);
        this.pasteAction.selectionChanged(structuredSelection);
        this.deleteAction.selectionChanged(structuredSelection);
        if (this.shouldCreateCreateChildActions(structuredSelection.getFirstElement())) {
            Collection<?> newChildDescriptors = null;
            Collection<?> newSiblingDescriptors = null;
            if (editingDomain != null && structuredSelection.size() == 1) {
                newChildDescriptors = this.getNewChildDescriptors(editingDomain, structuredSelection.getFirstElement(), null);
                newSiblingDescriptors = this.getNewChildDescriptors(editingDomain, null, structuredSelection.getFirstElement());
            }
            this.createChildActions = this.generateCreateChildActions(editingDomain, newChildDescriptors, selection);
            this.createChildSubmenuActions = this.extractSubmenuActions(this.createChildActions, selection);
            this.createSiblingActions = this.generateCreateSiblingActions(editingDomain, newSiblingDescriptors, selection);
            this.createSiblingSubmenuActions = this.extractSubmenuActions(this.createSiblingActions, selection);
        }
    }

    protected boolean shouldCreateCreateChildActions(Object object) {
        return true;
    }

    protected DeleteAction createDeleteAction() {
        return new ExtendedDeleteAction(this.removeAllReferencesOnDelete(), this.getCustomAdapterFactory());
    }

    protected PasteAction createPasteAction() {
        return new ExtendedPasteAction(this.getCustomAdapterFactory());
    }

    protected CopyAction createCopyAction() {
        return new ExtendedCopyAction(this.getCustomAdapterFactory());
    }

    protected CutAction createCutAction() {
        return new ExtendedCutAction(this.getCustomAdapterFactory());
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    protected Collection<?> getNewChildDescriptors(TransactionalEditingDomain editingDomain, Object object, Object sibling) {
        IEditingDomainItemProvider editingDomainItemProvider;
        AdapterFactory adapterFactory = this.getAdapterFactory(editingDomain);
        if (adapterFactory != null && (editingDomainItemProvider = (IEditingDomainItemProvider)adapterFactory.adapt(object, IEditingDomainItemProvider.class)) != null) {
            return editingDomainItemProvider.getNewChildDescriptors(object, (EditingDomain)editingDomain, sibling);
        }
        return Collections.emptyList();
    }

    protected AdapterFactory getAdapterFactory(TransactionalEditingDomain editingDomain) {
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    protected Collection<IAction> generateCreateChildActions(TransactionalEditingDomain editingDomain, Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null && selection instanceof IStructuredSelection) {
            for (Object descriptor : descriptors) {
                if (!(descriptor instanceof CommandParameter) || !this.getNewChildOrSiblingItemFilter().accept((IStructuredSelection)selection, (CommandParameter)descriptor)) continue;
                actions.add((IAction)this.createCreateChildAction(editingDomain, selection, descriptor));
            }
            Collections.sort(actions, new Comparator<IAction>(){

                @Override
                public int compare(IAction a1, IAction a2) {
                    if (a1.getText() == null && a2.getText() != null) {
                        return -1;
                    }
                    if (a1.getText() == null && a2.getText() == null) {
                        return 0;
                    }
                    if (a1.getText() != null && a2.getText() == null) {
                        return 1;
                    }
                    return CommonPlugin.INSTANCE.getComparator().compare(a1.getText(), a2.getText());
                }
            });
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(TransactionalEditingDomain editingDomain, Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null && selection instanceof IStructuredSelection) {
            for (Object descriptor : descriptors) {
                if (!(descriptor instanceof CommandParameter) || !this.getNewChildOrSiblingItemFilter().accept((IStructuredSelection)selection, (CommandParameter)descriptor)) continue;
                actions.add(this.createCreateSiblingAction(editingDomain, selection, descriptor));
            }
            Collections.sort(actions, new Comparator<IAction>(){

                @Override
                public int compare(IAction a1, IAction a2) {
                    if (a1.getText() == null && a2.getText() != null) {
                        return -1;
                    }
                    if (a1.getText() == null && a2.getText() == null) {
                        return 0;
                    }
                    if (a1.getText() != null && a2.getText() == null) {
                        return 1;
                    }
                    return CommonPlugin.INSTANCE.getComparator().compare(a1.getText(), a2.getText());
                }
            });
        }
        return actions;
    }

    protected ICommandParameterFilter getNewChildOrSiblingItemFilter() {
        if (this.newChildOrSiblingItemFilter == null) {
            this.newChildOrSiblingItemFilter = this.createNewChildOrSiblingItemFilter();
        }
        return this.newChildOrSiblingItemFilter;
    }

    protected ICommandParameterFilter createNewChildOrSiblingItemFilter() {
        return new BasicCommandParameterFilter();
    }

    protected CreateChildAction createCreateChildAction(TransactionalEditingDomain editingDomain, ISelection selection, Object descriptor) {
        return new CreateChildAction((EditingDomain)editingDomain, selection, descriptor);
    }

    protected IAction createCreateSiblingAction(TransactionalEditingDomain editingDomain, ISelection selection, Object descriptor) {
        return new CreateSiblingAction((EditingDomain)editingDomain, selection, descriptor);
    }
}

