/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.shellwax.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class BashShebangContentDescriber
implements ITextContentDescriber {
    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return this.describe(new InputStreamReader(contents), description);
    }

    public QualifiedName[] getSupportedOptions() {
        return null;
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        if (description == null || description.getContentType() == null || !"org.eclipse.shellwax.shebang".equals(description.getContentType().getId())) {
            return 0;
        }
        BufferedReader reader = new BufferedReader(contents);
        String line = reader.readLine();
        if (line == null) {
            return 0;
        }
        if (line.startsWith("#!") && (line.contains("bash") || line.contains("bin/sh"))) {
            return 2;
        }
        return 0;
    }
}

