/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.fileservice;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ExtendedPlanProValidator;
import org.eclipse.set.basis.files.PlanProFileResource;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.model.planpro.PlanPro.DocumentRoot;
import org.w3c.dom.Document;

public abstract class AbstractToolboxFile
implements ToolboxFile {
    private static final String NO = "no";
    protected static final String ENCODING = StandardCharsets.UTF_8.name();
    private HashMap<String, Document> domDocument = new HashMap();
    private String md5checksum = null;
    protected final HashMap<String, PlanProFileResource> resources = new HashMap();

    public void setXMLDocument(String docName, Document doc) {
        this.domDocument.put(docName, doc);
    }

    public Document getXMLDocument(String docName) {
        return this.domDocument.get(docName);
    }

    public void clearXMLDocument() {
        this.domDocument = new HashMap();
    }

    public String getChecksum() {
        return this.md5checksum;
    }

    protected void generateMD5CheckSum() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream input = new FileInputStream(this.getPath().toFile());){
            this.md5checksum = DigestUtils.md5Hex((InputStream)input).toUpperCase();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void modifyXmlDeclaration() {
        this.getPlanProResource().setStandalone(NO);
    }

    protected void loadResource(Path path, EditingDomain editingDomain) throws IOException {
        PlanProFileResource newResource;
        block3: {
            ExtendedPlanProValidator.registerValidator();
            ResourceSet resourceSet = editingDomain.getResourceSet();
            URI resourceUri = URI.createFileURI((String)PathExtensions.toLowerCaseExtension((Path)path).toString());
            newResource = (PlanProFileResource)resourceSet.getResource(resourceUri, false);
            if (newResource == null) {
                newResource = new PlanProFileResource(resourceUri);
                resourceSet.getResources().add((Object)newResource);
                try {
                    newResource.load(resourceSet.getLoadOptions());
                }
                catch (Resource.IOWrappedException e) {
                    if (e.getCause() instanceof FeatureNotFoundException || e.getCause() instanceof IllegalValueException) break block3;
                    throw e;
                }
            }
        }
        this.addResource(this.getContentType(path), newResource);
    }

    protected void addResource(String contentName, PlanProFileResource resource) {
        if (contentName == null || resource == null) {
            return;
        }
        this.resources.put(contentName, resource);
        this.modifyXmlDeclaration();
    }

    protected PlanProFileResource getResource(String contentName) {
        return this.resources.get(contentName);
    }

    protected void setResource(String contentName, PlanProFileResource resource) {
        this.resources.put(contentName, resource);
        this.modifyXmlDeclaration();
    }

    public void setResourcePath(Resource resource, Path path) {
        if (!resource.getURI().isFile()) {
            PlanProFileResource newResource = new PlanProFileResource(URI.createFileURI((String)path.toString()));
            this.getEditingDomain().getResourceSet().getResources().add((Object)newResource);
            newResource.setEncoding(ENCODING);
            if (!resource.getContents().isEmpty()) {
                newResource.getContents().addAll((Collection)resource.getContents());
            }
            this.resources.put(this.getContentType(path), newResource);
            this.modifyXmlDeclaration();
        } else {
            resource.setURI(URI.createFileURI((String)path.toString()));
        }
    }

    public void save() throws IOException {
        this.saveResource((XMLResource)this.getPlanProResource());
    }

    public void close() throws IOException {
        this.getEditingDomain().getResourceSet().getResources().clear();
        this.resources.values().forEach(resource -> resource.getContents().clear());
    }

    public DocumentRoot getPlanProDocumentRoot() {
        PlanProFileResource planProResource = this.getPlanProResource();
        if (planProResource == null) {
            return null;
        }
        EList contents = this.getPlanProResource().getContents();
        if (contents.isEmpty()) {
            return null;
        }
        return (DocumentRoot)contents.getFirst();
    }

    public org.eclipse.set.model.planpro.Layoutinformationen.DocumentRoot getLayoutDocumentRoot() {
        block3: {
            try {
                PlanProFileResource layoutResource = this.getLayoutResource();
                if (layoutResource != null) break block3;
                return null;
            }
            catch (UnsupportedOperationException e) {
                return null;
            }
        }
        EList contents = this.getLayoutResource().getContents();
        return contents.isEmpty() ? null : (org.eclipse.set.model.planpro.Layoutinformationen.DocumentRoot)contents.getFirst();
    }

    protected abstract void saveResource(XMLResource var1) throws IOException;

    protected abstract String getContentType(Path var1);
}

