/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Layoutinformationen.Bez_Lageplan_Blattschnitt_TypeClass;
import org.eclipse.set.model.planpro.Layoutinformationen.Bezeichnung_Lageplan_TypeClass;
import org.eclipse.set.model.planpro.Layoutinformationen.Lageplan;
import org.eclipse.set.model.planpro.Layoutinformationen.Lageplan_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Layoutinformationen.Lageplan_Blattschnitt;
import org.eclipse.set.model.planpro.Layoutinformationen.Lageplan_Blattschnitt_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.model.planpro.Layoutinformationen.Polygonzug_Ausrichtung_TypeClass;
import org.eclipse.set.model.planpro.Layoutinformationen.Polygonzug_Blattschnitt_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Lageplan_Blattschnitt_TypeClass;
import org.eclipse.set.model.siteplan.Coordinate;
import org.eclipse.set.model.siteplan.Layoutinfo;
import org.eclipse.set.model.siteplan.SheetCut;
import org.eclipse.set.model.siteplan.Siteplan;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class LayoutTransformator {
    public static ENUMGEOKoordinatensystem selectedCRS;
    private PlanPro_Layoutinfo layoutInfo;
    private PositionService positionService;
    private static Map<String, ENUMGEOKoordinatensystem> crsMap;

    static {
        crsMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{new Pair((Object)"DR0", (Object)ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_DR0), new Pair((Object)"CR0", (Object)ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_CR0), new Pair((Object)"FR0", (Object)ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_FR0), new Pair((Object)"ER0", (Object)ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_ER0)});
    }

    public LayoutTransformator(PlanPro_Layoutinfo layoutInfo, PositionService positionService) {
        if (selectedCRS == null) {
            LayoutTransformator.setCRS(ToolboxConfiguration.getDefaultSheetCutCRS());
        }
        this.layoutInfo = layoutInfo;
        this.positionService = positionService;
    }

    public void transformLayout(Siteplan siteplan) {
        EList _lageplan = null;
        if (this.layoutInfo != null) {
            _lageplan = this.layoutInfo.getLageplan();
        }
        if (_lageplan != null) {
            Consumer<Lageplan> _function = it -> {
                Layoutinfo layoutInfo = SiteplanFactory.eINSTANCE.createLayoutinfo();
                Identitaet_TypeClass _identitaet = it.getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                layoutInfo.setGuid(_wert);
                Lageplan_Bezeichnung_AttributeGroup _bezeichnung = it.getBezeichnung();
                Bezeichnung_Lageplan_TypeClass _bezeichnungLageplan = null;
                if (_bezeichnung != null) {
                    _bezeichnungLageplan = _bezeichnung.getBezeichnungLageplan();
                }
                String _wert_1 = null;
                if (_bezeichnungLageplan != null) {
                    _wert_1 = _bezeichnungLageplan.getWert();
                }
                layoutInfo.setLabel(_wert_1);
                Consumer<ID_Lageplan_Blattschnitt_TypeClass> _function_1 = it_1 -> layoutInfo.getSheetsCut().add((Object)this.transformSheetCut(it_1.getValue()));
                it.getIDLageplanBlattschnitt().forEach(_function_1);
                siteplan.getLayoutInfo().add((Object)layoutInfo);
            };
            _lageplan.forEach(_function);
        }
    }

    private SheetCut transformSheetCut(Lageplan_Blattschnitt sheetCut) {
        SheetCut result = SiteplanFactory.eINSTANCE.createSheetCut();
        Identitaet_TypeClass _identitaet = null;
        if (sheetCut != null) {
            _identitaet = sheetCut.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        result.setGuid(_wert);
        Lageplan_Blattschnitt_Bezeichnung_AttributeGroup _bezeichnung = null;
        if (sheetCut != null) {
            _bezeichnung = sheetCut.getBezeichnung();
        }
        Bez_Lageplan_Blattschnitt_TypeClass _bezLageplanBlattschnitt = null;
        if (_bezeichnung != null) {
            _bezLageplanBlattschnitt = _bezeichnung.getBezLageplanBlattschnitt();
        }
        BigInteger _wert_1 = null;
        if (_bezLageplanBlattschnitt != null) {
            _wert_1 = _bezLageplanBlattschnitt.getWert();
        }
        String _string = null;
        if (_wert_1 != null) {
            _string = _wert_1.toString();
        }
        result.setLabel(_string);
        EList _polygonDirection = result.getPolygonDirection();
        Polygonzug_Ausrichtung_TypeClass _polygonzugAusrichtung = sheetCut.getPolygonzugAusrichtung();
        String _wert_2 = null;
        if (_polygonzugAusrichtung != null) {
            _wert_2 = _polygonzugAusrichtung.getWert();
        }
        Iterable<Coordinate> _transformCoordinate = null;
        if (_wert_2 != null) {
            _transformCoordinate = this.transformCoordinate(_wert_2);
        }
        Iterables.addAll((Collection)_polygonDirection, _transformCoordinate);
        EList _polygon = result.getPolygon();
        Polygonzug_Blattschnitt_TypeClass _polygonzugBlattschnitt = sheetCut.getPolygonzugBlattschnitt();
        String _wert_3 = null;
        if (_polygonzugBlattschnitt != null) {
            _wert_3 = _polygonzugBlattschnitt.getWert();
        }
        Iterable<Coordinate> _transformCoordinate_1 = null;
        if (_wert_3 != null) {
            _transformCoordinate_1 = this.transformCoordinate(_wert_3);
        }
        Iterables.addAll((Collection)_polygon, _transformCoordinate_1);
        return result;
    }

    private Iterable<Coordinate> transformCoordinate(String coorString) {
        String[] coors = coorString.split(" ");
        LinkedList result = CollectionLiterals.newLinkedList();
        Procedures.Procedure2 _function = (value, index) -> {
            block4: {
                Coordinate coor = SiteplanFactory.eINSTANCE.createCoordinate();
                try {
                    if (index % 2 == 0) {
                        coor.setX(Double.valueOf(value).doubleValue());
                    } else {
                        Coordinate _get = (Coordinate)result.get(index - 1);
                        _get.setY(Double.valueOf(value).doubleValue());
                    }
                    result.add(coor);
                }
                catch (Throwable _t) {
                    if (_t instanceof NumberFormatException) break block4;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        };
        IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)coors)), (Procedures.Procedure2)_function);
        Functions.Function1 _function_1 = it -> it.getX() != 0.0 && it.getY() != 0.0;
        Functions.Function1 _function_2 = it -> this.positionService.transformCoordinate(it.getX(), it.getY(), selectedCRS);
        return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)result, (Functions.Function1)_function_1), (Functions.Function1)_function_2);
    }

    public static ENUMGEOKoordinatensystem setCRS(String newCRS) {
        selectedCRS = crsMap.getOrDefault(newCRS, ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_CR0);
        return selectedCRS;
    }
}

