/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Streams;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.core.services.geometry.PointObjectPositionService;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Geodaten.GEO_Punkt;
import org.eclipse.set.model.planpro.Ortung.FMA_Komponente;
import org.eclipse.set.model.planpro.PZB.PZB_Element;
import org.eclipse.set.model.planpro.Verweise.ID_GEO_Punkt_ohne_Proxy_TypeClass;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.GeoPunktExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.locationtech.jts.geom.Coordinate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@Component(service={PlazCheck.class, EventHandler.class}, property={"event.topics=geometryService/done"})
public class GeoCoordinateValid
extends AbstractPlazContainerCheck
implements PlazCheck,
EventHandler {
    private static final double TOLERANT = 0.1;
    @Reference
    GeoKanteGeometryService geometryService;
    @Reference
    PointObjectPositionService pointObjectPositionService;
    @Reference
    EventAdmin eventAdmin;
    static BigDecimal FMA_LATERAL_DISTANCE = BigDecimal.valueOf(0.85);
    static BigDecimal PZB_LATERAL_DISTANCE = BigDecimal.valueOf(1.05);

    public void handleEvent(Event event) {
        HashMap properties = new HashMap();
        properties.put("org.eclipse.e4.data", this.getClass());
        this.eventAdmin.sendEvent(new Event("plazmodel/check", properties));
    }

    @Override
    protected List<PlazError> run(MultiContainer_AttributeGroup container) {
        if (!this.geometryService.isFindGeometryComplete()) {
            return List.of(this.createProcessingWarning());
        }
        ArrayList<PlazError> result = new ArrayList<PlazError>();
        GeoCoordinateValid.getRelevantPOs(container).forEach(po -> po.getPunktObjektTOPKante().forEach(potk -> {
            double diff;
            if (GeoCoordinateValid.isNotDistinctCoordinateSystem(potk)) {
                result.add(this.createGeoCoordinateError((EObject)po, "Der Punkt_Objekt_Top_Kante des Punkt_Objekt: {GUID} w\u00fcrde auf mehrere GEO_Punkt mit gleichen Koordinatensystem verweisen", Map.of("GUID", po.getIdentitaet().getWert())));
                return;
            }
            GEOKanteCoordinate geoKanteCoordinate = this.getPointGEOCoordinate((Punkt_Objekt)po, (Punkt_Objekt_TOP_Kante_AttributeGroup)potk);
            if (geoKanteCoordinate == null || EObjectExtensions.getNullableObject((Object)geoKanteCoordinate, e -> e.getCoordinate()).isEmpty()) {
                return;
            }
            GEO_Punkt relevantGeoPunkt = GeoCoordinateValid.getSameCRSGEOPunkt(potk, geoKanteCoordinate.getCRS());
            if (relevantGeoPunkt == null) {
                return;
            }
            Coordinate coordinate = geoKanteCoordinate.getCoordinate();
            Coordinate gpCoordinate = GeoPunktExtensions.getCoordinate((GEO_Punkt)relevantGeoPunkt);
            if (gpCoordinate == null) {
                result.add(this.creatErrorReport(relevantGeoPunkt));
            }
            if ((diff = coordinate.distance(gpCoordinate)) > 0.1) {
                result.add(this.createErrorReport((Punkt_Objekt)po, (Punkt_Objekt_TOP_Kante_AttributeGroup)potk, relevantGeoPunkt, diff));
            }
        }));
        return result;
    }

    private static List<Punkt_Objekt> getRelevantPOs(MultiContainer_AttributeGroup container) {
        return ((Stream)Streams.stream((Iterable)container.getPunktObjekts()).parallel()).filter(po -> po.getPunktObjektTOPKante().stream().anyMatch(potk -> EObjectExtensions.getNullableObject((Object)potk, ele -> ele.getSeitlicherAbstand().getWert()).isPresent()) || po instanceof FMA_Komponente || po instanceof PZB_Element).toList();
    }

    private GEOKanteCoordinate getPointGEOCoordinate(Punkt_Objekt po, Punkt_Objekt_TOP_Kante_AttributeGroup potk) {
        BigDecimal lateralDistance = null;
        if (po instanceof PZB_Element) {
            lateralDistance = PZB_LATERAL_DISTANCE;
        } else if (po instanceof FMA_Komponente) {
            lateralDistance = FMA_LATERAL_DISTANCE;
        }
        if (lateralDistance != null) {
            ENUMLinksRechts side = EObjectExtensions.getNullableObject((Object)potk, point -> point.getSeitlicheLage().getWert()).orElse(null);
            if (side != null && side == ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS) {
                return this.pointObjectPositionService.getCoordinate(potk, lateralDistance.negate());
            }
            return this.pointObjectPositionService.getCoordinate(potk, lateralDistance);
        }
        return this.pointObjectPositionService.getCoordinate(potk);
    }

    private static GEO_Punkt getSameCRSGEOPunkt(Punkt_Objekt_TOP_Kante_AttributeGroup potk, ENUMGEOKoordinatensystem crs) {
        return potk.getIDGEOPunktBerechnet().stream().map(e -> e.getValue()).filter(Objects::nonNull).filter(gp -> {
            ENUMGEOKoordinatensystem geoPunktCRS = EObjectExtensions.getNullableObject((Object)gp, e -> e.getGEOPunktAllg().getGEOKoordinatensystem().getWert()).orElse(null);
            return geoPunktCRS != null && geoPunktCRS.equals((Object)crs);
        }).findFirst().orElse(null);
    }

    private PlazError creatErrorReport(GEO_Punkt gp) {
        GEO_Punkt errObj = gp;
        if (gp.getGEOPunktAllg() == null) {
            errObj = gp.getGEOPunktAllg();
        } else if (gp.getGEOPunktAllg().getGKX() == null) {
            errObj = gp.getGEOPunktAllg().getGKX();
        } else if (gp.getGEOPunktAllg().getGKY() == null) {
            errObj = gp.getGEOPunktAllg().getGKY();
        }
        return this.createGeoCoordinateError((EObject)errObj, "GEO_Punkt: {GUID} fehlt Koordinate", Map.of(gp.getIdentitaet().getWert(), "GUID"));
    }

    private PlazError createErrorReport(Punkt_Objekt po, Punkt_Objekt_TOP_Kante_AttributeGroup potk, GEO_Punkt gp, double diff) {
        ID_GEO_Punkt_ohne_Proxy_TypeClass errorObject = potk.getIDGEOPunktBerechnet().stream().filter(idgp -> idgp.getValue().equals(gp)).findFirst().orElse(null);
        if (errorObject == null) {
            throw new IllegalArgumentException(String.format("GEO_Punkt: %s geh\u00f6rt nicht zu Punkt_Objekt: %s", gp.getIdentitaet().getWert(), po.getIdentitaet().getWert()));
        }
        return this.createGeoCoordinateError((EObject)errorObject, "Die Koordinaten des referenzierten GEO_Punkt: {GEO_PUNKT_ID} weichen {DIFF} cm von der topologisch definierten Position ab.", Map.of("GEO_PUNKT_ID", errorObject.getWert(), "GUID", po.getIdentitaet().getWert(), "DIFF", new DecimalFormat("0.00").format(diff * 100.0)));
    }

    private PlazError createGeoCoordinateError(EObject object, String message, Map<String, String> data) {
        PlazError plazError = PlazFactory.eINSTANCE.createPlazError();
        plazError.setObject(object);
        plazError.setSeverity(ValidationSeverity.ERROR);
        plazError.setType(this.checkType());
        plazError.setMessage(StringSubstitutor.replace((Object)message, data, (String)"{", (String)"}"));
        return plazError;
    }

    @Override
    public String checkType() {
        return "Koordinate";
    }

    @Override
    public String getDescription() {
        return "Die topologische Verortung der berechneten Geo-Koordinaten sind plausibilisiert";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Die topologische Verortung des Punkt-Objekts stimmt nicht mit den berechneten Geo-Koordinaten \u00fcberein.";
    }

    private PlazError createProcessingWarning() {
        PlazError plazError = PlazFactory.eINSTANCE.createPlazError();
        plazError.setType(this.checkType());
        plazError.setSeverity(ValidationSeverity.WARNING);
        plazError.setMessage("Die Pr\u00fcfung auf ID_GEO_Punkt_Berechnen is noch nicht beenden");
        return plazError;
    }

    public static boolean isNotDistinctCoordinateSystem(Punkt_Objekt_TOP_Kante_AttributeGroup potk) {
        List<GEO_Punkt> givenGeoPunkts = potk.getIDGEOPunktBerechnet().stream().map(gp -> gp.getValue()).filter(Objects::nonNull).toList();
        if (givenGeoPunkts.isEmpty()) {
            return false;
        }
        Iterable notDistinctBy = IterableExtensions.notDistinctBy(givenGeoPunkts, gp -> EObjectExtensions.getNullableObject((Object)gp, e -> e.getGEOPunktAllg().getGEOKoordinatensystem().getWert()));
        return notDistinctBy.iterator().hasNext();
    }
}

