/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table;

import com.google.common.collect.Lists;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.ThreadUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.SpanningDataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.resize.command.RowHeightResetCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowRowInViewportCommand;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.constants.ToolboxViewState;
import org.eclipse.set.basis.extensions.MApplicationElementExtensions;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.basis.tables.Tables;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.configurationservice.UserConfigurationService;
import org.eclipse.set.feature.table.abstracttableview.ColumnGroup4HeaderLayer;
import org.eclipse.set.feature.table.abstracttableview.ColumnGroupGroupGroupHeaderLayer;
import org.eclipse.set.feature.table.abstracttableview.NatTableColumnGroupHelper;
import org.eclipse.set.feature.table.abstracttableview.ToolboxTableModelThemeConfiguration;
import org.eclipse.set.feature.table.messages.Messages;
import org.eclipse.set.feature.table.messages.MessagesWrapper;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.model.tablemodel.extensions.Headings;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.model.titlebox.extensions.TitleboxExtensions;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToFreeFieldTransformation;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToTitleboxTransformation;
import org.eclipse.set.services.export.ExportService;
import org.eclipse.set.services.export.TableCompileService;
import org.eclipse.set.services.table.TableService;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.RefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.DefaultToolboxEventHandler;
import org.eclipse.set.utils.events.JumpToSiteplanEvent;
import org.eclipse.set.utils.events.JumpToSourceLineEvent;
import org.eclipse.set.utils.events.JumpToTableEvent;
import org.eclipse.set.utils.events.SelectedControlAreaChangedEvent;
import org.eclipse.set.utils.events.TableDataChangeEvent;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.exception.ExceptionHandler;
import org.eclipse.set.utils.table.BodyLayerStack;
import org.eclipse.set.utils.table.Pt1TableChangeProperties;
import org.eclipse.set.utils.table.TableInfo;
import org.eclipse.set.utils.table.TableModelInstanceBodyDataProvider;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolboxTableView
extends BasePart {
    protected static final int DEBUG_WIDTH_CORRECTION = 0;
    private static Color GRAY_BACKGROUND = new Color((Device)Display.getCurrent(), 240, 240, 240);
    static final Logger logger = LoggerFactory.getLogger(ToolboxTableView.class);
    private BodyLayerStack bodyLayerStack;
    @Inject
    private TableCompileService compileService;
    @Inject
    private ExportService exportService;
    private NatTable natTable;
    private final List<TableRow> tableInstances = Lists.newLinkedList();
    private ToolboxEventHandler<JumpToTableEvent> tableSelectRowHandler;
    private ToolboxEventHandler<TableDataChangeEvent> tableDataChangeHandler;
    private ToolboxEventHandler<SelectedControlAreaChangedEvent> selectionControlAreaHandler;
    private int scrollToPositionRequested = -1;
    private StyledText tableFooting;
    @Inject
    @Translation
    Messages messages;
    @Inject
    UISynchronize sync;
    Table table;
    @Inject
    TableService tableService;
    @Inject
    TableMenuService tableMenuService;
    @Inject
    UserConfigurationService userConfigService;
    TableType tableType;
    Set<String> controlAreaIds;
    @Inject
    MessagesWrapper wrapper;
    private TableModelInstanceBodyDataProvider bodyDataProvider;

    public TableType getTableType() {
        return this.tableType;
    }

    private ExportType getExportType() {
        switch (this.tableType) {
            case FINAL: {
                return ExportType.INVENTORY_RECORDS;
            }
            case DIFF: {
                return ExportType.PLANNING_RECORDS;
            }
            case SINGLE: {
                return ExportType.PLANNING_RECORDS;
            }
        }
        throw new IllegalArgumentException(this.tableType.toString());
    }

    private FreeFieldInfo getFreeFieldInfo() {
        PlanProToFreeFieldTransformation planProToFreeField = PlanProToFreeFieldTransformation.create();
        return planProToFreeField.transform(this.getModelSession());
    }

    private Path getAttachmentPath(String guid) {
        try {
            return this.getModelSession().getToolboxFile().getMediaPath(Guid.create((String)guid));
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    private Titlebox getTitlebox(String shortcut) {
        PlanProToTitleboxTransformation planProToTitlebox = PlanProToTitleboxTransformation.create();
        Titlebox titlebox = planProToTitlebox.transform(this.getModelSession().getPlanProSchnittstelle(), this.tableService.getTableNameInfo(shortcut), this::getAttachmentPath);
        this.updateTitlebox(titlebox);
        return titlebox;
    }

    private boolean isDisplayedDataAffected(Container_AttributeGroup container) {
        if (this.tableType == TableType.DIFF) {
            return true;
        }
        return this.getModelSession().getContainer(this.tableType.getContainerForTable()) == container;
    }

    private void outdatedUpdate() {
        if (this.isOutdated()) {
            this.updateTableView(Collections.emptyList());
            this.setOutdated(false);
        }
    }

    @PostConstruct
    private void postConstruct() {
        this.tableSelectRowHandler = new DefaultToolboxEventHandler<JumpToTableEvent>(){

            public void accept(JumpToTableEvent t) {
                ToolboxTableView.this.tableSelectRowHandler(t);
            }
        };
        ToolboxEvents.subscribe((IEventBroker)this.getBroker(), JumpToTableEvent.class, this.tableSelectRowHandler);
        this.tableDataChangeHandler = new DefaultToolboxEventHandler<TableDataChangeEvent>(){

            public void accept(TableDataChangeEvent t) {
                if (!t.getProperties().isEmpty() && t.getProperties().getFirst() instanceof Pt1TableChangeProperties) {
                    t.getProperties().forEach(ele -> ToolboxTableView.this.bodyDataProvider.updateContent(ToolboxTableView.this.tableType, (Pt1TableChangeProperties)ele));
                    ToolboxTableView.this.natTable.refresh();
                }
            }
        };
        ToolboxEvents.subscribe((IEventBroker)this.getBroker(), TableDataChangeEvent.class, this.tableDataChangeHandler, (String)TableDataChangeEvent.getTopic((String)this.getTableShortcut()).toLowerCase());
        this.selectionControlAreaHandler = new DefaultToolboxEventHandler<SelectedControlAreaChangedEvent>(){

            public void accept(SelectedControlAreaChangedEvent t) {
                if (ToolboxTableView.this.getToolboxPart().getElementId().startsWith("org.eclipse.set.feature.table.estw") || t.getControlAreas().isEmpty()) {
                    ToolboxTableView.this.controlAreaIds.clear();
                    t.getControlAreas().forEach(area -> {
                        boolean bl = ToolboxTableView.this.controlAreaIds.add(area.areaId());
                    });
                    ToolboxTableView.this.tableType = t.getTableType();
                    ToolboxTableView.this.updateTableView(t.getControlAreas().isEmpty() ? Collections.emptyList() : List.of(TableInfo.Pt1TableCategory.ESTW));
                }
            }
        };
        ToolboxEvents.subscribe((IEventBroker)this.getBroker(), SelectedControlAreaChangedEvent.class, this.selectionControlAreaHandler);
    }

    @PreDestroy
    private void preDestroy() {
        logger.trace("preDestroy");
        ToolboxEvents.unsubscribe((IEventBroker)this.getBroker(), this.tableSelectRowHandler);
        ToolboxEvents.unsubscribe((IEventBroker)this.getBroker(), this.tableDataChangeHandler);
        ToolboxEvents.unsubscribe((IEventBroker)this.getBroker(), this.selectionControlAreaHandler);
        this.getBroker().send("modelsession/part/close", (Object)this.getTableShortcut().toLowerCase());
    }

    private String getTableShortcut() {
        return this.tableService.extractShortcut(this.getToolboxPart().getElementId());
    }

    private void tableSelectRowHandler(JumpToTableEvent event) {
        int rowIndex = TableExtensions.getLeadingObjectRowIndexByGUID((Table)this.table, (String)event.getSearchKey());
        if (rowIndex == -1) {
            return;
        }
        this.bodyLayerStack.getSelectionLayer().selectRow(0, rowIndex, false, false);
        this.scrollToPositionRequested = rowIndex;
    }

    private Table transformToTableModel(String elementId, IModelSession modelSession) {
        return this.tableService.transformToTable(elementId, this.tableType, modelSession, this.controlAreaIds);
    }

    private void updateTableView(List<TableInfo.Pt1TableCategory> tableCategories) {
        this.tableService.updateTable((BasePart)this, tableCategories, () -> {
            this.updateModel(this.getToolboxPart(), this.getModelSession());
            this.natTable.doCommand((ILayerCommand)new RowHeightResetCommand());
            this.natTable.refresh();
            this.updateButtons();
            this.updateFootnotes();
        }, this.tableInstances::clear);
    }

    private void updateFootnotes() {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int startOffset = 0;
        for (TableExtensions.FootnoteInfo footnote : TableExtensions.getAllFootnotes((Table)this.table)) {
            String text = footnote.toReferenceText();
            lines.add(text);
            switch (footnote.type) {
                case NEW_FOOTNOTE: {
                    styles.add(new StyleRange(startOffset, text.length(), new Color(255, 0, 0), null));
                    break;
                }
                case OLD_FOOTNOTE: {
                    styles.add(new StyleRange(startOffset, text.length(), null, new Color(255, 255, 0)));
                    break;
                }
            }
            startOffset += text.length() + 1;
        }
        this.tableFooting.setText(StringUtils.join(lines, (String)"\n"));
        this.tableFooting.setStyleRanges(styles.toArray(new StyleRange[0]));
    }

    private void updateTitlebox(Titlebox titlebox) {
        if (this.getExportType() == ExportType.INVENTORY_RECORDS) {
            TitleboxExtensions.set((Titlebox)titlebox, (int)81, (String)"B");
        }
    }

    protected void createView(Composite parent) {
        this.tableType = this.getModelSession().getTableType();
        this.controlAreaIds = this.getModelSession().getSelectedControlAreas().stream().map(Pair::getSecond).collect(Collectors.toSet());
        this.tableService.updateTable((BasePart)this, Collections.emptyList(), () -> this.updateModel(this.getToolboxPart(), this.getModelSession()), this.tableInstances::clear);
        if (this.table == null) {
            return;
        }
        ColumnDescriptor rootColumnDescriptor = (ColumnDescriptor)this.table.getColumndescriptors().get(0);
        if (logger.isDebugEnabled()) {
            logger.info(Headings.getTreeString((ColumnDescriptor)rootColumnDescriptor));
            logger.info(Headings.getWidthTestCsv((ColumnDescriptor)rootColumnDescriptor, input -> {
                if (input == null) {
                    return 0;
                }
                return ToolboxTableModelThemeConfiguration.toPixel(input.floatValue()) + 0;
            }));
        }
        Assert.isNotNull(this.tableInstances);
        this.bodyDataProvider = new TableModelInstanceBodyDataProvider(TableExtensions.getPropertyCount((Table)this.table), this.tableInstances);
        SpanningDataLayer bodyDataLayer = new SpanningDataLayer((ISpanningDataProvider)this.bodyDataProvider);
        this.bodyLayerStack = new BodyLayerStack((DataLayer)bodyDataLayer);
        this.bodyLayerStack.freezeColumns(this.tableService.getFixedColumns(this.getToolboxPart().getElementId()));
        SelectionLayer selectionLayer = this.bodyLayerStack.getSelectionLayer();
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(ColumnDescriptorExtensions.getColumnLabels((ColumnDescriptor)rootColumnDescriptor));
        DataLayer columnHeaderDataLayer = new DataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        boolean anyMatch = this.existsColumnGroup(rootColumnDescriptor);
        ColumnGroup4HeaderLayer headerLayer = anyMatch ? this.createGroupHeaderLayer(columnHeaderLayer, rootColumnDescriptor) : this.createHeaderLayer(columnHeaderLayer, rootColumnDescriptor);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)this.bodyDataProvider);
        DataLayer rowHeaderDataLayer = new DataLayer((IDataProvider)rowHeaderDataProvider, 40, 20);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)headerLayer);
        GridLayer gridLayer = new GridLayer((ILayer)this.bodyLayerStack, (ILayer)headerLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        this.natTable = new NatTable(parent, (ILayer)gridLayer, false);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 500).applyTo((Control)this.natTable);
        this.addMenuItems();
        this.natTable.addConfiguration((IConfiguration)this.tableMenuService.createMenuConfiguration(this.natTable, selectionLayer));
        this.natTable.configure();
        this.natTable.setTheme((ThemeConfiguration)new ToolboxTableModelThemeConfiguration(this.natTable, (AbstractLayer)columnHeaderDataLayer, (DataLayer)bodyDataLayer, gridLayer, rootColumnDescriptor, (AbstractLayer)this.bodyLayerStack, (IDataProvider)this.bodyDataProvider, this.getDialogService()));
        this.bodyLayerStack.getSelectionLayer().clear();
        this.tableFooting = new StyledText(parent, 2);
        this.tableFooting.setBackground(GRAY_BACKGROUND);
        this.updateFootnotes();
        this.tableFooting.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).minSize(-1, 500).applyTo((Control)this.tableFooting);
        this.getBanderole().setExportAction(new SelectableAction(){

            public String getText() {
                return ToolboxTableView.this.messages.ToolboxTableView_Export;
            }

            public void selected(SelectionEvent e) {
                ToolboxTableView.this.export();
            }
        });
        CommandStackListener commandStackListener = event -> this.sync.syncExec(this::updateButtons);
        this.getModelSession().getEditingDomain().getCommandStack().addCommandStackListener(commandStackListener);
        this.natTable.addDisposeListener(event -> this.getModelSession().getEditingDomain().getCommandStack().removeCommandStackListener(commandStackListener));
        this.natTable.addPaintListener(e -> {
            if (this.scrollToPositionRequested != -1) {
                this.natTable.doCommand((ILayerCommand)new ShowRowInViewportCommand(this.scrollToPositionRequested));
                this.scrollToPositionRequested = -1;
            }
        });
        this.updateButtons();
    }

    private boolean existsColumnGroup(ColumnDescriptor columnDescriptor) {
        if (ColumnDescriptorExtensions.isRoot((ColumnDescriptor)columnDescriptor)) {
            return columnDescriptor.getChildren().stream().anyMatch(this::existsColumnGroup);
        }
        if (ColumnDescriptorExtensions.isLeaf((ColumnDescriptor)columnDescriptor)) {
            return false;
        }
        if (columnDescriptor.getChildren().size() > 1) {
            return true;
        }
        return this.existsColumnGroup((ColumnDescriptor)columnDescriptor.getChildren().getFirst());
    }

    private ILayer createHeaderLayer(ColumnHeaderLayer columnHeaderLayer, ColumnDescriptor rootColumnDescriptor) {
        ColumnGroupModel columnGroupModel = new ColumnGroupModel();
        ColumnGroupHeaderLayer columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)columnHeaderLayer, this.bodyLayerStack.getSelectionLayer(), columnGroupModel);
        List columns = ColumnDescriptorExtensions.getColumns((ColumnDescriptor)rootColumnDescriptor);
        int i = 0;
        while (i < columns.size()) {
            String columnIdentifier = Tables.getColumnIdentifier((int)i);
            columnGroupHeaderLayer.addColumnsIndexesToGroup(columnIdentifier, new int[]{i++});
        }
        columnGroupHeaderLayer.setRowHeight(ToolboxTableModelThemeConfiguration.toPixel((float)ColumnDescriptorExtensions.getGroupRowHeight((ColumnDescriptor)rootColumnDescriptor)));
        return columnGroupHeaderLayer;
    }

    protected ColumnGroup4HeaderLayer createGroupHeaderLayer(ColumnHeaderLayer columnHeaderLayer, ColumnDescriptor rootColumnDescriptor) {
        ColumnGroupModel columnGroupModel = new ColumnGroupModel();
        ColumnGroupHeaderLayer columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)columnHeaderLayer, this.bodyLayerStack.getSelectionLayer(), columnGroupModel);
        NatTableColumnGroupHelper.addGroups(rootColumnDescriptor, columnGroupHeaderLayer);
        columnGroupHeaderLayer.setRowHeight(ToolboxTableModelThemeConfiguration.toPixel((float)ColumnDescriptorExtensions.getGroupRowHeight((ColumnDescriptor)rootColumnDescriptor)));
        ColumnGroupModel columnGroupGroupModel = new ColumnGroupModel();
        ColumnGroupGroupHeaderLayer columnGroupGroupHeaderLayer = new ColumnGroupGroupHeaderLayer(columnGroupHeaderLayer, columnGroupGroupModel);
        NatTableColumnGroupHelper.addGroupGroups(rootColumnDescriptor, columnGroupGroupHeaderLayer);
        columnGroupGroupHeaderLayer.setRowHeight(ToolboxTableModelThemeConfiguration.toPixel((float)ColumnDescriptorExtensions.getGroupGroupRowHeight((ColumnDescriptor)rootColumnDescriptor)));
        ColumnGroupModel columnGroupGroupGroupModel = new ColumnGroupModel();
        ColumnGroupGroupGroupHeaderLayer columnGroupGroupGroupHeaderLayer = new ColumnGroupGroupGroupHeaderLayer(columnGroupGroupHeaderLayer, columnGroupHeaderLayer, this.bodyLayerStack.getSelectionLayer(), columnGroupGroupGroupModel);
        NatTableColumnGroupHelper.addGroupGroupGroups(rootColumnDescriptor, columnGroupGroupGroupHeaderLayer);
        columnGroupGroupGroupHeaderLayer.setRowHeight(ToolboxTableModelThemeConfiguration.toPixel((float)ColumnDescriptorExtensions.getGroupGroupGroupRowHeight((ColumnDescriptor)rootColumnDescriptor)));
        ColumnGroupModel columnGroup4Model = new ColumnGroupModel();
        ColumnGroup4HeaderLayer columnGroup4HeaderLayer = new ColumnGroup4HeaderLayer(columnGroupGroupGroupHeaderLayer, columnGroupGroupHeaderLayer, columnGroupHeaderLayer, this.bodyLayerStack.getSelectionLayer(), columnGroup4Model);
        NatTableColumnGroupHelper.addColumnNumbers(rootColumnDescriptor, columnGroup4HeaderLayer);
        columnGroup4HeaderLayer.setRowHeight(ToolboxTableModelThemeConfiguration.toPixel((float)ColumnDescriptorExtensions.getGroup4RowHeight((ColumnDescriptor)rootColumnDescriptor)));
        return columnGroup4HeaderLayer;
    }

    protected SelectableAction getOutdatedAction() {
        return new RefreshAction((BasePart)this, e -> this.outdatedUpdate());
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        if (this.isDisplayedDataAffected(e.getContainer())) {
            this.setOutdated(true);
        }
    }

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        this.outdatedUpdate();
    }

    void export() {
        String shortcut = this.getTableShortcut();
        List<Thread> transformatorThreads = ThreadUtils.getAllThreads().stream().filter(t -> t != null && t.getName().startsWith(shortcut.toLowerCase()) && t.isAlive()).toList();
        if (!transformatorThreads.isEmpty() && !this.getDialogService().confirmExportNotCompleteTable(this.getToolboxShell())) {
            return;
        }
        Map tables = this.compileService.compile(shortcut, this.getModelSession(), this.controlAreaIds);
        Optional optionalOutputDir = this.getDialogService().selectDirectory(this.getToolboxShell(), this.userConfigService.getLastExportPath().toString());
        try {
            this.getDialogService().showProgress(this.getToolboxShell(), monitor -> optionalOutputDir.ifPresent(outputDir -> {
                monitor.beginTask(this.messages.ToolboxTableView_ExportTable, -1);
                this.exportService.exportPdf(tables, this.getExportType(), this.getTitlebox(shortcut), this.getFreeFieldInfo(), shortcut, outputDir, this.getModelSession().getToolboxPaths(), this.getModelSession().getTableType(), OverwriteHandling.forUserConfirmation(path -> this.getDialogService().confirmOverwrite(this.getToolboxShell(), path)), (Consumer)new ExceptionHandler(this.getToolboxShell(), this.getDialogService()));
            }));
            optionalOutputDir.ifPresent(outputDir -> {
                this.getDialogService().openDirectoryAfterExport(this.getToolboxShell(), Path.of(outputDir, new String[0]));
                this.userConfigService.setLastExportPath(Path.of(outputDir, new String[0]));
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Thread.currentThread().interrupt();
            this.getDialogService().error(this.getToolboxShell(), e);
        }
    }

    void updateButtons() {
        this.getBanderole().setEnableExport(this.getTableType() != TableType.INITIAL && !this.getModelSession().isDirty());
    }

    void updateModel(MPart part, IModelSession modelSession) {
        this.getBanderole().setTableType(this.tableType);
        this.table = this.transformToTableModel(part.getElementId(), modelSession);
        MApplicationElementExtensions.setViewState((MApplicationElement)part, (ToolboxViewState)ToolboxViewState.CREATED);
        this.tableInstances.clear();
        this.tableInstances.addAll(TableExtensions.getTableRows((Table)this.table));
    }

    private void addMenuItems() {
        this.tableMenuService.addMenuItem(this.tableMenuService.createShowInTextViewItem(this.createJumpToSourceLineEvent(), this.bodyLayerStack.getSelectionLayer(), rowPosition -> this.getRowReferenceObjectGuid(rowPosition) != null));
        this.tableMenuService.addMenuItem(this.tableMenuService.createShowInSitePlanItem(this.createJumpToSiteplanEvent(), this.bodyLayerStack.getSelectionLayer(), rowPosition -> {
            List tableRows = TableExtensions.getTableRows((Table)this.table);
            Ur_Objekt object = TableRowExtensions.getLeadingObject((TableRow)((TableRow)tableRows.get(rowPosition)));
            return object != null && Services.getSiteplanService().isSiteplanElement(object);
        }));
    }

    protected JumpToSourceLineEvent createJumpToSourceLineEvent() {
        return new JumpToSourceLineEvent(this){

            public String getObjectGuid() {
                Collection selectedCells = ToolboxTableView.this.bodyLayerStack.getSelectionLayer().getSelectedCells();
                if (selectedCells.isEmpty()) {
                    return null;
                }
                int rowPosition = ((ILayerCell)selectedCells.iterator().next()).getRowPosition();
                List tableRows = TableExtensions.getTableRows((Table)ToolboxTableView.this.table);
                return TableRowExtensions.getLeadingObjectGuid((TableRow)((TableRow)tableRows.get(rowPosition)));
            }
        };
    }

    protected JumpToSiteplanEvent createJumpToSiteplanEvent() {
        return new JumpToSiteplanEvent(this.getToolboxPart().getElementId()){

            public TableRow getRow() {
                Collection selectedCells = ToolboxTableView.this.bodyLayerStack.getSelectionLayer().getSelectedCells();
                if (selectedCells.isEmpty()) {
                    return null;
                }
                int rowPosition = ((ILayerCell)selectedCells.iterator().next()).getRowPosition();
                List tableRows = TableExtensions.getTableRows((Table)ToolboxTableView.this.table);
                return (TableRow)tableRows.get(rowPosition);
            }
        };
    }

    private String getRowReferenceObjectGuid(int rowPosition) {
        List tableRows = TableExtensions.getTableRows((Table)this.table);
        return TableRowExtensions.getLeadingObjectGuid((TableRow)((TableRow)tableRows.get(rowPosition)));
    }
}

