/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.geometry;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.basis.geometry.GEOKanteMetadata;
import org.eclipse.set.basis.geometry.GEOKanteSegment;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.core.services.geometry.PointObjectPositionService;
import org.eclipse.set.model.planpro.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.Strecke;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Gleis.ENUMGleisart;
import org.eclipse.set.model.planpro.Gleis.Gleis_Art;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Signale.Signal_Befestigung;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class PointObjectPositionServiceImpl
implements PointObjectPositionService {
    static double PUNKT_OBJEKT_LATERAL_DISTANCE_IN_STATION = 2.25;
    static double PUNKT_OBJEKT_LATERAL_DISTANCE_OTHER = 3.5;
    @Reference
    GeoKanteGeometryService geometryService;

    public PointObjectPositionServiceImpl() {
        Services.setPointObjectPositionService((PointObjectPositionService)this);
    }

    private GEOKanteCoordinate getSignalObjectCoordinate(Punkt_Objekt punktObjekt) {
        EList singlePoints = punktObjekt.getPunktObjektTOPKante();
        if (singlePoints == null || singlePoints.isEmpty()) {
            return null;
        }
        Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint = (Punkt_Objekt_TOP_Kante_AttributeGroup)singlePoints.getFirst();
        return this.getCoordinate(singlePoint);
    }

    public GEOKanteCoordinate getCoordinate(Punkt_Objekt punktObjekt) {
        if (punktObjekt instanceof Signal || punktObjekt instanceof Signal_Befestigung) {
            return this.getSignalObjectCoordinate(punktObjekt);
        }
        return this.geometryService.getCoordinateAt(punktObjekt, BigDecimal.ZERO);
    }

    public GEOKanteCoordinate getCoordinate(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        GEOKanteMetadata geoKante = this.getGeoKanteMetadata(singlePoint);
        if (geoKante == null) {
            return null;
        }
        BigDecimal lateralDistance = PointObjectPositionServiceImpl.getLateralDistance(singlePoint, geoKante);
        return this.getCoordinate(singlePoint, lateralDistance);
    }

    public GEOKanteCoordinate getCoordinate(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, BigDecimal lateralDistance) {
        GEOKanteMetadata geoKante = this.getGeoKanteMetadata(singlePoint);
        if (geoKante == null) {
            return null;
        }
        ENUMWirkrichtung direction = null;
        if (singlePoint.getWirkrichtung() != null) {
            direction = singlePoint.getWirkrichtung().getWert();
        }
        BigDecimal distance = singlePoint.getAbstand().getWert();
        if (direction == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_BEIDE) {
            return this.geometryService.getCoordinate(geoKante, distance, lateralDistance, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
        }
        return this.geometryService.getCoordinate(geoKante, distance, lateralDistance, direction);
    }

    private GEOKanteMetadata getGeoKanteMetadata(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        if (singlePoint == null || singlePoint.getAbstand() == null || singlePoint.getAbstand().getWert() == null) {
            return null;
        }
        BigDecimal distance = singlePoint.getAbstand().getWert();
        TOP_Kante topKante = singlePoint.getIDTOPKante().getValue();
        TOP_Knoten topKnotenA = topKante.getIDTOPKnotenA().getValue();
        return this.geometryService.getGeoKanteAt(topKante, topKnotenA, distance);
    }

    private static BigDecimal getLateralDistance(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, GEOKanteMetadata geoKante) {
        if (singlePoint.getSeitlicherAbstand() != null && singlePoint.getSeitlicherAbstand().getWert() != null) {
            return singlePoint.getSeitlicherAbstand().getWert();
        }
        BigDecimal distance = singlePoint.getAbstand().getWert();
        GEOKanteSegment segment = geoKante.getContainingSegment(distance);
        List<ENUMGleisart> trackType = segment.getBereichObjekte().stream().filter(Gleis_Art.class::isInstance).map(ga -> ((Gleis_Art)ga).getGleisart().getWert()).filter(c -> c != null).toList();
        if (trackType.isEmpty()) {
            return BigDecimal.ZERO;
        }
        double lateralDistance = trackType.getFirst() == ENUMGleisart.ENUM_GLEISART_STRECKENGLEIS ? PUNKT_OBJEKT_LATERAL_DISTANCE_OTHER : PUNKT_OBJEKT_LATERAL_DISTANCE_IN_STATION;
        ENUMLinksRechts side = EObjectExtensions.getNullableObject((Object)singlePoint, point -> point.getSeitlicheLage().getWert()).orElse(null);
        if (side != null && side == ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS) {
            return BigDecimal.valueOf(-lateralDistance);
        }
        return BigDecimal.valueOf(lateralDistance);
    }

    public Pair<GEOKanteCoordinate, BigDecimal> getProjectionOnStreck(Punkt_Objekt punktObjekt, Strecke strecke) {
        GEOKanteCoordinate coordinate = this.getCoordinate(punktObjekt);
        return this.geometryService.getProjectionCoordinateOnStrecke(coordinate.getCoordinate(), strecke);
    }
}

