/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.graph;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;

public class TopPath {
    private final List<TOP_Kante> edges;
    private final BigDecimal length;
    private final BigDecimal firstEdgeLength;
    private final TopPoint startNode;

    public TopPath(List<TOP_Kante> edges, BigDecimal length, BigDecimal firstEdgeLength) {
        this.edges = edges;
        this.length = length;
        this.firstEdgeLength = firstEdgeLength;
        this.startNode = this.determineStartNode();
    }

    public TopPath(List<TOP_Kante> edges, BigDecimal length, TopPoint startNode) {
        this.edges = edges;
        this.length = length;
        this.startNode = startNode;
        this.firstEdgeLength = this.determintFirstEdgeLength();
    }

    private TopPoint determineStartNode() {
        try {
            TOP_Kante firstEdge = this.edges.getFirst();
            BigDecimal edgeLength = firstEdge.getTOPKanteAllg().getTOPLaenge().getWert();
            if (this.firstEdgeLength.compareTo(BigDecimal.ZERO) == 0) {
                if (this.edges.size() == 1) {
                    if (this.length.compareTo(this.firstEdgeLength) != 0) {
                        throw new IllegalArgumentException();
                    }
                    return new TopPoint(firstEdge, edgeLength.subtract(this.firstEdgeLength));
                }
                TOP_Knoten connectTopKnoten = TopPath.getConnectTopKnoten(firstEdge, this.edges.get(1));
                BigDecimal distance = firstEdge.getIDTOPKnotenA().getValue() == connectTopKnoten ? BigDecimal.ZERO : edgeLength;
                return new TopPoint(firstEdge, distance);
            }
            return new TopPoint(firstEdge, edgeLength.subtract(this.firstEdgeLength));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't find start node of TopPath");
        }
    }

    private BigDecimal determintFirstEdgeLength() {
        try {
            BigDecimal connectTopKnotenDistance;
            TOP_Kante firstEdge = this.edges.getFirst();
            BigDecimal edgeLength = firstEdge.getTOPKanteAllg().getTOPLaenge().getWert();
            if (this.edges.size() == 1) {
                return this.length;
            }
            TOP_Knoten connectTopKnoten = TopPath.getConnectTopKnoten(firstEdge, this.edges.get(1));
            BigDecimal bigDecimal = connectTopKnotenDistance = connectTopKnoten == firstEdge.getIDTOPKnotenA().getValue() ? BigDecimal.ZERO : edgeLength;
            if (this.startNode.distance().compareTo(connectTopKnotenDistance) == 0) {
                return BigDecimal.ZERO;
            }
            return edgeLength.subtract(this.startNode.distance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't find first edge length of TopPath");
        }
    }

    private static TOP_Knoten getConnectTopKnoten(TOP_Kante firstEdge, TOP_Kante secondEdge) {
        String firstEdgeTopNodeA = firstEdge.getIDTOPKnotenA().getWert();
        if (firstEdgeTopNodeA.equals(secondEdge.getIDTOPKnotenA().getWert()) || firstEdgeTopNodeA.equals(secondEdge.getIDTOPKnotenB().getWert())) {
            return firstEdge.getIDTOPKnotenA().getValue();
        }
        String firstEdgeTopNodeB = firstEdge.getIDTOPKnotenB().getWert();
        if (firstEdgeTopNodeB.equals(secondEdge.getIDTOPKnotenA().getWert()) || firstEdgeTopNodeB.equals(secondEdge.getIDTOPKnotenB().getWert())) {
            return firstEdge.getIDTOPKnotenB().getValue();
        }
        throw new IllegalArgumentException(String.format("TOP_Kante %s und TOP_Kante %s sind nicht nacheinander liegen", firstEdge.getIdentitaet().getWert(), secondEdge.getIdentitaet().getWert()));
    }

    public List<TOP_Kante> edges() {
        return this.edges;
    }

    public BigDecimal length() {
        return this.length;
    }

    public BigDecimal firstEdgeLength() {
        return this.firstEdgeLength;
    }

    public Optional<BigDecimal> getDistance(TopPoint point) {
        BigDecimal pathOffset = this.firstEdgeLength;
        TOP_Kante previousEdge = null;
        for (TOP_Kante edge : this.edges()) {
            BigDecimal edgeLength = edge.getTOPKanteAllg().getTOPLaenge().getWert();
            if (point.edge().equals(edge)) {
                return this.getDistance(point, pathOffset, previousEdge, edge);
            }
            if (previousEdge != null) {
                pathOffset = pathOffset.add(edgeLength);
            }
            previousEdge = edge;
        }
        return Optional.empty();
    }

    private Optional<BigDecimal> getDistance(TopPoint point, BigDecimal pathOffset, TOP_Kante previousEdge, TOP_Kante edge) {
        BigDecimal edgeLength = edge.getTOPKanteAllg().getTOPLaenge().getWert();
        if (previousEdge == null) {
            return this.getDistanceOnFirstEdge(point, edgeLength);
        }
        if (previousEdge.getIDTOPKnotenB().getValue() == edge.getIDTOPKnotenA().getValue() || previousEdge.getIDTOPKnotenA().getValue() == edge.getIDTOPKnotenA().getValue()) {
            BigDecimal pointDistance = pathOffset.add(point.distance());
            if (pointDistance.compareTo(BigDecimal.ZERO) < 0 || pointDistance.compareTo(this.length) > 0) {
                return Optional.empty();
            }
            return Optional.of(pointDistance);
        }
        BigDecimal pointDistance = pathOffset.add(edgeLength).subtract(point.distance());
        if (pointDistance.compareTo(BigDecimal.ZERO) < 0 || pointDistance.compareTo(this.length) > 0) {
            return Optional.empty();
        }
        return Optional.of(pointDistance);
    }

    private Optional<BigDecimal> getDistanceOnFirstEdge(TopPoint point, BigDecimal edgeLength) {
        if (point.distance().compareTo(this.startNode.distance()) == 0) {
            return Optional.of(BigDecimal.ZERO);
        }
        boolean inTopDirection = edgeLength.subtract(this.startNode.distance()).compareTo(this.firstEdgeLength) == 0;
        if (inTopDirection == point.distance().compareTo(this.startNode.distance()) < 0) {
            return Optional.empty();
        }
        return Optional.of(point.distance().subtract(this.startNode.distance()).abs());
    }
}

