/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.constants;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.exceptions.CustomValidationProblem;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.xml.sax.SAXParseException;

public class ValidationResult {
    private final Class<? extends EObject> validatedSourceClass;
    private final List<CustomValidationProblem> customProblems = Lists.newLinkedList();
    private Diagnostic diagnostic;
    private final List<Exception> ioErrors = Lists.newLinkedList();
    private final List<ParserConfigurationException> parseError = new LinkedList<ParserConfigurationException>();
    private boolean passedXsdValidation = false;
    private final List<SAXParseException> saxErrors = new LinkedList<SAXParseException>();
    private final List<SAXParseException> saxWarnings = new LinkedList<SAXParseException>();
    private boolean validationSupported = true;

    public Class<? extends EObject> getValidatedSourceClass() {
        return this.validatedSourceClass;
    }

    public ValidationResult(Class<? extends EObject> validatedSourceClass) {
        this.validatedSourceClass = validatedSourceClass;
    }

    public void addCustomProblem(CustomValidationProblem customProblem) {
        this.customProblems.add(customProblem);
    }

    public void addIoError(Exception e) {
        this.ioErrors.add(e);
    }

    public void addParserException(ParserConfigurationException exception) {
        this.parseError.add(exception);
    }

    public void addXsdError(SAXParseException exception) {
        this.saxErrors.add(exception);
    }

    public void addXsdWarning(SAXParseException exception) {
        this.saxWarnings.add(exception);
    }

    public Outcome getCustomOutcome() {
        if (!this.validationSupported) {
            return Outcome.NOT_SUPPORTED;
        }
        Stream<CustomValidationProblem> errors = this.customProblems.stream().filter(x -> x.getSeverity() != ValidationSeverity.SUCCESS);
        if (errors.toList().isEmpty()) {
            return Outcome.VALID;
        }
        return Outcome.INVALID;
    }

    public List<CustomValidationProblem> getCustomProblems() {
        return this.customProblems;
    }

    public Outcome getEmfOutcome() {
        if (!this.validationSupported) {
            return Outcome.NOT_SUPPORTED;
        }
        if (this.getXsdOutcome() == Outcome.INVALID) {
            return Outcome.INVALID;
        }
        if (this.diagnostic != null && this.ioErrors.isEmpty() && this.diagnostic.getSeverity() == 0) {
            return Outcome.VALID;
        }
        return Outcome.INVALID;
    }

    public List<Exception> getIoErrors() {
        return this.ioErrors;
    }

    public Outcome getOutcome() {
        if (!this.validationSupported) {
            return Outcome.NOT_SUPPORTED;
        }
        if (this.getEmfOutcome() == Outcome.VALID && this.getXsdOutcome() == Outcome.VALID && this.getCustomOutcome() == Outcome.VALID) {
            return Outcome.VALID;
        }
        return Outcome.INVALID;
    }

    public List<ParserConfigurationException> getParserError() {
        return this.parseError;
    }

    public List<SAXParseException> getXsdErrors() {
        return this.saxErrors;
    }

    public Outcome getXsdOutcome() {
        if (!this.validationSupported) {
            return Outcome.NOT_SUPPORTED;
        }
        if (this.passedXsdValidation && this.ioErrors.isEmpty() && this.saxErrors.isEmpty() && this.saxWarnings.isEmpty() && this.parseError.isEmpty()) {
            return Outcome.VALID;
        }
        return Outcome.INVALID;
    }

    public List<SAXParseException> getXsdWarnings() {
        return this.saxWarnings;
    }

    public void put(Diagnostic newDiagnostic) {
        this.diagnostic = newDiagnostic;
    }

    public void setPassedXsdValidation(boolean value) {
        this.passedXsdValidation = value;
    }

    public void setValidationSupported(boolean value) {
        this.validationSupported = value;
    }

    public static enum FileValidateState {
        INVALID,
        INCOMPLETE,
        VALID;

    }

    public static enum Outcome {
        INVALID,
        NOT_SUPPORTED,
        VALID;

    }
}

