/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.handler;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.InitializationData;
import org.eclipse.set.basis.exceptions.UserAbortion;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.core.services.update.ModelUpdateService;
import org.eclipse.set.utils.Messages;
import org.eclipse.set.utils.handler.AbstractHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNewHandler<T extends InitializationData>
extends AbstractHandler {
    static final Logger logger = LoggerFactory.getLogger(AbstractNewHandler.class);
    @Inject
    protected SessionService sessionService;
    @Inject
    CacheService cacheService;
    @Inject
    DialogService dialogService;
    @Inject
    IEventBroker eventBroker;
    @Inject
    @Translation
    Messages messages;
    @Inject
    @Optional
    IModelSession modelSession;
    @Inject
    ModelUpdateService modelUpdateService;
    IModelSession newSession;

    public abstract IModelSession createNewSession(T var1);

    public abstract String getErrorCauseMessage();

    public abstract String getErrorMessage();

    public abstract String getErrorTitleMessage();

    public abstract String getSuccessMessage(Path var1);

    public abstract String getSuccessTitleMessage();

    public abstract String getTaskMessage();

    public abstract int openDialog(Shell var1, MApplication var2);

    public boolean save(T initializationData, Shell shell, MApplication application) {
        initializationData.setCreationDate(new Date());
        IRunnableWithProgress loadFileThread = new IRunnableWithProgress((InitializationData)initializationData, shell){
            private final /* synthetic */ InitializationData val$initializationData;
            private final /* synthetic */ Shell val$shell;
            {
                this.val$initializationData = initializationData;
                this.val$shell = shell;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(AbstractNewHandler.this.getTaskMessage(), -1);
                logger.trace("Loading session...");
                try {
                    AbstractNewHandler.this.newSession = AbstractNewHandler.this.createNewSession(this.val$initializationData);
                    boolean saved = AbstractNewHandler.this.newSession.saveNew(this.val$shell);
                    if (!saved) {
                        throw new SaveFailed();
                    }
                    AbstractNewHandler.this.newSession.refreshValidation();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).AbstractNewHandler.this.dialogService.openInformation(val$shell, AbstractNewHandler.this.getSuccessTitleMessage(), AbstractNewHandler.this.getSuccessMessage((this).AbstractNewHandler.this.newSession.getToolboxFile().getPath()));
                        }
                    });
                    AbstractNewHandler.this.newSession.getModels().forEach(m -> AbstractNewHandler.this.modelUpdateService.add(m));
                }
                catch (UserAbortion | SaveFailed e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
                logger.trace("Loading session done.");
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, false, loadFileThread);
            if (this.newSession != null) {
                application.getContext().set(IModelSession.class, (Object)this.newSession);
                this.eventBroker.send("modelsession/change/model", (Object)this.newSession.getPlanProSchnittstelle());
            }
        }
        catch (InterruptedException | InvocationTargetException ex) {
            InvocationTargetException ite;
            Throwable cause;
            if (ex instanceof InvocationTargetException && (cause = (ite = (InvocationTargetException)ex).getCause()) instanceof SaveFailed) {
                return false;
            }
            AbstractNewHandler.reportError(shell, ex, this.dialogService, this.getErrorTitleMessage(), this.getErrorMessage(), this.getErrorCauseMessage());
            return false;
        }
        return true;
    }

    public abstract void showInitPart(ToolboxPartService var1);

    @Execute
    private void execute(Shell shell, MApplication application, ToolboxPartService toolboxViewService) {
        if (this.modelSession != null && this.modelSession.isDirty() && !this.dialogService.confirmCloseUnsaved(shell)) {
            return;
        }
        if (this.modelSession != null) {
            this.modelSession.close();
        }
        toolboxViewService.clean();
        int result = this.openDialog(shell, application);
        if (result != 1) {
            this.showInitPart(toolboxViewService);
        }
        logger.trace("Execute done.");
    }

    protected DialogService getDialogService() {
        return this.dialogService;
    }

    private static class SaveFailed
    extends Exception {
    }
}

