/**
 * Copyright (c) 2017 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.ppmodel.extensions

import java.math.BigDecimal
import java.util.List
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup
import org.eclipse.set.model.planpro.Gleis.Gleis_Abschnitt
import org.eclipse.set.model.planpro.Ortung.FMA_Anlage

/**
 * This class extends {@link Gleis_Abschnitt}.
 * 
 * @author Schaefer
 */
class GleisAbschnittExtensions extends BereichObjektExtensions {

	/**
	 * @param abschnitt this Gleisabschnitt
	 * 
	 * @returns the FMA Anlagen monitoring this Gleisabschnitt
	 */
	def static List<FMA_Anlage> getFmaAnlagen(Gleis_Abschnitt abschnitt) {
		return abschnitt.container.FMAAnlage.filter [
			IDGleisAbschnitt?.wert == abschnitt.identitaet.wert
		].toList
	}

	/**
	 * Get overlapping distance of 
	 */
	def static BigDecimal getOverlappingDistance(Gleis_Abschnitt abschnitt,
		List<Bereich_Objekt_Teilbereich_AttributeGroup> botbs) {
		return botbs.fold(BigDecimal.ZERO, [ sum, botb |
			sum.add(getOverlappingLength(abschnitt, botb))
		])
	}

	def static boolean isBelongToConstrolArea(Gleis_Abschnitt abschnitt,
		Stell_Bereich area) {
		return abschnitt.getOverlappingDistance(area.bereichObjektTeilbereich).
			compareTo(BigDecimal.ZERO) > 0
	}
}
