/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.utils;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.exceptions.UserAbortion;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.fileservice.ToolboxIDResolver;
import org.eclipse.set.feature.projectdata.utils.ServiceProvider;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.utils.events.EditingCompleted;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractImportGroup {
    protected ServiceProvider serviceProvider;
    protected IModelSession modelSession;
    protected Button importButton;
    protected IEventBroker broker;
    protected boolean isImportSuccess;

    public AbstractImportGroup(ServiceProvider serviceProvider, IModelSession modelSession, IEventBroker broker) {
        this.serviceProvider = serviceProvider;
        this.modelSession = modelSession;
        this.broker = broker;
    }

    public static Group createGroup(Composite parent, Shell shell, String groupName) {
        Group group = new Group(parent, 16);
        group.setText(groupName);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout());
        return group;
    }

    protected void createImportButton(final Composite parent, String buttonName) {
        this.importButton = new Button(parent, 0);
        this.importButton.setText(buttonName);
        this.importButton.setEnabled(false);
        this.importButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractImportGroup.this.doImport(parent.getShell());
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
    }

    protected abstract void createControl(Composite var1, Shell var2, ToolboxFileRole var3);

    protected abstract void doImport(Shell var1);

    protected abstract void updateImportButton();

    protected abstract void resetGroup();

    protected void setImportSuccess(boolean success) {
        this.isImportSuccess = success;
    }

    protected void updateModelAfterImport(Shell shell) throws UserAbortion {
        ToolboxIDResolver.resolveIDReferences((PlanPro_Schnittstelle)this.modelSession.getPlanProSchnittstelle());
        this.modelSession.save(shell);
        this.serviceProvider.dialogService.reportImported(shell);
        this.resetGroup();
        ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new EditingCompleted());
        this.broker.send("modelsession/change/model", (Object)this.modelSession.getPlanProSchnittstelle());
    }
}

