/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.overview;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.feature.table.TableService;
import org.eclipse.set.feature.table.messages.Messages;
import org.eclipse.set.feature.table.messages.MessagesWrapper;
import org.eclipse.set.feature.table.overview.TableErrorTableView;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.TableNameInfo;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.DefaultToolboxEventHandler;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.events.SelectedControlAreaChangedEvent;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.table.TableError;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.event.EventHandler;

public class TableOverviewPart
extends BasePart {
    @Inject
    @Translation
    protected Messages messages;
    @Inject
    private EnumTranslationService enumTranslationService;
    @Inject
    private ToolboxPartService toolboxPartService;
    @Inject
    private IEventBroker broker;
    @Inject
    private TableService tableService;
    @Inject
    private TableMenuService tableMenuService;
    @Inject
    MessagesWrapper wrapper;
    private Label completenessHint;
    private Text missingTablesText;
    private Button calculateMissing;
    private Text withErrorsText;
    private Button openAllWithErrors;
    private TableErrorTableView tableErrorTableView;
    private final EventHandler tableErrorsChangeEventHandler = event -> this.onTableErrorsChange();
    private ToolboxEventHandler<SelectedControlAreaChangedEvent> selectionControlAreaHandler;
    private boolean ignoreChangeEvent = false;
    private Set<String> controlAreaIds = new HashSet<String>();

    protected void createView(Composite parent) {
        this.controlAreaIds = this.getModelSession().getSelectedControlAreas().stream().map(Pair::getSecond).collect(Collectors.toSet());
        this.completenessHint = new Label(parent, 0);
        this.completenessHint.setText(this.messages.TableOverviewPart_CompletenessHint);
        Color red = new Color((Device)parent.getDisplay(), 255, 0, 0);
        this.completenessHint.addDisposeListener(e -> red.dispose());
        this.completenessHint.setForeground(red);
        Group section = new Group(parent, 16);
        section.setText(this.messages.TableOverviewPart_TableSectionHeader);
        section.setLayoutData((Object)new GridData(4, 128, true, false));
        section.setLayout((Layout)new GridLayout(3, false));
        Label missingTablesDesc = new Label((Composite)section, 0);
        missingTablesDesc.setText(this.messages.TableOverviewPart_MissingTablesDesc);
        this.missingTablesText = new Text((Composite)section, 2048);
        this.missingTablesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.missingTablesText.setEnabled(false);
        this.calculateMissing = new Button((Composite)section, 0);
        this.calculateMissing.setText(this.messages.TableOverviewPart_CalculateMissing);
        this.calculateMissing.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableOverviewPart.this.calculateAllMissingTablesEvent();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        Label withErrorsDesc = new Label((Composite)section, 0);
        withErrorsDesc.setText(this.messages.TableOverviewPart_WithErrorsDesc);
        this.withErrorsText = new Text((Composite)section, 2048);
        this.withErrorsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.withErrorsText.setEnabled(false);
        this.openAllWithErrors = new Button((Composite)section, 0);
        this.openAllWithErrors.setText(this.messages.TableOverviewPart_OpenAllWithErrors);
        this.openAllWithErrors.setEnabled(false);
        this.openAllWithErrors.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableOverviewPart.this.openAllTablesWithErrors();
            }

            public void widgetSelected(SelectionEvent e) {
                TableOverviewPart.this.openAllTablesWithErrors();
            }
        });
        this.tableErrorTableView = new TableErrorTableView(this.messages, this, this.enumTranslationService, this.tableMenuService);
        this.tableErrorTableView.create(parent);
        this.getBroker().subscribe("modelsession/change/tableerror", this.tableErrorsChangeEventHandler);
        this.selectionControlAreaHandler = new DefaultToolboxEventHandler<SelectedControlAreaChangedEvent>(){

            public void accept(SelectedControlAreaChangedEvent t) {
                TableOverviewPart.this.controlAreaIds = t.getControlAreas().stream().map(SelectedControlAreaChangedEvent.ControlAreaValue::areaId).collect(Collectors.toSet());
                TableOverviewPart.this.update();
            }
        };
        ToolboxEvents.subscribe((IEventBroker)this.getBroker(), SelectedControlAreaChangedEvent.class, this.selectionControlAreaHandler);
        this.update();
    }

    private void onTableErrorsChange() {
        if (!this.ignoreChangeEvent) {
            this.update();
        }
    }

    private void calculateAllMissingTablesEvent() {
        this.ignoreChangeEvent = true;
        try {
            this.getDialogService().showProgress(this.getToolboxShell(), this::calculateAllMissingTables);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.getDialogService().error(this.getToolboxShell(), e);
        }
        this.ignoreChangeEvent = false;
        this.update();
    }

    private void calculateAllMissingTables(IProgressMonitor monitor) {
        Collection<String> missingTables = this.getMissingTables();
        monitor.beginTask(this.messages.TableOverviewPart_CalculateMissingTask, missingTables.size());
        TableType tableType = this.getModelSession().isSingleState() ? TableType.SINGLE : TableType.DIFF;
        for (String table : missingTables) {
            TableNameInfo info = this.tableService.getTableNameInfo(table);
            monitor.subTask(info.getFullDisplayName());
            this.tableService.transformToTable(table, tableType, this.getModelSession(), this.controlAreaIds);
            monitor.worked(1);
        }
    }

    private void openAllTablesWithErrors() {
        Collection<String> tablesWithErrors = this.getTablesContainingErrors();
        for (String shortCut : tablesWithErrors) {
            String tablePartIdPrefxix = this.getTableCategory() == "estw" ? "org.eclipse.set.feature.table.estw" : "org.eclipse.set.feature.table.etcs";
            this.toolboxPartService.showPart(String.format("%s.%s", tablePartIdPrefxix, shortCut));
        }
    }

    private Map<String, Collection<TableError>> getTableErrors() {
        return this.tableService.getTableErrors(this.getModelSession(), this.controlAreaIds, this.getTableCategory());
    }

    private String getTableCategory() {
        String elementId = this.getToolboxPart().getElementId();
        if (elementId.startsWith("org.eclipse.set.feature.table.estw")) {
            return "estw";
        }
        return "etcs";
    }

    private void update() {
        Collection<String> missingTables = this.getMissingTables();
        if (!ToolboxConfiguration.isDebugMode()) {
            this.missingTablesText.setText(this.tableList2DisplayString(missingTables));
            this.completenessHint.setVisible(!missingTables.isEmpty());
            this.calculateMissing.setEnabled(!missingTables.isEmpty());
        } else {
            this.missingTablesText.setText(this.messages.TableOverviewPart_DebugModeHint);
            this.completenessHint.setVisible(false);
        }
        Collection<String> tablesWithErrors = this.getTablesContainingErrors();
        this.withErrorsText.setText(this.tableList2DisplayString(tablesWithErrors));
        this.openAllWithErrors.setEnabled(!tablesWithErrors.isEmpty());
        ArrayList<TableError> allErrors = new ArrayList<TableError>();
        this.getTableErrors().values().forEach(allErrors::addAll);
        this.tableErrorTableView.updateView(allErrors);
    }

    private Collection<String> getMissingTables() {
        Map<String, Collection<TableError>> computedErrors = this.getTableErrors();
        List<String> allTableInfos = this.tableService.getAvailableTables().stream().filter(table -> table.category().equals(this.getTableCategory())).map(TableService.TableInfo::shortcut).toList();
        ArrayList<String> missingTables = new ArrayList<String>();
        missingTables.addAll(allTableInfos);
        if (!ToolboxConfiguration.isDebugMode()) {
            missingTables.removeAll(computedErrors.keySet());
        }
        return missingTables;
    }

    private Collection<String> getTablesContainingErrors() {
        Map<String, Collection<TableError>> computedErrors = this.getTableErrors();
        ArrayList<String> tablesWithErrors = new ArrayList<String>();
        for (Map.Entry<String, Collection<TableError>> entry : computedErrors.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            tablesWithErrors.add(entry.getKey());
        }
        return tablesWithErrors;
    }

    private String tableList2DisplayString(Collection<String> tables) {
        if (tables.isEmpty()) {
            return this.messages.TableOverviewPart_EmptyListText;
        }
        ArrayList<String> shortNames = new ArrayList<String>(tables.stream().map(shortCut -> this.tableService.getTableNameInfo((String)shortCut).getShortName()).toList());
        Collections.sort(shortNames);
        return shortNames.stream().collect(Collectors.joining(", "));
    }

    @PreDestroy
    private void unsubscribe() {
        this.broker.unsubscribe(this.tableErrorsChangeEventHandler);
        ToolboxEvents.unsubscribe((IEventBroker)this.broker, this.selectionControlAreaHandler);
    }

    @Inject
    public TableOverviewPart() {
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        this.setOutdated(true);
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        this.setOutdated(true);
    }

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        this.update();
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        this.update();
    }
}

