/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.set.utils.widgets.ComboValues;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class MultiSelectionCombo<T>
extends TableComboViewer {
    private ComboValues<T> values;
    private final List<String> selectedItems = new ArrayList<String>();
    private final String selectionAllLabel;

    public MultiSelectionCombo(Composite parent, String selectionAllLabel) {
        this(parent, selectionAllLabel, 2818);
    }

    public MultiSelectionCombo(Composite parent, String selectionAllLabel, int style) {
        super(parent, style);
        this.selectionAllLabel = selectionAllLabel;
        this.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.getTableCombo().setClosePopupAfterSelection(false);
        this.setLabelProvider((IBaseLabelProvider)new MultiSelectionLabelProvider(this));
        this.addSelectionChangedListener(this.getSelectionChangedListener());
        this.getTableCombo().setEditable(false);
        this.getTableCombo().setShowColorWithinSelection(false);
    }

    public ComboValues<T> getComboValues() {
        return this.values;
    }

    public void setComboValues(ComboValues<T> values) {
        this.removeAll();
        if (this.getTableCombo().isDisposed() || this.getTableCombo().getTable().isDisposed()) {
            return;
        }
        this.values = values;
        LinkedList<String> items = new LinkedList<String>();
        String[] comboValues = values.getComboValues();
        items.addAll(Arrays.asList(comboValues));
        if (comboValues.length > 2) {
            items.add(this.selectionAllLabel);
        }
        if (comboValues.length == 1) {
            this.getTableCombo().setEnabled(false);
            this.selectedItems.add(values.getDefaultValue());
        }
        this.setInput(items.toArray(new String[0]));
        this.select(values.getDefaultIndex());
    }

    public void select(int selectionIndex) {
        this.select(new int[]{selectionIndex});
    }

    public void select(int[] selectionIndexes) {
        this.doSelect(selectionIndexes);
    }

    public boolean isDisposed() {
        return this.getTableCombo().isDisposed() || this.getTableCombo().getTable().isDisposed();
    }

    public void setEnabled(boolean value) {
        this.getTableCombo().setEnabled(value);
    }

    public List<String> getSelectValuesString() {
        if (this.values != null && this.values.size() < 2) {
            return this.selectedItems;
        }
        return this.selectedItems.stream().filter(item -> !item.equals(this.values.getDefaultValue())).toList();
    }

    public String[] getItems() {
        return this.getTableCombo().getItems();
    }

    public List<T> getSelectionValues() {
        if (this.values != null && this.values.size() < 2) {
            return List.of(this.values.getValue(this.values.getDefaultIndex()));
        }
        return this.selectedItems.stream().filter(item -> !item.equals(this.values.getDefaultValue())).map(item -> this.values.getValue((String)item)).toList();
    }

    public void removeAll() {
        this.getTableCombo().clearSelection();
        this.getTableCombo().getTable().removeAll();
        this.selectedItems.clear();
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        return event -> {
            ISelection iSelection = event.getSelection();
            if (iSelection instanceof IStructuredSelection) {
                void selection;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
                Object object = selection.getFirstElement();
                if (object instanceof String) {
                    void item;
                    String string = (String)object;
                    String cfr_ignored_1 = (String)object;
                    this.toogleSelection((String)item);
                    Object object2 = event.getSource();
                    if (object2 instanceof TableComboViewer) {
                        void viewer;
                        TableComboViewer tableComboViewer = (TableComboViewer)object2;
                        TableComboViewer cfr_ignored_2 = (TableComboViewer)object2;
                        this.updateViewer((String)item, (TableComboViewer)viewer);
                    }
                }
            }
        };
    }

    private void updateViewer(String selectionItem, TableComboViewer viewer) {
        viewer.getTableCombo().setText(this.getComboText());
        if (selectionItem.equals(this.selectionAllLabel) || selectionItem.equals(this.values.getDefaultValue())) {
            String[] stringArray = this.values.getComboValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                viewer.update((Object)i, null);
                ++n2;
            }
        } else {
            viewer.update((Object)selectionItem, null);
        }
    }

    public String getComboText() {
        if (this.selectedItems.size() == 1 && this.selectedItems.getFirst().equals(this.values.getDefaultValue())) {
            return this.values.getDefaultValue();
        }
        return String.join((CharSequence)", ", this.selectedItems.stream().filter(i -> !i.equals(this.values.getDefaultValue())).toList());
    }

    private void toogleSelection(String item) {
        ArrayList<String> comboValues = new ArrayList<String>();
        comboValues.addAll(Arrays.asList(this.values.getComboValues()));
        if (comboValues.size() > 1) {
            comboValues.remove(this.values.getDefaultValue());
        }
        if (item.equals(this.values.getDefaultValue()) || item.equals(this.selectionAllLabel) && this.selectedItems.containsAll(comboValues)) {
            this.selectedItems.clear();
            this.selectedItems.add(this.values.getDefaultValue());
        } else if (item.equals(this.selectionAllLabel)) {
            comboValues.forEach(ele -> {
                if (!this.selectedItems.contains(ele)) {
                    this.selectedItems.add((String)ele);
                }
            });
        } else if (this.selectedItems.contains(item)) {
            this.selectedItems.remove(item);
            if (this.selectedItems.isEmpty()) {
                this.selectedItems.add(this.values.getDefaultValue());
            }
        } else {
            this.selectedItems.add(item);
        }
    }

    private static class MultiSelectionLabelProvider<T>
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        MultiSelectionCombo<T> selectionCombo;

        public MultiSelectionLabelProvider(MultiSelectionCombo<T> selectionCombo) {
            this.selectionCombo = selectionCombo;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public String getColumnText(Object element, int columnIndex) {
            Object object = element;
            if (object instanceof String) {
                void strElement;
                String string = (String)object;
                String cfr_ignored_0 = (String)object;
                return strElement;
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            if (this.isSelected(element)) {
                return Display.getCurrent().getSystemColor(15);
            }
            return Display.getCurrent().getSystemColor(1);
        }

        /*
         * WARNING - void declaration
         */
        private boolean isSelected(Object element) {
            Object object = element;
            if (object instanceof String) {
                void strElement;
                String string = (String)object;
                String cfr_ignored_0 = (String)object;
                return this.selectionCombo.getSelectValuesString().contains(strElement);
            }
            return false;
        }
    }
}

