/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.graph;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.set.basis.graph.TopPath;
import org.eclipse.set.utils.graph.AsDirectedTopGraph;
import org.eclipse.set.utils.graph.AsSplitTopGraph;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.GraphWalk;

public class DirectedPathSearch {
    private final Graph<AsSplitTopGraph.Node, AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> graph;
    private final AsSplitTopGraph.Node startNode;
    private final AsSplitTopGraph.Node endNode;
    private final List<AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> path;
    private final int maxPathWeight;
    private final Set<AsSplitTopGraph.Node> pathNodes;

    public Graph<AsSplitTopGraph.Node, AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> graph() {
        return this.graph;
    }

    public AsSplitTopGraph.Node startNode() {
        return this.startNode;
    }

    public AsSplitTopGraph.Node endNode() {
        return this.endNode;
    }

    public List<AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> path() {
        return this.path;
    }

    public int maxPathWeight() {
        return this.maxPathWeight;
    }

    public DirectedPathSearch(Graph<AsSplitTopGraph.Node, AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> graph, AsSplitTopGraph.Node startNode, AsSplitTopGraph.Node endNode, List<AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> path, int maxPathLength) {
        this.graph = graph;
        this.startNode = startNode;
        this.endNode = endNode;
        this.path = path;
        this.maxPathWeight = maxPathLength;
        this.pathNodes = new HashSet<AsSplitTopGraph.Node>();
        this.getPathNodes();
    }

    public DirectedPathSearch(Graph<AsSplitTopGraph.Node, AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> graph, AsSplitTopGraph.Node startNode, AsSplitTopGraph.Node endNode, int maxPathLength) {
        this(graph, startNode, endNode, new LinkedList<AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>>(), maxPathLength);
    }

    public DirectedPathSearch clonePath() {
        return new DirectedPathSearch(this.graph, this.startNode, this.endNode, new LinkedList<AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>>(this.path), this.maxPathWeight);
    }

    public boolean isCompletePath() {
        return this.startNode.equals(this.endNode) || !this.path.isEmpty() && ((AsSplitTopGraph.Node)this.graph.getEdgeTarget(this.path.getLast())).equals(this.endNode);
    }

    public boolean addEdge(AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge> edge) {
        if (this.getPathNodes().contains(this.graph.getEdgeTarget(edge))) {
            return false;
        }
        this.path.add(edge);
        this.pathNodes.add((AsSplitTopGraph.Node)this.graph.getEdgeSource(edge));
        this.pathNodes.add((AsSplitTopGraph.Node)this.graph.getEdgeTarget(edge));
        return true;
    }

    public Set<AsSplitTopGraph.Node> getPathNodes() {
        if (this.pathNodes.isEmpty()) {
            this.path.forEach(edge -> {
                this.pathNodes.add((AsSplitTopGraph.Node)this.graph.getEdgeSource(edge));
                this.pathNodes.add((AsSplitTopGraph.Node)this.graph.getEdgeTarget(edge));
            });
        }
        return this.pathNodes;
    }

    public boolean isRelevantPathLength() {
        return this.isRelevantPathWeight(0.0);
    }

    public boolean isRelevantPathWeight(double weight) {
        return this.maxPathWeight != 0 && DirectedPathSearch.getDirectedPathWeight(this.path).add(BigDecimal.valueOf(weight)).compareTo(BigDecimal.valueOf(this.maxPathWeight)) < 1;
    }

    public boolean isRelevantPathWeight(BigDecimal weight) {
        return this.maxPathWeight != 0 && BigDecimal.valueOf(this.maxPathWeight).subtract(DirectedPathSearch.getDirectedPathWeight(this.path).add(weight)).compareTo(BigDecimal.ZERO) >= 0;
    }

    public TopPath getTopPath(Predicate<TopPath> condition, boolean acceptIncompletePath) {
        if (!this.isCompletePath() && !acceptIncompletePath) {
            return null;
        }
        GraphPath<AsSplitTopGraph.Node, AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> completePath = DirectedPathSearch.makePath(this.graph, this.path, this.startNode);
        if (!(acceptIncompletePath || ((AsSplitTopGraph.Node)completePath.getStartVertex()).equals(this.startNode) && ((AsSplitTopGraph.Node)completePath.getEndVertex()).equals(this.endNode) && !(completePath.getWeight() > (double)this.maxPathWeight))) {
            return null;
        }
        TopPath topPath = DirectedPathSearch.pathTransform(completePath, this.startNode);
        return condition == null || condition.test(topPath) ? topPath : null;
    }

    private static TopPath pathTransform(GraphPath<AsSplitTopGraph.Node, AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> path, AsSplitTopGraph.Node startNode) {
        if (!((AsSplitTopGraph.Node)path.getStartVertex()).equals(startNode)) {
            throw new IllegalArgumentException("Path not start from source node");
        }
        return new TopPath(path.getEdgeList().stream().map(e -> (AsSplitTopGraph.Edge)e.edge()).distinct().map(AsSplitTopGraph.Edge::edge).toList(), DirectedPathSearch.getDirectedPathWeight(path), startNode.point().distance());
    }

    private static BigDecimal getDirectedPathWeight(GraphPath<AsSplitTopGraph.Node, AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> graphPath) {
        return DirectedPathSearch.getDirectedPathWeight(graphPath.getEdgeList());
    }

    private static BigDecimal getDirectedPathWeight(List<AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> path) {
        return path.stream().map(edge -> ((AsSplitTopGraph.Edge)edge.edge()).getWeight()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static GraphPath<AsSplitTopGraph.Node, AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> makePath(Graph<AsSplitTopGraph.Node, AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> directedGraph, List<AsDirectedTopGraph.DirectedTOPEdge<AsSplitTopGraph.Edge>> edges, AsSplitTopGraph.Node startNode) {
        if (edges.isEmpty()) {
            return GraphWalk.singletonWalk(directedGraph, (Object)startNode, (double)0.0);
        }
        AsSplitTopGraph.Node source = (AsSplitTopGraph.Node)directedGraph.getEdgeSource(edges.getFirst());
        AsSplitTopGraph.Node target = (AsSplitTopGraph.Node)directedGraph.getEdgeTarget(edges.getLast());
        double weight = edges.stream().mapToDouble(arg_0 -> directedGraph.getEdgeWeight(arg_0)).sum();
        return new GraphWalk(directedGraph, (Object)source, (Object)target, edges, weight);
    }
}

