/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.service;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.feature.plazmodel.check.GeoCoordinateValid;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.feature.plazmodel.service.PlazModelService;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.plazmodel.PlazReport;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.model.validationreport.ValidationreportFactory;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.xml.EObjectXMLFinder;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Component
public class PlazModelServiceImpl
implements PlazModelService {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<PlazCheck> checks = CollectionLiterals.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(PlazModelServiceImpl.class);
    private EObjectXMLFinder finder;

    @Override
    public PlazReport runPlazModel(IModelSession modelSession) {
        return this.runPlazModel(modelSession, this.checks);
    }

    @Override
    public <T extends PlazCheck> PlazReport runPlazModel(IModelSession modelSession, Class<T> checkClass) {
        Iterable _filter = Iterables.filter(this.checks, checkClass);
        return this.runPlazModel(modelSession, _filter);
    }

    private PlazReport runPlazModel(IModelSession modelSession, Iterable<PlazCheck> plazChecks) {
        boolean _lessThan;
        PlazReport report = PlazFactory.eINSTANCE.createPlazReport();
        try {
            EObjectXMLFinder _eObjectXMLFinder;
            ToolboxFile _toolboxFile = modelSession.getToolboxFile();
            Path _modelPath = modelSession.getToolboxFile().getModelPath();
            this.finder = _eObjectXMLFinder = new EObjectXMLFinder(_toolboxFile, _modelPath);
        }
        catch (Throwable _t) {
            if (_t instanceof EObjectXMLFinder.XmlParseException) {
                EObjectXMLFinder.XmlParseException exc = (EObjectXMLFinder.XmlParseException)_t;
                this.finder = null;
                logger.error("Parsing XML document failed", (Throwable)exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        HashMap errors = CollectionLiterals.newHashMap();
        Consumer<PlazCheck> _function = it -> {
            if (!ToolboxConfiguration.isDevelopmentMode() && it instanceof GeoCoordinateValid) {
                return;
            }
            errors.put(it, it.run(modelSession));
        };
        plazChecks.forEach(_function);
        LinkedList entries = CollectionLiterals.newLinkedList();
        int m = 0;
        int n = 0;
        int _size = errors.size();
        boolean _while = _lessThan = m < _size;
        while (_while) {
            boolean _lessThan_1;
            boolean _tripleEquals;
            int startCount = n;
            List errorsList = ((List[])Conversions.unwrapArray(errors.values(), List.class))[m];
            Set _keySet = errors.keySet();
            PlazCheck _get = null;
            if ((PlazCheck[])Conversions.unwrapArray(_keySet, PlazCheck.class) != null) {
                _get = ((PlazCheck[])Conversions.unwrapArray(_keySet, PlazCheck.class))[m];
            }
            String _generalErrMsg = null;
            if (_get != null) {
                _generalErrMsg = _get.getGeneralErrMsg();
            }
            String generalErroMsg = _generalErrMsg;
            int _length = ((Object[])Conversions.unwrapArray((Object)errorsList, Object.class)).length;
            boolean bl = _tripleEquals = _length == 0;
            if (_tripleEquals) {
                entries.add(this.sucessfulReport(((PlazCheck[])Conversions.unwrapArray(errors.keySet(), PlazCheck.class))[m], n));
            } else {
                Procedures.Procedure2 _function_1 = (error, index) -> entries.add(this.transform((PlazError)error, index + startCount, this.finder, generalErroMsg));
                IterableExtensions.forEach((Iterable)errorsList, (Procedures.Procedure2)_function_1);
            }
            int _n = ++n;
            int _length2 = ((Object[])Conversions.unwrapArray((Object)((List[])Conversions.unwrapArray(errors.values(), List.class))[m], Object.class)).length;
            n = _n + _length2;
            int _size_1 = errors.size();
            _while = _lessThan_1 = ++m < _size_1;
        }
        PlazModelService.sortAndIndexedProblems(entries);
        report.getEntries().addAll((Collection)entries);
        return report;
    }

    public ValidationProblem transform(PlazError error, int index, EObjectXMLFinder finder, String generalErroMsg) {
        ValidationProblem entry = ValidationreportFactory.eINSTANCE.createValidationProblem();
        Node node = finder.find(error.getObject());
        entry.setId(index + 1);
        entry.setMessage(error.getMessage());
        entry.setType(error.getType());
        entry.setSeverity(error.getSeverity());
        entry.setGeneralMsg(generalErroMsg);
        if (node != null) {
            int line;
            block4: {
                line = 0;
                try {
                    line = finder.getLineNumber(node);
                }
                catch (Throwable _t) {
                    if (_t instanceof NullPointerException) break block4;
                    if (_t instanceof EObjectXMLFinder.LineNotFoundException) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Line number not found for PlaZ entry with index ");
                        int _id = entry.getId();
                        _builder.append((Object)_id);
                        logger.warn(_builder.toString());
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            entry.setLineNumber(line);
            entry.setObjectArt(finder.getObjectType(node));
            entry.setObjectScope(finder.getObjectScope(node));
            entry.setObjectState(finder.getObjectState(node));
            entry.setAttributeName(finder.getAttributeName(node));
        }
        return entry;
    }

    public ValidationProblem sucessfulReport(PlazCheck check, int index) {
        ValidationProblem entry = ValidationreportFactory.eINSTANCE.createValidationProblem();
        entry.setId(index + 1);
        entry.setSeverity(ValidationSeverity.SUCCESS);
        entry.setType(check.checkType());
        entry.setMessage(check.getDescription());
        entry.setObjectScope(ObjectScope.CONTENT);
        return entry;
    }
}

