/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.cacheservice;

import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.eclipse.set.basis.MissingSupplier;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.utils.ToolboxConfiguration;

public class CacheImpl
implements Cache {
    private final String cacheId;
    private final com.google.common.cache.Cache<String, Object> cache;

    public CacheImpl(String cacheId) {
        this.cacheId = cacheId;
        this.cache = CacheImpl.buildCache();
    }

    private static com.google.common.cache.Cache<String, Object> buildCache() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (ToolboxConfiguration.isDevelopmentMode()) {
            cacheBuilder = cacheBuilder.recordStats();
        }
        return cacheBuilder.build();
    }

    public <T> T get(String key, MissingSupplier<T> valueLoader) {
        Object value;
        block3: {
            value = this.cache.get((Object)key, () -> valueLoader.get());
            if (value != MissingSupplier.MISSING_VALUE) break block3;
            this.cache.invalidate((Object)key);
            return null;
        }
        try {
            return (T)value;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(String key, Object value) {
        this.cache.put((Object)key, value);
    }

    public String stats() {
        return this.cacheId + " " + this.cache.stats().toString();
    }

    public Object getIfPresent(String key) {
        return this.cache.getIfPresent((Object)key);
    }

    public Iterable<Object> values() {
        return this.cache.asMap().values();
    }

    public void invalidate() {
        this.cache.invalidateAll();
    }

    public Collection<String> getKeys() {
        return this.cache.asMap().keySet();
    }
}

