/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.attachment;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.set.basis.attachments.Attachment;
import org.eclipse.set.basis.attachments.FileKind;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.utils.attachment.Attachments;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class AttachmentsImpl
extends Attachments {
    Attachment loadInternal(Shell shell, FileKind fileKind, DialogService dialogService, List<ToolboxFileFilter> extensions) throws ToolboxFileFilter.InvalidFilterFilename {
        Optional optionalPath = dialogService.openFileDialog(shell, extensions, Optional.empty());
        if (optionalPath.isPresent()) {
            Path path = (Path)optionalPath.get();
            ToolboxFileFilter.check(extensions, (Path)path);
            byte[] content = null;
            Path pathFilename = path.getFileName();
            content = AttachmentsImpl.getContent((Path)path);
            return new Attachments.AttachmentImpl(pathFilename, fileKind, content);
        }
        return null;
    }

    protected void exportInternal(Shell shell, Attachment attachment, DialogService dialogService, Path exportDir, Consumer<Path> newExportDirConsumer) {
        String dirname;
        DirectoryDialog dialog = new DirectoryDialog(shell);
        if (exportDir != null) {
            dialog.setFilterPath(exportDir.toString());
        }
        if ((dirname = dialog.open()) != null) {
            boolean overwrite;
            Path path = Paths.get(dirname, attachment.getFullFilename());
            if (path.toFile().exists() && !(overwrite = dialogService.confirmOverwrite(shell, path))) {
                return;
            }
            byte[] data = attachment.getData();
            try {
                Throwable throwable = null;
                Object var11_14 = null;
                try (FileOutputStream stream = new FileOutputStream(path.toString());){
                    stream.write(data);
                    dialogService.openDirectoryAfterExport(shell, path.getParent());
                    newExportDirConsumer.accept(path.getParent());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                dialogService.error(shell, (Exception)e1);
            }
        }
    }
}

