/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.exception.AreaNotContinuous;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TeilFahrweg {
    public Bereich_Objekt bereichObjekt;
    public Punkt_Objekt start;
    public Punkt_Objekt end;
    private int startPosition;
    private int endPosition;
    private double startAbstand;
    private double endAbstand;
    private List<TOP_Kante> sortedTopKanten;

    public TeilFahrweg(Fstr_Fahrweg fstrFahrweg, Punkt_Objekt start, Punkt_Objekt end) {
        Functions.Function1 _function = t -> BereichObjektExtensions.getTopKante(t);
        List topKanten = ListExtensions.map((List)fstrFahrweg.getBereichObjektTeilbereich(), (Functions.Function1)_function);
        TOP_Kante startTopKante = BereichObjektExtensions.getTopKanteFor((Bereich_Objekt)fstrFahrweg, PunktObjektExtensions.getSinglePoints(start));
        TOP_Kante endTopKante = BereichObjektExtensions.getTopKanteFor((Bereich_Objekt)fstrFahrweg, PunktObjektExtensions.getSinglePoints(end));
        this.startAbstand = this.getAbstand(start, startTopKante);
        this.endAbstand = this.getAbstand(end, endTopKante);
        try {
            this.bereichObjekt = fstrFahrweg;
            this.start = start;
            this.end = end;
            this.sortedTopKanten = this.sortTopKanten(topKanten, startTopKante, endTopKante);
            this.startPosition = this.getPosition(startTopKante);
            this.endPosition = this.getPosition(endTopKante);
            Assert.isTrue((this.startPosition > -1 ? 1 : 0) != 0);
            Assert.isTrue((this.endPosition > -1 ? 1 : 0) != 0);
            Assert.isTrue((this.startPosition <= this.endPosition ? 1 : 0) != 0);
        }
        catch (Throwable _t) {
            if (_t instanceof AreaNotContinuous) {
                throw new AreaNotContinuous(startTopKante, endTopKante, topKanten);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public double getAbstand(Punkt_Objekt punktObjekt, TOP_Kante topKante) {
        boolean _not;
        Functions.Function1 _function = p -> {
            TOP_Kante _topKante = PunktObjektTopKanteExtensions.getTopKante(p);
            return Objects.equals(_topKante, topKante);
        };
        List singlePoints = IterableExtensions.toList((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function));
        boolean _isEmpty = singlePoints.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            int _size = singlePoints.size();
            boolean _equals = _size == 1;
            Assert.isTrue((boolean)_equals);
            Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint = (Punkt_Objekt_TOP_Kante_AttributeGroup)singlePoints.get(0);
            return singlePoint.getAbstand().getWert().doubleValue();
        }
        Functions.Function1 _function_1 = it -> PunktObjektTopKanteExtensions.getTopKante(it);
        Functions.Function1 _function_2 = it -> TopKanteExtensions.isConnectedTo(it, topKante);
        List adjacentKanten = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        boolean _isEmpty_1 = adjacentKanten.isEmpty();
        boolean _not_1 = !_isEmpty_1;
        Assert.isTrue((boolean)_not_1);
        TOP_Kante adjacentKante = (TOP_Kante)adjacentKanten.get(0);
        TOP_Knoten A = TopKanteExtensions.getTOPKnotenA(topKante);
        TOP_Knoten B = TopKanteExtensions.getTOPKnotenB(topKante);
        TOP_Knoten C = TopKanteExtensions.connectionTo(topKante, adjacentKante);
        boolean _equals_1 = Objects.equals(A, C);
        if (_equals_1) {
            return 0.0;
        }
        boolean _equals_2 = Objects.equals(B, C);
        if (_equals_2) {
            return topKante.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue();
        }
        throw new IllegalArgumentException();
    }

    private List<TOP_Kante> sortTopKanten(List<TOP_Kante> topKanten, TOP_Kante start, TOP_Kante end) {
        int _size_1;
        int _minus;
        LinkedList<TOP_Kante> result = new LinkedList<TOP_Kante>();
        Functions.Function1 _function = t -> !Objects.equals(t, start);
        List rest = IterableExtensions.toList((Iterable)IterableExtensions.filter(topKanten, (Functions.Function1)_function));
        int _size = rest.size();
        boolean _equals = _size == (_minus = (_size_1 = topKanten.size()) - 1);
        Assert.isTrue((boolean)_equals);
        boolean _equals_1 = Objects.equals(start, end);
        if (_equals_1) {
            int _size_2 = rest.size();
            boolean _equals_2 = _size_2 == 0;
            Assert.isTrue((boolean)_equals_2);
            result.add(start);
            return result;
        }
        Functions.Function1 _function_1 = it -> TopKanteExtensions.isConnectedTo(it, start);
        List connectedToStart = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)rest, (Functions.Function1)_function_1));
        boolean _isEmpty = connectedToStart.isEmpty();
        if (_isEmpty) {
            throw new AreaNotContinuous();
        }
        int _size_3 = connectedToStart.size();
        boolean _equals_3 = _size_3 == 1;
        Assert.isTrue((boolean)_equals_3);
        TOP_Kante newStart = (TOP_Kante)connectedToStart.get(0);
        result.add(start);
        result.addAll(this.sortTopKanten(rest, newStart, end));
        return result;
    }

    private int getPosition(TOP_Kante topKante) {
        int size = this.sortedTopKanten.size();
        int i = 0;
        while (i < size) {
            TOP_Kante _get = this.sortedTopKanten.get(i);
            boolean _equals = Objects.equals(_get, topKante);
            if (_equals) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public double intersectionLength(Bereich_Objekt object) {
        Functions.Function2 _function = (result, p) -> {
            double _intersectionLength = this.intersectionLength((Bereich_Objekt_Teilbereich_AttributeGroup)p);
            return result + _intersectionLength;
        };
        Double result2 = (Double)IterableExtensions.fold((Iterable)object.getBereichObjektTeilbereich(), (Object)0.0, (Functions.Function2)_function);
        return result2;
    }

    public double intersectionLength(Bereich_Objekt_Teilbereich_AttributeGroup portion) {
        TOP_Kante topKante = BereichObjektExtensions.getTopKante(portion);
        int portionPosition = this.getPosition(topKante);
        if (portionPosition > this.startPosition && portionPosition < this.endPosition) {
            return BereichObjektExtensions.getLength(portion).doubleValue();
        }
        if (portionPosition == this.startPosition && portionPosition == this.endPosition) {
            return this.intersectionLengthOnSingleEdge(portion);
        }
        if (portionPosition == this.startPosition) {
            return this.intersectionLengthOnStartEdge(portion);
        }
        if (portionPosition == this.endPosition) {
            return this.intersectionLengthOnEndEdge(portion);
        }
        return 0.0;
    }

    private double intersectionLengthOnSingleEdge(Bereich_Objekt_Teilbereich_AttributeGroup portion) {
        TOP_Kante topKanteStart = this.sortedTopKanten.get(this.startPosition);
        TOP_Kante topKanteEnd = this.sortedTopKanten.get(this.endPosition);
        TOP_Kante topKantePortion = BereichObjektExtensions.getTopKante(portion);
        boolean _equals = Objects.equals(topKanteStart, topKanteEnd);
        Assert.isTrue((boolean)_equals);
        boolean _equals_1 = Objects.equals(topKanteStart, topKantePortion);
        Assert.isTrue((boolean)_equals_1);
        double begrenzungA = portion.getBegrenzungA().getWert().doubleValue();
        double begrenzungB = portion.getBegrenzungB().getWert().doubleValue();
        Assert.isTrue((begrenzungA <= begrenzungB ? 1 : 0) != 0);
        if (this.startAbstand <= this.endAbstand) {
            return this.intersectionLength(this.startAbstand, this.endAbstand, begrenzungA, begrenzungB);
        }
        return this.intersectionLength(this.endAbstand, this.startAbstand, begrenzungA, begrenzungB);
    }

    private double intersectionLength(double a1, double a2, double b1, double b2) {
        Assert.isTrue((a1 <= a2 ? 1 : 0) != 0);
        Assert.isTrue((b1 <= b2 ? 1 : 0) != 0);
        if (b1 <= a1) {
            if (b2 <= a1) {
                return 0.0;
            }
            if (b2 <= a2) {
                return b2 - a1;
            }
            return a2 - a1;
        }
        if (b1 <= a2) {
            if (b2 <= a2) {
                return b2 - b1;
            }
            return a2 - b1;
        }
        return 0.0;
    }

    private double intersectionLengthOnStartEdge(Bereich_Objekt_Teilbereich_AttributeGroup portion) {
        TOP_Kante startTopKante = this.sortedTopKanten.get(this.startPosition);
        TOP_Kante adjacentTopKante = this.sortedTopKanten.get(this.startPosition + 1);
        TOP_Knoten A = TopKanteExtensions.getTOPKnotenA(startTopKante);
        TOP_Knoten B = TopKanteExtensions.getTOPKnotenB(startTopKante);
        TOP_Knoten C = TopKanteExtensions.connectionTo(startTopKante, adjacentTopKante);
        Assert.isNotNull((Object)C);
        double portionA = portion.getBegrenzungA().getWert().doubleValue();
        double portionB = portion.getBegrenzungB().getWert().doubleValue();
        Assert.isTrue((portionA <= portionB ? 1 : 0) != 0);
        boolean _equals = Objects.equals(B, C);
        if (_equals) {
            return this.intersectionLengthRight(this.startAbstand, portionA, portionB);
        }
        boolean _equals_1 = Objects.equals(A, C);
        if (_equals_1) {
            return this.intersectionLengthLeft(this.startAbstand, portionA, portionB);
        }
        return 0.0;
    }

    private double intersectionLengthOnEndEdge(Bereich_Objekt_Teilbereich_AttributeGroup portion) {
        TOP_Kante endTopKante = this.sortedTopKanten.get(this.endPosition);
        TOP_Kante adjacentTopKante = this.sortedTopKanten.get(this.endPosition - 1);
        TOP_Knoten A = TopKanteExtensions.getTOPKnotenA(endTopKante);
        TOP_Knoten B = TopKanteExtensions.getTOPKnotenB(endTopKante);
        TOP_Knoten C = TopKanteExtensions.connectionTo(endTopKante, adjacentTopKante);
        Assert.isNotNull((Object)C);
        double portionA = portion.getBegrenzungA().getWert().doubleValue();
        double portionB = portion.getBegrenzungB().getWert().doubleValue();
        Assert.isTrue((portionA <= portionB ? 1 : 0) != 0);
        boolean _equals = Objects.equals(B, C);
        if (_equals) {
            return this.intersectionLengthRight(this.endAbstand, portionA, portionB);
        }
        boolean _equals_1 = Objects.equals(A, C);
        if (_equals_1) {
            return this.intersectionLengthLeft(this.endAbstand, portionA, portionB);
        }
        return 0.0;
    }

    private double intersectionLengthRight(double p, double a, double b) {
        if (p <= a) {
            return b - a;
        }
        if (p <= b) {
            return b - p;
        }
        return 0.0;
    }

    private double intersectionLengthLeft(double p, double a, double b) {
        if (b <= p) {
            return b - a;
        }
        if (a <= p) {
            return p - a;
        }
        return 0.0;
    }
}

