/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.model.planpro.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Abstand_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Begrenzung_A_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Begrenzung_B_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Seitliche_Lage_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Seitlicher_Abstand_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Verweise.ID_TOP_Kante_TypeClass;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class PunktObjektTopKanteExtensions
extends BasisObjektExtensions {
    public static String getIdentitaet(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        EObject _eContainer = singlePoint.eContainer();
        Ur_Objekt container = (Ur_Objekt)_eContainer;
        Identitaet_TypeClass _identitaet = null;
        if (container != null) {
            _identitaet = container.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        String containerId = _wert;
        List containedPots = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)container.eContents(), Punkt_Objekt_TOP_Kante_AttributeGroup.class));
        int index = containedPots.indexOf(singlePoint);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(containerId);
        _builder.append("/");
        _builder.append((Object)index);
        return _builder.toString();
    }

    public static TOP_Kante getTopKante(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        ID_TOP_Kante_TypeClass _iDTOPKante = singlePoint.getIDTOPKante();
        TOP_Kante _value = null;
        if (_iDTOPKante != null) {
            _value = _iDTOPKante.getValue();
        }
        return _value;
    }

    public static GeoPosition getCoordinate(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, ENUMWirkrichtung direction) {
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        double abstand = singlePoint.getAbstand().getWert().doubleValue();
        BigDecimal _elvis = null;
        Seitlicher_Abstand_TypeClass _seitlicherAbstand = null;
        if (singlePoint != null) {
            _seitlicherAbstand = singlePoint.getSeitlicherAbstand();
        }
        BigDecimal _wert = null;
        if (_seitlicherAbstand != null) {
            _wert = _seitlicherAbstand.getWert();
        }
        _elvis = _wert != null ? _wert : BigDecimal.ZERO;
        double lateralDistance = _elvis.doubleValue();
        return TopKanteExtensions.getCoordinate(topKante, abstand, lateralDistance, direction);
    }

    public static GeoPosition getCoordinate(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        Wirkrichtung_TypeClass _wirkrichtung = singlePoint.getWirkrichtung();
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        ENUMWirkrichtung direction = _wert;
        return PunktObjektTopKanteExtensions.getCoordinate(singlePoint, direction);
    }

    public static Set<TOP_Knoten> getTopKnoten(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        int _compare_1;
        boolean _equals_1;
        boolean _equals;
        HashSet<TOP_Knoten> result = new HashSet<TOP_Knoten>();
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        if (topKante == null) {
            return result;
        }
        double abstand = TopKanteExtensions.getAbstand(topKante, singlePoint);
        double length = topKante.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue();
        int _compare = Distance.compare(abstand, 0.0);
        boolean bl = _equals = _compare == 0;
        if (_equals) {
            result.add(TopKanteExtensions.getTOPKnotenA(topKante));
        }
        boolean bl2 = _equals_1 = (_compare_1 = Distance.compare(abstand, length)) == 0;
        if (_equals_1) {
            result.add(TopKanteExtensions.getTOPKnotenB(topKante));
        }
        return result;
    }

    public static Punkt_Objekt getPunktObjekt(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        EObject _eContainer = singlePoint.eContainer();
        return (Punkt_Objekt)_eContainer;
    }

    public static List<Punkt_Objekt_TOP_Kante_AttributeGroup> getSinglePoints(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        return Lists.newArrayList((Object[])new Punkt_Objekt_TOP_Kante_AttributeGroup[]{singlePoint});
    }

    public static Pair<GeoPosition, GeoPosition> getPerpendicularLineAtPoint(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        double abstand = singlePoint.getAbstand().getWert().doubleValue();
        Wirkrichtung_TypeClass _wirkrichtung = singlePoint.getWirkrichtung();
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        ENUMWirkrichtung wirkrichtung = _wert;
        GeoPosition firstCoordinate = TopKanteExtensions.getCoordinate(topKante, abstand, -1.0, wirkrichtung);
        GeoPosition secondCoordinate = TopKanteExtensions.getCoordinate(topKante, abstand, 1.0, wirkrichtung);
        return Pair.of((Object)firstCoordinate, (Object)secondCoordinate);
    }

    public static boolean isWirkrichtungTopDirection(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        ENUMLinksRechts seitlicheLage;
        ENUMWirkrichtung wirkrichtung;
        Wirkrichtung_TypeClass _wirkrichtung = null;
        if (singlePoint != null) {
            _wirkrichtung = singlePoint.getWirkrichtung();
        }
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        if ((wirkrichtung = _wert) != null && (wirkrichtung == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN || wirkrichtung == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN)) {
            return wirkrichtung == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN;
        }
        Seitliche_Lage_TypeClass _seitlicheLage = null;
        if (singlePoint != null) {
            _seitlicheLage = singlePoint.getSeitlicheLage();
        }
        ENUMLinksRechts _wert_1 = null;
        if (_seitlicheLage != null) {
            _wert_1 = _seitlicheLage.getWert();
        }
        if ((seitlicheLage = _wert_1) != null) {
            switch (seitlicheLage) {
                case ENUM_LINKS_RECHTS_LINKS: {
                    return false;
                }
                case ENUM_LINKS_RECHTS_RECHTS: {
                    return true;
                }
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("POTK: ");
            String _identitaet = PunktObjektTopKanteExtensions.getIdentitaet(singlePoint);
            _builder.append(_identitaet);
            _builder.append(" has no wirkrichtung");
            throw new UnsupportedOperationException(_builder.toString());
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("POTK: ");
        String _identitaet = PunktObjektTopKanteExtensions.getIdentitaet(singlePoint);
        _builder.append(_identitaet);
        _builder.append(" has no wirkrichtung");
        throw new UnsupportedOperationException(_builder.toString());
    }

    public static boolean isBelongToBereichObjekt(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, Bereich_Objekt bo) {
        Functions.Function1 _function = botb -> {
            Number _elvis = null;
            Begrenzung_A_TypeClass _begrenzungA = botb.getBegrenzungA();
            BigDecimal _wert = null;
            if (_begrenzungA != null) {
                _wert = _begrenzungA.getWert();
            }
            _elvis = _wert != null ? _wert : Integer.valueOf(0);
            double limitA = _elvis.doubleValue();
            Number _elvis_1 = null;
            Begrenzung_B_TypeClass _begrenzungB = botb.getBegrenzungB();
            BigDecimal _wert_1 = null;
            if (_begrenzungB != null) {
                _wert_1 = _begrenzungB.getWert();
            }
            _elvis_1 = _wert_1 != null ? _wert_1 : Integer.valueOf(0);
            double limitB = _elvis_1.doubleValue();
            Number _elvis_2 = null;
            Abstand_TypeClass _abstand = null;
            if (singlePoint != null) {
                _abstand = singlePoint.getAbstand();
            }
            BigDecimal _wert_2 = null;
            if (_abstand != null) {
                _wert_2 = _abstand.getWert();
            }
            _elvis_2 = _wert_2 != null ? _wert_2 : Integer.valueOf(0);
            double position = _elvis_2.doubleValue();
            return limitA < position && position < limitB || limitB < position && position < limitA;
        };
        return IterableExtensions.exists((Iterable)bo.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }
}

