/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.feature.siteplan.TrackSwitchMetadata;
import org.eclipse.set.feature.siteplan.TrackSwitchMetadataProvider;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.TrackSwitchLeg;
import org.eclipse.set.feature.siteplan.transform.TransformUtils;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.planpro.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Geodaten.ENUMTOPAnschluss;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.ENUMWKrArt;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.ENUMWKrGspStellart;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.ENUMWeicheBetriebsart;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Anlage;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Anlage_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Art_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Grundform_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Stellart_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Weiche_Betriebsart_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Weiche_Element_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Weiche_Vorzugslage_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Zungenpruefkontakt_Anzahl_TypeClass;
import org.eclipse.set.model.siteplan.ContinuousTrackSegment;
import org.eclipse.set.model.siteplan.Coordinate;
import org.eclipse.set.model.siteplan.Label;
import org.eclipse.set.model.siteplan.LeftRight;
import org.eclipse.set.model.siteplan.RouteObject;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.model.siteplan.SiteplanState;
import org.eclipse.set.model.siteplan.TrackSwitch;
import org.eclipse.set.model.siteplan.TrackSwitchComponent;
import org.eclipse.set.model.siteplan.TrackSwitchEndMarker;
import org.eclipse.set.model.siteplan.TurnoutOperatingMode;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.WKrAnlageExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspElementExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class TrackSwitchTransformator
extends BaseTransformator<W_Kr_Anlage> {
    @Reference
    private GeoKanteGeometryService geometryService;
    @Reference
    private PositionService positionService;
    private static final String ERROR_NO_TRACK_SWITCH_LEG = "Weichenschenkel der Weiche nicht bestimmbar.";
    private static final String ERROR_NO_TRACK_SWITCH_METADATA = "Unbekannte Weichenbauform. Art: \"%s\" Grundform: \"%s\".";
    private TrackSwitchMetadataProvider trackSwitchMetadataProvider;

    public TrackSwitchTransformator() {
        block2: {
            TrackSwitchMetadataProvider _trackSwitchMetadataProvider;
            this.trackSwitchMetadataProvider = _trackSwitchMetadataProvider = new TrackSwitchMetadataProvider();
            try {
                this.trackSwitchMetadataProvider.initialize();
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) break block2;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @Override
    public void transform(W_Kr_Anlage trackswitch) {
        boolean _greaterEqualsThan;
        boolean _tripleEquals;
        TrackSwitch result = SiteplanFactory.eINSTANCE.createTrackSwitch();
        result.setGuid(trackswitch.getIdentitaet().getWert());
        StringConcatenation _builder = new StringConcatenation();
        ENUMWKrArt _wert = trackswitch.getWKrAnlageAllg().getWKrArt().getWert();
        _builder.append((Object)_wert);
        _builder.append(" ");
        String _wert_1 = trackswitch.getWKrAnlageAllg().getWKrGrundform().getWert();
        _builder.append(_wert_1);
        result.setDesign(_builder.toString());
        TrackSwitchMetadata metadata = this.trackSwitchMetadataProvider.getTrackSwitchMetadata(trackswitch.getWKrAnlageAllg().getWKrArt().getWert(), trackswitch.getWKrAnlageAllg().getWKrGrundform().getWert());
        List elements = WKrAnlageExtensions.getWKrGspElemente((W_Kr_Anlage)trackswitch);
        W_Kr_Gsp_Element firstElement = (W_Kr_Gsp_Element)IterableExtensions.head((Iterable)elements);
        List components = WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)firstElement);
        int _length = ((Object[])Conversions.unwrapArray((Object)components, Object.class)).length;
        boolean bl = _tripleEquals = _length == 0;
        if (_tripleEquals) {
            Identitaet_TypeClass _identitaet = trackswitch.getIdentitaet();
            String _wert_2 = null;
            if (_identitaet != null) {
                _wert_2 = _identitaet.getWert();
            }
            this.recordError(_wert_2, ERROR_NO_TRACK_SWITCH_LEG);
            return;
        }
        TrackSwitchLeg legA = TrackSwitchLeg.getLeg(components, metadata, 0);
        TrackSwitchLeg legB = TrackSwitchLeg.getLeg(components, metadata, 1);
        if (legA == null || legB == null) {
            Identitaet_TypeClass _identitaet_1 = trackswitch.getIdentitaet();
            String _wert_3 = null;
            if (_identitaet_1 != null) {
                _wert_3 = _identitaet_1.getWert();
            }
            this.recordError(_wert_3, ERROR_NO_TRACK_SWITCH_LEG);
            return;
        }
        TrackSwitchComponent component = this.transformElement(trackswitch, firstElement, legA, legB);
        result.getComponents().add((Object)component);
        int _length_1 = ((Object[])Conversions.unwrapArray((Object)elements, Object.class)).length;
        boolean bl2 = _greaterEqualsThan = _length_1 >= 2;
        if (_greaterEqualsThan) {
            TOP_Kante _tOPKante_1;
            boolean _tripleEquals_1;
            W_Kr_Gsp_Element secondElement = (W_Kr_Gsp_Element)elements.get(1);
            List secondComponents = WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)secondElement);
            TrackSwitchLeg legC = TrackSwitchLeg.getLeg(secondComponents, metadata, 0);
            TrackSwitchLeg legD = TrackSwitchLeg.getLeg(secondComponents, metadata, 1);
            TOP_Kante _tOPKante = legC.getTOPKante();
            boolean bl3 = _tripleEquals_1 = _tOPKante == (_tOPKante_1 = legA.getTOPKante());
            if (_tripleEquals_1) {
                TrackSwitchLeg temp = legC;
                legC = legD;
                legD = temp;
            }
            if (legC == null || legD == null) {
                Identitaet_TypeClass _identitaet_2 = trackswitch.getIdentitaet();
                String _wert_4 = null;
                if (_identitaet_2 != null) {
                    _wert_4 = _identitaet_2.getWert();
                }
                this.recordError(_wert_4, ERROR_NO_TRACK_SWITCH_LEG);
                return;
            }
            result.getComponents().add((Object)this.transformElement(trackswitch, secondElement, legC, legD));
            ENUMWKrArt _wert_5 = trackswitch.getWKrAnlageAllg().getWKrArt().getWert();
            boolean _equals = Objects.equals(_wert_5, ENUMWKrArt.ENUMW_KR_ART_DKW);
            if (_equals) {
                result.getContinuousSegments().add((Object)this.getContinousSegment(legA, legC));
                result.getContinuousSegments().add((Object)this.getContinousSegment(legB, legD));
            } else {
                ENUMWKrArt _wert_6 = trackswitch.getWKrAnlageAllg().getWKrArt().getWert();
                boolean _equals_1 = Objects.equals(_wert_6, ENUMWKrArt.ENUMW_KR_ART_EKW);
                if (_equals_1) {
                    result.getContinuousSegments().add((Object)this.getContinousSegment(legA, legC));
                }
            }
        }
        if (metadata == null) {
            Identitaet_TypeClass _identitaet_3 = trackswitch.getIdentitaet();
            String _wert_7 = null;
            if (_identitaet_3 != null) {
                _wert_7 = _identitaet_3.getWert();
            }
            String _elvis = null;
            W_Kr_Anlage_Allg_AttributeGroup _wKrAnlageAllg = trackswitch.getWKrAnlageAllg();
            W_Kr_Art_TypeClass _wKrArt = null;
            if (_wKrAnlageAllg != null) {
                _wKrArt = _wKrAnlageAllg.getWKrArt();
            }
            ENUMWKrArt _wert_8 = null;
            if (_wKrArt != null) {
                _wert_8 = _wKrArt.getWert();
            }
            String _string = null;
            if (_wert_8 != null) {
                _string = _wert_8.toString();
            }
            _elvis = _string != null ? _string : "Keine W_Kr_Art";
            String _elvis_1 = null;
            W_Kr_Anlage_Allg_AttributeGroup _wKrAnlageAllg_1 = trackswitch.getWKrAnlageAllg();
            W_Kr_Grundform_TypeClass _wKrGrundform = null;
            if (_wKrAnlageAllg_1 != null) {
                _wKrGrundform = _wKrAnlageAllg_1.getWKrGrundform();
            }
            String _wert_9 = null;
            if (_wKrGrundform != null) {
                _wert_9 = _wKrGrundform.getWert();
            }
            _elvis_1 = _wert_9 != null ? _wert_9 : "Keine W_Kr_Grundform";
            this.recordError(_wert_7, String.format(ERROR_NO_TRACK_SWITCH_METADATA, _elvis, _elvis_1), (Coordinate)legA.getCoordinate(0.0, 2.0, this.geometryService, this.positionService));
        }
        this.addSiteplanElement(result, SiteplanPackage.eINSTANCE.getSiteplanState_TrackSwitches());
    }

    public ContinuousTrackSegment getContinousSegment(TrackSwitchLeg legStart, TrackSwitchLeg legEnd) {
        ContinuousTrackSegment result = SiteplanFactory.eINSTANCE.createContinuousTrackSegment();
        result.setStart((Coordinate)legStart.getNodeCoordinate(this.geometryService, this.positionService));
        result.setEnd((Coordinate)legEnd.getNodeCoordinate(this.geometryService, this.positionService));
        return result;
    }

    public TrackSwitchComponent transformElement(W_Kr_Anlage anlage, W_Kr_Gsp_Element element, TrackSwitchLeg mainLeg, TrackSwitchLeg sideLeg) {
        BigInteger pointDetector;
        TrackSwitchComponent result = SiteplanFactory.eINSTANCE.createTrackSwitchComponent();
        result.setGuid(element.getIdentitaet().getWert());
        List components = WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)element);
        Consumer<W_Kr_Gsp_Komponente> _function = it -> TransformUtils.transformPunktObjektStrecke((Punkt_Objekt)it, (RouteObject)result);
        components.forEach(_function);
        result.setMainLeg(this.transformLeg(mainLeg));
        result.setSideLeg(this.transformLeg(sideLeg));
        result.setLabel(this.transformLabel(element));
        result.setStart(mainLeg.getCoordinate(0.0, 0.0, this.geometryService, this.positionService));
        double _length = sideLeg.getLength();
        double _divide = _length / 2.0;
        result.setLabelPosition(sideLeg.getCoordinate(_divide, 0.0, this.geometryService, this.positionService));
        W_Kr_Gsp_Komponente _get = (W_Kr_Gsp_Komponente)components.get(0);
        Zungenpaar_AttributeGroup _zungenpaar = null;
        if (_get != null) {
            _zungenpaar = _get.getZungenpaar();
        }
        Zungenpruefkontakt_Anzahl_TypeClass _zungenpruefkontaktAnzahl = null;
        if (_zungenpaar != null) {
            _zungenpruefkontaktAnzahl = _zungenpaar.getZungenpruefkontaktAnzahl();
        }
        BigInteger _wert = null;
        if (_zungenpruefkontaktAnzahl != null) {
            _wert = _zungenpruefkontaktAnzahl.getWert();
        }
        if ((pointDetector = _wert) != null) {
            result.setPointDetectorCount(pointDetector.intValue());
        }
        W_Kr_Gsp_Element_Allg_AttributeGroup _wKrGspElementAllg = element.getWKrGspElementAllg();
        W_Kr_Gsp_Stellart_TypeClass _wKrGspStellart = null;
        if (_wKrGspElementAllg != null) {
            _wKrGspStellart = _wKrGspElementAllg.getWKrGspStellart();
        }
        ENUMWKrGspStellart _wert_1 = null;
        if (_wKrGspStellart != null) {
            _wert_1 = _wKrGspStellart.getWert();
        }
        result.setOperatingMode(this.transform(_wert_1));
        LeftRight _xifexpression = null;
        Weiche_Element_AttributeGroup _weicheElement = element.getWeicheElement();
        Weiche_Vorzugslage_TypeClass _weicheVorzugslage = null;
        if (_weicheElement != null) {
            _weicheVorzugslage = _weicheElement.getWeicheVorzugslage();
        }
        ENUMLinksRechts _wert_2 = null;
        if (_weicheVorzugslage != null) {
            _wert_2 = _weicheVorzugslage.getWert();
        }
        boolean _tripleEquals = _wert_2 == ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS;
        _xifexpression = _tripleEquals ? LeftRight.LEFT : LeftRight.RIGHT;
        result.setPreferredLocation(_xifexpression);
        return result;
    }

    private org.eclipse.set.model.siteplan.TrackSwitchLeg transformLeg(TrackSwitchLeg leg) {
        org.eclipse.set.model.siteplan.TrackSwitchLeg result = SiteplanFactory.eINSTANCE.createTrackSwitchLeg();
        ENUMTOPAnschluss _connection = leg.getConnection();
        if (_connection != null) {
            switch (_connection) {
                case ENUMTOP_ANSCHLUSS_LINKS: {
                    result.setConnection(LeftRight.LEFT);
                    break;
                }
                case ENUMTOP_ANSCHLUSS_RECHTS: {
                    result.setConnection(LeftRight.RIGHT);
                    break;
                }
                default: {
                    result.setConnection(null);
                    break;
                }
            }
        } else {
            result.setConnection(null);
        }
        CollectionExtensions.addAll((Collection)result.getCoordinates(), (Object[])leg.getCoordinates(this.geometryService, this.positionService));
        return result;
    }

    private Label transformLabel(W_Kr_Gsp_Element element) {
        ENUMWeicheBetriebsart mode;
        Label result = SiteplanFactory.eINSTANCE.createLabel();
        Label label = TransformUtils.getLabel(element.getBezeichnung());
        if (label == null) {
            result.setText("");
        } else {
            result.setText(label.getText());
        }
        Weiche_Element_AttributeGroup _weicheElement = element.getWeicheElement();
        Weiche_Betriebsart_TypeClass _weicheBetriebsart = null;
        if (_weicheElement != null) {
            _weicheBetriebsart = _weicheElement.getWeicheBetriebsart();
        }
        ENUMWeicheBetriebsart _wert = null;
        if (_weicheBetriebsart != null) {
            _wert = _weicheBetriebsart.getWert();
        }
        if ((mode = _wert) == null) {
            return result;
        }
        if (mode != null) {
            switch (mode) {
                case ENUM_WEICHE_BETRIEBSART_LINKS: {
                    String _text = label.getText();
                    String _plus = _text + " (L)";
                    result.setText(_plus);
                    return result;
                }
                case ENUM_WEICHE_BETRIEBSART_RECHTS: {
                    String _text_1 = label.getText();
                    String _plus_1 = _text_1 + " (R)";
                    result.setText(_plus_1);
                    return result;
                }
            }
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(Signal signal) {
        boolean _greaterEqualsThan;
        boolean _not;
        Functions.Function1 _function = it -> it.getSignalbegriffID().eClass().getName();
        boolean _contains = IterableExtensions.contains((Iterable)IterableExtensions.map((Iterable)SignalExtensions.getSignalbegriffe((Signal)signal), (Functions.Function1)_function), (Object)"Ra12");
        boolean bl = _not = !_contains;
        if (_not) {
            return;
        }
        TrackSwitchEndMarker result = SiteplanFactory.eINSTANCE.createTrackSwitchEndMarker();
        Iterable<Coordinate> topKanteLocations = this.getPunktObjektEdgeCoordinates((Punkt_Objekt)signal);
        int _length = ((Object[])Conversions.unwrapArray(topKanteLocations, Object.class)).length;
        boolean bl2 = _greaterEqualsThan = _length >= 2;
        if (_greaterEqualsThan) {
            result.setLegACoordinate(((Coordinate[])Conversions.unwrapArray(topKanteLocations, Coordinate.class))[0]);
            result.setLegBCoordinate(((Coordinate[])Conversions.unwrapArray(topKanteLocations, Coordinate.class))[1]);
            SiteplanState siteplanState = this.state;
            synchronized (siteplanState) {
                this.state.getTrackSwitchEndMarkers().add((Object)result);
            }
        }
    }

    private Iterable<Coordinate> getPunktObjektEdgeCoordinates(Punkt_Objekt object) {
        Functions.Function1 _function = coordinate -> {
            ENUMGEOKoordinatensystem crs = GeoKnotenExtensions.getCRS((GEO_Knoten)TopKnotenExtensions.getGEOKnoten((TOP_Knoten)TopKanteExtensions.getTOPKnotenA((TOP_Kante)PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)coordinate))));
            try {
                TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)coordinate);
                double abstand = coordinate.getAbstand().getWert().doubleValue();
                Wirkrichtung_TypeClass _wirkrichtung = coordinate.getWirkrichtung();
                ENUMWirkrichtung _wert = null;
                if (_wirkrichtung != null) {
                    _wert = _wirkrichtung.getWert();
                }
                ENUMWirkrichtung direction = _wert;
                return this.positionService.transformCoordinate(TopKanteExtensions.getCoordinate((TOP_Kante)topKante, (double)abstand, (double)0.0, (ENUMWirkrichtung)direction).getCoordinate(), crs);
            }
            catch (Throwable _t) {
                if (_t instanceof GeometryException) {
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        return IterableExtensions.filterNull((Iterable)ListExtensions.map((List)object.getPunktObjektTOPKante(), (Functions.Function1)_function));
    }

    private TurnoutOperatingMode transform(ENUMWKrGspStellart operatingMode) {
        if (operatingMode != null) {
            switch (operatingMode) {
                case ENUMW_KR_GSP_STELLART_ELEKTRISCH_FERNGESTELLT: {
                    return TurnoutOperatingMode.ELECTRIC_REMOTE;
                }
                case ENUMW_KR_GSP_STELLART_ELEKTRISCH_ORTSGESTELLT: {
                    return TurnoutOperatingMode.ELECTRIC_LOCAL;
                }
                case ENUMW_KR_GSP_STELLART_MECHANISCH_FERNGESTELLT: {
                    return TurnoutOperatingMode.MECHANICAL_REMOTE;
                }
                case ENUMW_KR_GSP_STELLART_MECHANISCH_ORTSGESTELLT: {
                    return TurnoutOperatingMode.MECHANICAL_LOCAL;
                }
                case ENUMW_KR_GSP_STELLART_NICHT_STELLBAR: {
                    return TurnoutOperatingMode.NON_OPERATIONAL;
                }
                case ENUMW_KR_GSP_STELLART_RUECKFALLWEICHE: {
                    return TurnoutOperatingMode.TRAILABLE;
                }
                case ENUMW_KR_GSP_STELLART_SONSTIGE: {
                    return TurnoutOperatingMode.OTHER;
                }
                case ENUMW_KR_GSP_STELLART_STILLGELEGT_LINKS: {
                    return TurnoutOperatingMode.DEAD_LEFT;
                }
                case ENUMW_KR_GSP_STELLART_STILLGELEGT_RECHTS: {
                    return TurnoutOperatingMode.DEAD_RIGHT;
                }
            }
            return TurnoutOperatingMode.UNDEFINED;
        }
        return TurnoutOperatingMode.UNDEFINED;
    }
}

