/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import com.google.common.collect.Iterators;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.core.services.siteplan.SiteplanService;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.transform.AbstractSiteplanTransformator;
import org.eclipse.set.feature.siteplan.transform.LayoutTransformator;
import org.eclipse.set.feature.siteplan.transform.SiteplanTransformator;
import org.eclipse.set.feature.siteplan.transform.TransformUtils;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.Strecke;
import org.eclipse.set.model.planpro.Geodaten.Strecke_Punkt;
import org.eclipse.set.model.planpro.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.PlanPro.Planung_G_Fuehrende_Strecke_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_Gruppe;
import org.eclipse.set.model.planpro.PlanPro.Planung_Projekt;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.model.siteplan.Siteplan;
import org.eclipse.set.model.siteplan.SiteplanObject;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.model.siteplan.SiteplanState;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.PlanungProjektExtensions;
import org.eclipse.set.ppmodel.extensions.StreckeExtensions;
import org.eclipse.set.ppmodel.extensions.StreckePunktExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={SiteplanTransformator.class})
public class SiteplanTransformatorImpl
extends AbstractSiteplanTransformator {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(component.name=org.eclipse.set.feature.siteplan.transform.*)")
    public final List<Transformator> transformators = CollectionLiterals.newArrayList();
    @Reference
    protected GeoKanteGeometryService geometryService;
    @Reference
    protected PositionService positionService;
    @Reference
    protected SiteplanService siteplanService;
    private final HashMap<ArrayList<?>, SiteplanState> _createCache_transformState = CollectionLiterals.newHashMap();

    @Override
    public Siteplan transform(IModelSession modelSession) {
        Siteplan siteplan = super.transform(modelSession);
        if (siteplan == null) {
            return null;
        }
        this.transformLayout(siteplan, modelSession.getLayoutInformation());
        Functions.Function1 _function = it -> {
            String _guid = it.getGuid();
            return _guid != null;
        };
        Procedures.Procedure1 _function_1 = it -> this.siteplanService.addSiteplanElement(it);
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)siteplan.eAllContents(), SiteplanObject.class), (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
        return siteplan;
    }

    public void transformLayout(Siteplan siteplan, PlanPro_Layoutinfo layoutinfo) {
        LayoutTransformator layoutTransform = new LayoutTransformator(layoutinfo, this.positionService);
        layoutTransform.transformLayout(siteplan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SiteplanState transformState(MultiContainer_AttributeGroup container) {
        SiteplanState _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new MultiContainer_AttributeGroup[]{container});
        HashMap<ArrayList<?>, SiteplanState> hashMap = this._createCache_transformState;
        synchronized (hashMap) {
            SiteplanState _createSiteplanState;
            if (this._createCache_transformState.containsKey(_cacheKey)) {
                return this._createCache_transformState.get(_cacheKey);
            }
            _result = _createSiteplanState = SiteplanPackage.eINSTANCE.getSiteplanFactory().createSiteplanState();
            this._createCache_transformState.put(_cacheKey, _result);
        }
        this._init_transformState(_result, container);
        return _result;
    }

    private void _init_transformState(SiteplanState it, MultiContainer_AttributeGroup container) {
        Procedures.Procedure1 _function = transformator -> transformator.transformContainer(it, container);
        TransformUtils.createTransformatorThread(this.transformators, this.getClass().getName(), this.transformators.size(), _function);
    }

    @Override
    public Position getLeadingPosition(PlanPro_Schnittstelle planproSchnittstelle, MultiContainer_AttributeGroup container) {
        Strecke_Punkt[] startEnd;
        GeoPosition mainCoordinate;
        block12: {
            Planung_G_Fuehrende_Strecke_AttributeGroup mainRouteInfo;
            Planung_Projekt _LSTPlanungProjekt = null;
            if (planproSchnittstelle != null) {
                _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt((PlanPro_Schnittstelle)planproSchnittstelle);
            }
            Planung_Gruppe _planungGruppe = null;
            if (_LSTPlanungProjekt != null) {
                _planungGruppe = PlanungProjektExtensions.getPlanungGruppe((Planung_Projekt)_LSTPlanungProjekt);
            }
            Planung_G_Fuehrende_Strecke_AttributeGroup _planungGFuehrendeStrecke = null;
            if (_planungGruppe != null) {
                _planungGFuehrendeStrecke = _planungGruppe.getPlanungGFuehrendeStrecke();
            }
            if ((mainRouteInfo = _planungGFuehrendeStrecke) == null) {
                return null;
            }
            String trackNumber = mainRouteInfo.getStreckeNummer().getWert();
            Functions.Function1 _function = s -> {
                String _wert = s.getBezeichnung().getBezeichnungStrecke().getWert();
                return Objects.equals(_wert, trackNumber);
            };
            Iterable mainRoutes = IterableExtensions.filter((Iterable)container.getStrecke(), (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)mainRoutes);
            if (_isEmpty) {
                return null;
            }
            double trackKm = 0.0;
            try {
                trackKm = Double.parseDouble(mainRouteInfo.getStreckeKm().getWert().replace(",", ""));
            }
            catch (Throwable _t) {
                if (_t instanceof ParseException || _t instanceof NumberFormatException) {
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Strecke mainRoute = (Strecke)IterableExtensions.head((Iterable)mainRoutes);
            try {
                mainCoordinate = StreckeExtensions.getKilometerCoordinate((Strecke)mainRoute, (double)trackKm);
                startEnd = StreckeExtensions.getStartEnd((Strecke)mainRoute);
                if (startEnd != null) break block12;
                return null;
            }
            catch (Throwable _t) {
                if (_t instanceof RuntimeException) {
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        ENUMGEOKoordinatensystem crs = GeoKnotenExtensions.getCRS((GEO_Knoten)StreckePunktExtensions.getGeoKnoten((Strecke_Punkt)((Strecke_Punkt)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)startEnd))))));
        return this.positionService.transformPosition(mainCoordinate, crs);
    }
}

