/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.property.EObjectProperty;
import org.eclipse.emfcloud.jackson.databind.property.EObjectPropertyMap;
import org.eclipse.emfcloud.jackson.databind.ser.EObjectSerializer;
import org.eclipse.emfcloud.jackson.module.EMFModule;
import org.eclipse.emfcloud.jackson.utils.EObjects;

public class SiteplanEObjectSerializer
extends JsonSerializer<EObject> {
    private final JsonSerializer<EObject> refSerializer;
    private final EObjectPropertyMap.Builder builder;

    public static SimpleModule getModule(final EMFModule module) {
        return new SimpleModule().setSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription desc, JsonSerializer<?> serializer) {
                if (serializer instanceof EObjectSerializer) {
                    return new SiteplanEObjectSerializer(module);
                }
                return serializer;
            }
        });
    }

    private SiteplanEObjectSerializer(EMFModule module) {
        this.builder = EObjectPropertyMap.Builder.from((EMFModule)module, (int)module.getFeatures());
        this.refSerializer = module.getReferenceSerializer();
    }

    public Class<EObject> handledType() {
        return EObject.class;
    }

    public void serialize(EObject object, JsonGenerator jg, SerializerProvider provider) throws IOException {
        EObjectPropertyMap properties = this.builder.construct((DatabindContext)provider, object.eClass());
        EObject parent = EMFContext.getParent((DatabindContext)provider);
        if (parent != null && (object.eIsProxy() || EObjects.isContainmentProxy((DatabindContext)provider, (EObject)parent, (EObject)object))) {
            this.refSerializer.serialize((Object)object, jg, provider);
            return;
        }
        jg.writeStartObject();
        for (EObjectProperty property : properties.getProperties()) {
            SiteplanEObjectSerializer.serializeProperty(object, jg, provider, property);
        }
        jg.writeEndObject();
    }

    private static void serializeProperty(EObject object, JsonGenerator jg, SerializerProvider provider, EObjectProperty property) throws IOException {
        int beforeIndex = jg.getOutputContext().getCurrentIndex();
        property.serialize(object, jg, provider);
        int afterIndex = jg.getOutputContext().getCurrentIndex();
        if (beforeIndex != afterIndex) {
            return;
        }
        EStructuralFeature feature = object.eClass().getEStructuralFeature(property.getFieldName());
        if (feature != null && !object.eIsSet(feature) && feature.getDefaultValue() == null && feature.isMany()) {
            jg.writeArrayFieldStart(property.getFieldName());
            jg.writeEndArray();
        }
    }
}

