/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.modelservice;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.files.AttachmentContentService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.helpmessage.HelpMessageService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.viewmodel.ToolboxViewModelService;
import org.eclipse.set.utils.Messages;

public class SimpleToolboxViewModelService
implements ToolboxViewModelService {
    @Inject
    private DialogService dialogService;
    @Inject
    private HelpMessageService helpMessageService;
    private final Map<String, Object> messages = new HashMap<String, Object>();
    private final Map<String, Object> namedObjects = new HashMap<String, Object>();
    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private IModelSession session;
    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    ECommandService commandService;
    @Inject
    AttachmentContentService contentService;
    @Inject
    EnumTranslationService enumTranslationService;
    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    EHandlerService handlerService;
    @Inject
    ToolboxPartService partService;
    @Inject
    ESelectionService selectionService;
    @Inject
    @Translation
    Messages utilMessages;

    public <T> T get(Class<T> type) {
        return type.cast(this.get(type.getName()));
    }

    public Object get(String key) {
        return this.namedObjects.get(key);
    }

    public <T> T getMessages(Class<T> messageType) {
        Object result = this.messages.get(messageType.getName());
        return (T)result;
    }

    public Optional<IModelSession> getSession() {
        return Optional.ofNullable(this.session);
    }

    public Path getTempDir() {
        return this.session.getTempDir();
    }

    public EnumTranslationService getTranslationService() {
        return this.enumTranslationService;
    }

    public <T> void put(Class<T> type, T object) {
        this.namedObjects.put(type.getName(), object);
    }

    public void put(String key, Object object) {
        this.namedObjects.put(key, object);
    }

    @PostConstruct
    private void postConstruct() {
        this.messages.put(Messages.class.getName(), this.utilMessages);
        this.put(ToolboxPartService.class, this.partService);
        this.put(DialogService.class, this.dialogService);
        this.put(HelpMessageService.class, this.helpMessageService);
        this.put(AttachmentContentService.class, this.contentService);
        this.put(ESelectionService.class, this.selectionService);
    }
}

