/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.e4.core.internal.services.ResourceBundleHelper;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageService {
    static final Logger logger = LoggerFactory.getLogger(AbstractMessageService.class);

    private void setupLocalization(ResourceBundle resourceBundle) throws IllegalAccessException {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Modifier.isPublic(field.getModifiers())) {
                try {
                    field.set(this, resourceBundle.getString(field.getName()));
                }
                catch (MissingResourceException e) {
                    logger.error("Missing localization for field {}", (Object)field.getName());
                    field.set(this, "MISSING LOCALIZATION");
                }
            }
            ++n2;
        }
    }

    protected void setupLocalization(BundleLocalization bundleLocalization) throws IllegalAccessException {
        ResourceBundle resourceBundle = bundleLocalization.getLocalization(FrameworkUtil.getBundle(this.getClass()), null);
        this.setupLocalization(resourceBundle);
    }

    protected void setupLocalization(String uri) throws IllegalAccessException {
        ResourceBundle resourceBundle = ResourceBundleHelper.getResourceBundleForUri((String)uri, (Locale)Locale.getDefault(), null);
        this.setupLocalization(resourceBundle);
    }
}

