/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.geometry;

import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.geometry.CoordinateArray;
import org.eclipse.set.basis.geometry.Geometries;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;

public class Chord {
    private static final double STEP_SIZE = 0.031415926535897934;
    private final LineSegment lineSegment;
    private final Orientation orientation;
    private final double radius;

    public Chord(Coordinate start, Coordinate end, double radius, Orientation orientation) {
        this(new LineSegment(start, end), radius, orientation);
    }

    public Chord(LineSegment lineSegment, double radius, Orientation orientation) {
        Assert.isTrue((radius > 0.0 ? 1 : 0) != 0);
        this.lineSegment = lineSegment;
        this.radius = radius;
        this.orientation = orientation;
    }

    public Coordinate getEnd() {
        return this.lineSegment.p1;
    }

    public Coordinate getMidpoint() {
        double c = this.lineSegment.getLength();
        double r2 = this.radius * this.radius;
        double c2 = c * c;
        double h = Math.sqrt(r2 - c2 / 4.0);
        Coordinate middleOfC = this.lineSegment.midPoint();
        LineSegment hSegment = Geometries.clone(this.lineSegment);
        Geometries.translate(hSegment, this.getStart(), middleOfC);
        if (this.orientation == Orientation.ARC_LEFT) {
            Geometries.turn(hSegment, -90.0);
        } else {
            Geometries.turn(hSegment, 90.0);
        }
        Geometries.scale(hSegment, h);
        return hSegment.p1;
    }

    public double getRadius() {
        return this.radius;
    }

    public LineSegment getSagitta() {
        double c = this.lineSegment.getLength();
        double r2 = this.radius * this.radius;
        double c2 = c * c;
        double h = Math.sqrt(r2 - c2 / 4.0);
        double s = this.radius - h;
        Coordinate middleOfC = this.lineSegment.midPoint();
        LineSegment sagitta = Geometries.clone(this.lineSegment);
        Geometries.translate(sagitta, this.getStart(), middleOfC);
        if (this.orientation == Orientation.ARC_LEFT) {
            Geometries.turn(sagitta, 90.0);
        } else {
            Geometries.turn(sagitta, -90.0);
        }
        Geometries.scale(sagitta, s);
        return sagitta;
    }

    public Coordinate getStart() {
        return this.lineSegment.p0;
    }

    public double[] linearize() {
        CoordinateArray array;
        Coordinate center = this.getMidpoint();
        double startX = this.lineSegment.p0.x - center.x;
        double startY = this.lineSegment.p0.y - center.y;
        double endX = this.lineSegment.p1.x - center.x;
        double endY = this.lineSegment.p1.y - center.y;
        if (this.orientation == Orientation.ARC_LEFT) {
            array = this.linearizeArc(endX, endY, startX, startY);
            array.reverse();
        } else {
            array = this.linearizeArc(startX, startY, endX, endY);
        }
        array.offsetBy(center.x, center.y);
        return array.getData();
    }

    private CoordinateArray linearizeArc(double startX, double startY, double endX, double endY) {
        double startAngle = Math.atan2(startY, startX);
        double endAngle = Math.atan2(endY, endX);
        double epsilon = 1.0E-10;
        double end = endAngle - 1.0E-10;
        if (end < startAngle) {
            end += Math.PI * 2;
        }
        double angle = (Math.floor(startAngle / 0.031415926535897934) + 1.0) * 0.031415926535897934;
        int count = 2 + (int)Math.ceil((end - angle) / 0.031415926535897934);
        CoordinateArray array = new CoordinateArray(count);
        array.add(startX, startY);
        while (angle < end) {
            double x = this.radius * Math.cos(angle);
            double y = this.radius * Math.sin(angle);
            array.add(x, y);
            angle += 0.031415926535897934;
        }
        array.add(endX, endY);
        return array;
    }

    public static enum Orientation {
        ARC_LEFT,
        ARC_RIGHT;

    }
}

