/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.autofill;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.autofill.FillSetting;

public class FillPathSetting
implements FillSetting {
    private final EFactory factory;
    private final EObject object;
    private final EStructuralFeature[] path;

    private static void setValue(EditingDomain editingDomain, EObject owner, EStructuralFeature feature, Object value) {
        if (editingDomain != null) {
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)owner, (Object)feature, (Object)value);
            editingDomain.getCommandStack().execute(command);
        } else {
            owner.eSet(feature, value);
        }
    }

    public FillPathSetting(EFactory factory, EObject object, EStructuralFeature ... path) {
        Assert.isNotNull((Object)object);
        Assert.isTrue((path.length > 0 ? 1 : 0) != 0);
        this.factory = factory;
        this.object = object;
        this.path = path;
    }

    @Override
    public Object getValue() {
        return this.getValue(this.object, 0);
    }

    @Override
    public void setValue(EditingDomain editingDomain, Object value) {
        this.setValue(editingDomain, this.object, 0, value);
    }

    private Object getValue(EObject current, int i) {
        Object value = current.eGet(this.path[i]);
        if (value == null) {
            return null;
        }
        int next = i + 1;
        if (next < this.path.length) {
            return this.getValue((EObject)value, next);
        }
        return value;
    }

    private EObject newObject(EStructuralFeature feature) {
        return this.factory.create((EClass)feature.getEType());
    }

    private void setValue(EditingDomain editingDomain, EObject current, int i, Object value) {
        if (i >= this.path.length - 1) {
            FillPathSetting.setValue(editingDomain, current, this.path[i], value);
        } else {
            EStructuralFeature feature = this.path[i];
            EObject currentObject = (EObject)current.eGet(feature);
            if (currentObject == null) {
                EObject newObject = this.newObject(feature);
                FillPathSetting.setValue(editingDomain, current, feature, newObject);
                this.setValue(editingDomain, newObject, i + 1, value);
            } else {
                this.setValue(editingDomain, currentObject, i + 1, value);
            }
        }
    }
}

