/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.ViewLocaleService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.DateTimeDisplayType;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDateTimeDisplayAttachment;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.FrameworkUtil;

public class DateTimeControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private final EMFFormsLocalizationService localizationService;
    private final ImageRegistryService imageRegistryService;
    private Label unsetLabel;
    private StackLayout stackLayout;
    private Composite stackComposite;
    private Composite dateTimeComposite;
    private Composite composite;
    private Shell dialog;
    private ModelChangeListener domainModelChangeListener;
    private DateTime dateWidget;
    private DateTime timeWidget;
    private Button bUnset;
    private Button setBtn;

    @Inject
    public DateTimeControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsLocalizationService localizationService, ImageRegistryService imageRegistryService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.localizationService = localizationService;
        this.imageRegistryService = imageRegistryService;
    }

    @Override
    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        ISWTObservableValue dateObserver = WidgetProperties.dateTimeSelection().observe((Widget)this.dateWidget);
        ISWTObservableValue timeObserver = WidgetProperties.dateTimeSelection().observe((Widget)this.timeWidget);
        DateAndTimeObservableValue target = new DateAndTimeObservableValue((IObservableValue)dateObserver, (IObservableValue)timeObserver);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)target, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy()), (UpdateValueStrategy)new DateModelToTargetUpdateStrategy());
        if (this.domainModelChangeListener == null) {
            this.domainModelChangeListener = new ModelChangeListener(){

                public void notifyChange(ModelChangeNotification notification) {
                    EStructuralFeature structuralFeature;
                    try {
                        structuralFeature = (EStructuralFeature)DateTimeControlSWTRenderer.this.getModelValue().getValueType();
                    }
                    catch (DatabindingFailedException ex) {
                        DateTimeControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                        return;
                    }
                    if (structuralFeature.equals(notification.getStructuralFeature())) {
                        DateTimeControlSWTRenderer.this.updateChangeListener(notification.getRawNotification().getNewValue());
                    }
                }
            };
            this.getViewModelContext().registerDomainChangeListener(this.domainModelChangeListener);
        }
        return new Binding[]{binding};
    }

    @Override
    protected void dispose() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.dialog.dispose();
        }
        this.getViewModelContext().unregisterDomainChangeListener(this.domainModelChangeListener);
        super.dispose();
    }

    @Override
    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 0).equalWidth(false).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.composite);
        this.stackComposite = new Composite(this.composite, 0);
        this.stackComposite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(2, 0).equalWidth(false).applyTo(this.stackComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.stackComposite);
        this.dateTimeComposite = new Composite(this.stackComposite, 0);
        this.dateTimeComposite.setBackground(this.composite.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(2, 0).equalWidth(false).applyTo(this.dateTimeComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.dateTimeComposite);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.unsetLabel = new Label(this.stackComposite, 0x1000000);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)this.unsetLabel, (VElement)this.getVElement(), (String)"unsetlabel", (ViewModelContext)this.getViewModelContext());
        this.unsetLabel.setText(this.getUnsetText());
        this.unsetLabel.setBackground(this.stackComposite.getBackground());
        this.unsetLabel.setForeground(parent.getDisplay().getSystemColor(16));
        this.unsetLabel.setAlignment(0x1000000);
        DateTimeDisplayType dateTimeDisplayType = this.getDateTimeDisplayType();
        this.createDateTimeWidgets(dateTimeDisplayType);
        this.bUnset = new Button(this.dateTimeComposite, 8);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)this.bUnset, (VElement)this.getVElement(), (String)"unset", (ViewModelContext)this.getViewModelContext());
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)this.bUnset);
        this.bUnset.setImage(this.imageRegistryService.getImage(FrameworkUtil.getBundle(DateTimeControlSWTRenderer.class), "icons/unset_feature.png"));
        this.bUnset.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_buttonUnset");
        String tooltip = this.getDateTimeDisplayType() == DateTimeDisplayType.TIME_ONLY ? "DateTimeControlSWTRenderer_CleanTime" : "DateTimeControlSWTRenderer_CleanDate";
        this.bUnset.setToolTipText(this.getLocalizedString(tooltip));
        this.bUnset.addSelectionListener((SelectionListener)new UnsetBtnSelectionAdapterExtension());
        this.setBtn = this.createSetButton();
        this.updateStack();
        return this.composite;
    }

    @Override
    protected void applyReadOnly() {
        super.applyReadOnly();
        this.updateButtonVisibility();
    }

    @Override
    protected void applyEnable() {
        super.applyEnable();
        this.updateButtonEnabling();
    }

    protected void updateButtonEnabling() {
        boolean isEnable;
        boolean bl = isEnable = ((VControl)this.getVElement()).isEffectivelyEnabled() && !((VControl)this.getVElement()).isEffectivelyReadonly();
        if (this.bUnset != null) {
            this.bUnset.setEnabled(isEnable);
        }
        if (this.setBtn != null) {
            this.setBtn.setEnabled(isEnable);
        }
    }

    protected void updateButtonVisibility() {
        boolean isVisible;
        boolean bl = isVisible = !((VControl)this.getVElement()).isEffectivelyReadonly() && !this.isUnchangeableFeature();
        if (this.bUnset != null) {
            this.bUnset.setVisible(isVisible);
            boolean bl2 = ((GridData)GridData.class.cast((Object)this.bUnset.getLayoutData())).exclude = !isVisible;
        }
        if (this.setBtn != null) {
            try {
                if (this.getModelValue() != null) {
                    Object value = this.getModelValue().getValue();
                    if (this.getDateTimeDisplayType() == DateTimeDisplayType.TIME_ONLY) {
                        this.setBtn.setVisible(isVisible && value == null);
                    } else {
                        this.setBtn.setVisible(isVisible);
                    }
                    ((GridData)GridData.class.cast((Object)this.setBtn.getLayoutData())).exclude = !this.setBtn.isVisible();
                }
            }
            catch (DatabindingFailedException ex) {
                this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            }
        }
        if (this.composite != null) {
            this.composite.layout();
        }
    }

    private void updateStack() throws DatabindingFailedException {
        IObservableValue observableValue = this.getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        this.stackLayout.topControl = eObject.eIsSet(structuralFeature) ? this.dateTimeComposite : this.unsetLabel;
    }

    private Button createSetButton() {
        String imagePath = this.getDateTimeDisplayType() == DateTimeDisplayType.TIME_ONLY ? "icons/set_feature.png" : "icons/date.png";
        Button setBtn = new Button(this.composite, 8);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)setBtn, (VElement)this.getVElement(), (String)"set", (ViewModelContext)this.getViewModelContext());
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)setBtn);
        setBtn.setImage(this.imageRegistryService.getImage(FrameworkUtil.getBundle(DateTimeControlSWTRenderer.class), imagePath));
        setBtn.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_buttonSet");
        String tooltip = this.getDateTimeDisplayType() == DateTimeDisplayType.TIME_ONLY ? "DateTimeControlSWTRenderer_SelectTime" : "DateTimeControlSWTRenderer_SelectData";
        setBtn.setToolTipText(this.getLocalizedString(tooltip));
        setBtn.addSelectionListener((SelectionListener)new SetBtnSelectionAdapterExtension(setBtn));
        return setBtn;
    }

    private void createDateTimeWidgets(DateTimeDisplayType dateTimeDisplayType) {
        GridData gridData;
        this.dateWidget = new DateTime(this.dateTimeComposite, 2080);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)this.dateWidget, (VElement)this.getVElement(), (String)"date", (ViewModelContext)this.getViewModelContext());
        this.dateWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dateWidget.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_date");
        this.timeWidget = new DateTime(this.dateTimeComposite, 34944);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)this.timeWidget, (VElement)this.getVElement(), (String)"time", (ViewModelContext)this.getViewModelContext());
        this.timeWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        this.timeWidget.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_time");
        if (dateTimeDisplayType == DateTimeDisplayType.TIME_ONLY) {
            this.dateWidget.setVisible(false);
            gridData = (GridData)this.dateWidget.getLayoutData();
            gridData.exclude = true;
        }
        if (dateTimeDisplayType == DateTimeDisplayType.DATE_ONLY) {
            this.timeWidget.setVisible(false);
            gridData = (GridData)this.timeWidget.getLayoutData();
            gridData.exclude = true;
        }
    }

    @Override
    protected void setValidationColor(Control control, Color validationColor) {
        ((Composite)control).getChildren()[0].setBackground(validationColor);
        ((Composite)control).getChildren()[1].setBackground(validationColor);
    }

    @Override
    protected String getUnsetText() {
        String text = this.getDateTimeDisplayType() == DateTimeDisplayType.TIME_ONLY ? "DateTimeControl_NoTimeSetClickToSetTime" : "DateTimeControl_NoDateSetClickToSetDate";
        return this.getLocalizedString(text);
    }

    private String getLocalizedString(String key) {
        return this.localizationService.getString(((Object)((Object)this)).getClass(), key);
    }

    private Locale getLocale(ViewModelContext viewModelContext) {
        ViewLocaleService service = (ViewLocaleService)viewModelContext.getService(ViewLocaleService.class);
        if (service == null) {
            return Locale.getDefault();
        }
        return service.getLocale();
    }

    private void updateChangeListener(Object value) {
        if (value == null) {
            if (this.stackLayout.topControl != this.unsetLabel) {
                this.stackLayout.topControl = this.unsetLabel;
                this.stackComposite.layout();
            }
        } else if (this.stackLayout.topControl != this.dateTimeComposite) {
            this.stackLayout.topControl = this.dateTimeComposite;
            this.stackComposite.layout();
        }
        this.updateButtonVisibility();
        if (!this.ignoreEnableOnReadOnly()) {
            this.applyEnable();
        }
    }

    private DateTimeDisplayType getDateTimeDisplayType() {
        if (this.getVElement() != null && ((VControl)this.getVElement()).getAttachments() != null) {
            for (VAttachment attachment : ((VControl)this.getVElement()).getAttachments()) {
                if (!VDateTimeDisplayAttachment.class.isInstance(attachment)) continue;
                VDateTimeDisplayAttachment dateTimeAttachment = (VDateTimeDisplayAttachment)attachment;
                return dateTimeAttachment.getDisplayType();
            }
        }
        return DateTimeDisplayType.TIME_AND_DATE;
    }

    @Override
    protected void rootDomainModelChanged() throws DatabindingFailedException {
        super.rootDomainModelChanged();
        this.updateStack();
        this.stackComposite.layout();
    }

    private class DateModelToTargetUpdateStrategy
    extends UpdateValueStrategy {
        DateModelToTargetUpdateStrategy() {
        }

        DateModelToTargetUpdateStrategy(int policy) {
            super(policy);
        }

        protected IStatus doSet(IObservableValue observableValue, Object value) {
            if (value == null) {
                return Status.OK_STATUS;
            }
            return super.doSet(observableValue, value);
        }
    }

    private class SetBtnSelectionAdapterExtension
    extends SelectionAdapter {
        private final Button btn;

        SetBtnSelectionAdapterExtension(Button btn) {
            this.btn = btn;
        }

        public void widgetSelected(SelectionEvent e) {
            if (DateTimeControlSWTRenderer.this.getDateTimeDisplayType() == DateTimeDisplayType.TIME_ONLY) {
                this.setTime();
            } else {
                this.setDate();
            }
        }

        private void setDate() {
            IObservableValue modelValue;
            if (DateTimeControlSWTRenderer.this.dialog != null && !DateTimeControlSWTRenderer.this.dialog.isDisposed()) {
                DateTimeControlSWTRenderer.this.dialog.dispose();
                return;
            }
            try {
                modelValue = DateTimeControlSWTRenderer.this.getModelValue();
            }
            catch (DatabindingFailedException ex) {
                DateTimeControlSWTRenderer.this.getReportService().report(new AbstractReport((Throwable)ex));
                return;
            }
            DateTimeControlSWTRenderer.this.dialog = new Shell(this.btn.getShell(), 0);
            DateTimeControlSWTRenderer.this.dialog.setLayout((Layout)new GridLayout(1, false));
            DateTime calendar = new DateTime((Composite)DateTimeControlSWTRenderer.this.dialog, 3072);
            ISWTObservableValue calendarObserver = WidgetProperties.dateTimeSelection().observe((Widget)calendar);
            UpdateValueStrategy modelToTarget = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
            final Binding binding = DateTimeControlSWTRenderer.this.getDataBindingContext().bindValue((IObservableValue)calendarObserver, modelValue, modelToTarget, (UpdateValueStrategy)new DateModelToTargetUpdateStrategy(UpdateValueStrategy.POLICY_UPDATE));
            Calendar defaultCalendar = Calendar.getInstance(DateTimeControlSWTRenderer.this.getLocale(DateTimeControlSWTRenderer.this.getViewModelContext()));
            Date date = (Date)modelValue.getValue();
            if (date != null) {
                defaultCalendar.setTime(date);
            }
            calendar.setDate(defaultCalendar.get(1), defaultCalendar.get(2), defaultCalendar.get(5));
            Button okButton = new Button((Composite)DateTimeControlSWTRenderer.this.dialog, 8);
            okButton.setText(JFaceResources.getString((String)"ok"));
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)okButton);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    binding.updateTargetToModel();
                    binding.dispose();
                    DateTimeControlSWTRenderer.this.dialog.close();
                    DateTimeControlSWTRenderer.this.updateChangeListener(modelValue.getValue());
                }
            });
            DateTimeControlSWTRenderer.this.dialog.pack();
            DateTimeControlSWTRenderer.this.dialog.layout();
            DateTimeControlSWTRenderer.this.dialog.setLocation(this.btn.getParent().toDisplay(this.btn.getLocation().x + this.btn.getSize().x - ((DateTimeControlSWTRenderer)DateTimeControlSWTRenderer.this).dialog.getSize().x, this.btn.getLocation().y + this.btn.getSize().y));
            DateTimeControlSWTRenderer.this.dialog.open();
        }

        private void setTime() {
            try {
                EStructuralFeature structuralFeature = (EStructuralFeature)DateTimeControlSWTRenderer.this.getModelValue().getValueType();
                EObject eObject = (EObject)((IObserving)DateTimeControlSWTRenderer.this.getModelValue()).getObserved();
                Command setCommand = SetCommand.create((EditingDomain)DateTimeControlSWTRenderer.this.getEditingDomain(eObject), (Object)eObject, (Object)structuralFeature, (Object)new Date());
                DateTimeControlSWTRenderer.this.getEditingDomain(eObject).getCommandStack().execute(setCommand);
                DateTimeControlSWTRenderer.this.updateChangeListener(DateTimeControlSWTRenderer.this.getModelValue().getValue());
            }
            catch (DatabindingFailedException ex) {
                DateTimeControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            }
        }
    }

    private class UnsetBtnSelectionAdapterExtension
    extends SelectionAdapter {
        private UnsetBtnSelectionAdapterExtension() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                EStructuralFeature structuralFeature = (EStructuralFeature)DateTimeControlSWTRenderer.this.getModelValue().getValueType();
                EObject eObject = (EObject)((IObserving)DateTimeControlSWTRenderer.this.getModelValue()).getObserved();
                Command removeCommand = SetCommand.create((EditingDomain)DateTimeControlSWTRenderer.this.getEditingDomain(eObject), (Object)eObject, (Object)structuralFeature, null);
                DateTimeControlSWTRenderer.this.getEditingDomain(eObject).getCommandStack().execute(removeCommand);
                DateTimeControlSWTRenderer.this.updateChangeListener(DateTimeControlSWTRenderer.this.getModelValue().getValue());
            }
            catch (DatabindingFailedException ex) {
                DateTimeControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            }
        }
    }
}

