/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.pdf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.ToolboxPaths;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.exceptions.FileExportException;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.feature.export.pdf.TableToTableDocument;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.services.export.TableExport;
import org.eclipse.set.services.fop.FopService;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.table.transform.TransformTable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Component(immediate=true)
public class FopPdfExportBuilder
implements TableExport {
    private static final Logger logger = LoggerFactory.getLogger(FopPdfExportBuilder.class);
    private static final String TITLEBOX_SHORTCUT = "schriftfeld";
    private FopService fopService;
    private String templateDir = "./data/export/pdf/";

    private static TransformerFactory newTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return transformerFactory;
    }

    private static String createTableDocumentText(Table table, Titlebox titlebox, FreeFieldInfo freeFieldInfo) throws ParserConfigurationException, TransformerException {
        TableToTableDocument tableToXmlFo = TableToTableDocument.createTransformation();
        Document document = tableToXmlFo.transformToDocument(table, titlebox, freeFieldInfo);
        Transformer documentToString = FopPdfExportBuilder.newTransformerFactory().newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        documentToString.transform(source, result);
        return writer.toString();
    }

    private static String createTitleboxDocumentText(Titlebox titlebox) throws Exception {
        TableToTableDocument tableToXmlFo = TableToTableDocument.createTransformation();
        Document document = tableToXmlFo.transformToDocument(titlebox);
        Transformer documentToString = FopPdfExportBuilder.newTransformerFactory().newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        documentToString.transform(source, result);
        return writer.toString();
    }

    private static void exportTableDocument(Path filename, String content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter out = new PrintWriter(filename.toString());){
            out.println(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String getFilename(String shortcut, String extension) {
        return shortcut + "-fop." + extension;
    }

    private static Table getTableToBeExported(Map<TableType, Table> tables, ExportType exportType) {
        switch (exportType) {
            case INVENTORY_RECORDS: {
                Table invTable = tables.get(TableType.FINAL);
                if (invTable != null) {
                    return invTable;
                }
                return tables.get(TableType.SINGLE);
            }
            case PLANNING_RECORDS: {
                Table planTable = tables.get(TableType.DIFF);
                if (planTable != null) {
                    return planTable;
                }
                return tables.get(TableType.SINGLE);
            }
        }
        throw new IllegalArgumentException(exportType.toString());
    }

    public void export(Map<TableType, Table> tables, ExportType exportType, Titlebox titlebox, FreeFieldInfo freeFieldInfo, String shortcut, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling) throws FileExportException {
        logger.info("Exporting {}", (Object)shortcut);
        Table table = FopPdfExportBuilder.getTableToBeExported(tables, exportType);
        Assert.isNotNull((Object)table);
        Path outputPath = toolboxPaths.getTableExportPath(shortcut, Paths.get(outputDir, new String[0]), exportType, ToolboxPaths.ExportPathExtension.TABLE_PDF_EXPORT_EXTENSION);
        try {
            String tableDocumentText = FopPdfExportBuilder.createTableDocumentText(table, titlebox, freeFieldInfo);
            if (ToolboxConfiguration.isDevelopmentMode()) {
                FopPdfExportBuilder.exportTableDocument(Paths.get(outputDir, FopPdfExportBuilder.getFilename(shortcut, "xml")), tableDocumentText);
            }
            this.createTablePdf(tableDocumentText, outputPath, shortcut, tableType, FopService.PdfAMode.PDF_A_3a, overwriteHandling);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new FileExportException(outputPath, (Throwable)e);
        }
    }

    private void createTablePdf(String tableDocumentText, Path outputPath, String shortcut, TableType tableType, FopService.PdfAMode pdfAMode, OverwriteHandling overwriteHandling) throws IOException, SAXException, TransformerException, ParserConfigurationException {
        TransformTable transformTable = new TransformTable(shortcut, FopPdfExportBuilder.translationTableType(tableType));
        Document xslDoc = transformTable.transform();
        if (xslDoc != null) {
            if (ToolboxConfiguration.isDevelopmentMode()) {
                Transformer documentToString = FopPdfExportBuilder.newTransformerFactory().newTransformer();
                DOMSource source = new DOMSource(xslDoc);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                documentToString.transform(source, result);
                FopPdfExportBuilder.exportTableDocument(Paths.get(outputPath.getParent().toString(), FopPdfExportBuilder.getFilename(shortcut, "xsl")), writer.toString());
            }
            ByteArrayInputStream tableDocumentStream = new ByteArrayInputStream(tableDocumentText.getBytes(StandardCharsets.UTF_8));
            StreamSource tableDocumentSource = new StreamSource(tableDocumentStream);
            this.fopService.fop(FopService.OutputFormat.PDF, (Source)TransformTable.toStreamSource((Document)xslDoc), (Source)tableDocumentSource, outputPath, pdfAMode, overwriteHandling, null);
        } else {
            logger.error("Cant export table: " + shortcut);
        }
    }

    public void exportTitleboxImage(Titlebox titlebox, Path imagePath, OverwriteHandling overwriteHandling) throws Exception {
        String tableDocumentText = FopPdfExportBuilder.createTitleboxDocumentText(titlebox);
        if (ToolboxConfiguration.isDevelopmentMode()) {
            FopPdfExportBuilder.exportTableDocument(Paths.get(imagePath.getParent().toString(), TITLEBOX_SHORTCUT, "xml"), tableDocumentText);
        }
        this.createImageFile(tableDocumentText, imagePath, overwriteHandling);
    }

    public void exportTitleboxPdf(Titlebox titlebox, Path pdfPath, OverwriteHandling overwriteHandling) throws Exception {
        try {
            String tableDocumentText = FopPdfExportBuilder.createTitleboxDocumentText(titlebox);
            if (ToolboxConfiguration.isDevelopmentMode()) {
                FopPdfExportBuilder.exportTableDocument(Paths.get(pdfPath.getParent().toString(), FopPdfExportBuilder.getFilename(TITLEBOX_SHORTCUT, "xml")), tableDocumentText);
            }
            this.createPdf(tableDocumentText, pdfPath, TITLEBOX_SHORTCUT, FopService.PdfAMode.NONE, overwriteHandling);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="-")
    public void setFopService(FopService fopService) {
        this.fopService = fopService;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    private void createImageFile(String tableDocumentText, Path imagePath, OverwriteHandling overwriteHandling) throws SAXException, IOException, TransformerException {
        File xsltFile = this.getTemplateFilename(TITLEBOX_SHORTCUT).toFile();
        if (xsltFile.canRead()) {
            StreamSource xslt = new StreamSource(xsltFile);
            ByteArrayInputStream tableDocumentStream = new ByteArrayInputStream(tableDocumentText.getBytes(StandardCharsets.UTF_8));
            StreamSource tableDocumentSource = new StreamSource(tableDocumentStream);
            this.fopService.fop(FopService.OutputFormat.IMAGE, (Source)xslt, (Source)tableDocumentSource, imagePath, FopService.PdfAMode.NONE, overwriteHandling, null);
        } else {
            logger.error("Missing pdf export template: " + xsltFile.toString());
        }
    }

    private void createPdf(String tableDocumentText, Path outputPath, String shortcut, FopService.PdfAMode pdfAMode, OverwriteHandling overwriteHandling) throws IOException, SAXException, TransformerException {
        File xsltFile = this.getTemplateFilename(shortcut).toFile();
        PathExtensions.checkCanRead((Path)xsltFile.toPath());
        if (xsltFile.canRead()) {
            StreamSource xslt = new StreamSource(xsltFile);
            ByteArrayInputStream tableDocumentStream = new ByteArrayInputStream(tableDocumentText.getBytes(StandardCharsets.UTF_8));
            StreamSource tableDocumentSource = new StreamSource(tableDocumentStream);
            this.fopService.fop(FopService.OutputFormat.PDF, (Source)xslt, (Source)tableDocumentSource, outputPath, pdfAMode, overwriteHandling, null);
        } else {
            logger.error("Missing pdf export template: " + xsltFile.toString());
        }
    }

    private Path getTemplateFilename(String shortcut) {
        return Paths.get(this.getTemplateDir(), shortcut + "_vorlage.xsl");
    }

    private static String translationTableType(TableType tableType) {
        if (tableType == null) {
            return null;
        }
        switch (tableType) {
            case INITIAL: {
                return "Startzustand";
            }
            case FINAL: {
                return "Zielzustand";
            }
        }
        return null;
    }
}

