/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.resources.IResourceManagerFactory;

public class ResourceManagerProvider {
    private IResourceManagerFactory factory;
    private IResourceManager instance;

    public synchronized void registerFactory(IResourceManagerFactory factory) {
        ParamCheck.notNull(factory, "factory");
        this.checkNoFactoryRegistered();
        this.factory = factory;
    }

    public void deregisterFactory() {
        this.checkFactoryRegistered();
        this.factory = null;
        this.instance = null;
    }

    public synchronized IResourceManager getResourceManager() {
        if (this.instance == null) {
            this.checkFactoryRegistered();
            this.instance = this.factory.create();
        }
        return this.instance;
    }

    private void checkFactoryRegistered() {
        if (this.factory == null) {
            throw new IllegalStateException("There is no IResourceManagerFactory registered.");
        }
    }

    private void checkNoFactoryRegistered() {
        if (this.factory != null) {
            throw new IllegalStateException("There is already an IResourceManagerFactory registered.");
        }
    }
}

