/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.rwt.Adaptable;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Widget;

public class ProgressEvent
extends TypedEvent {
    private static final long serialVersionUID = 1L;
    public static final int CHANGED = 5021;
    public static final int COMPLETED = 5022;
    private static final Class LISTENER = ProgressListener.class;
    public int current;
    public int total;

    public ProgressEvent(Widget widget) {
        super(widget);
    }

    public ProgressEvent(Widget source, int id) {
        super(source, id);
    }

    protected void dispatchToObserver(Object listener) {
        switch (this.getID()) {
            case 5021: {
                ((ProgressListener)listener).changed(this);
                break;
            }
            case 5022: {
                ((ProgressListener)listener).completed(this);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid event handler type.");
            }
        }
    }

    protected Class getListenerType() {
        return LISTENER;
    }

    protected boolean allowProcessing() {
        return true;
    }

    public static boolean hasListener(Adaptable adaptable) {
        return ProgressEvent.hasListener(adaptable, LISTENER);
    }

    public static void addListener(Adaptable adaptable, ProgressListener listener) {
        ProgressEvent.addListener(adaptable, LISTENER, listener);
    }

    public static void removeListener(Adaptable adaptable, ProgressListener listener) {
        ProgressEvent.removeListener(adaptable, LISTENER, listener);
    }

    public static Object[] getListeners(Adaptable adaptable) {
        return ProgressEvent.getListener(adaptable, LISTENER);
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string.substring(0, string.length() - 1)) + " current=" + this.current + " total=" + this.total + "}";
    }
}

