/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.layout;

import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithm;
import org.eclipse.sirius.diagram.ui.business.api.query.EditPartQuery;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.CompoundLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.DefaultLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.ExtendableLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.ArrangeSelectionLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.PinnedElementsLayoutProvider;

public class GenericLayoutProvider
implements LayoutProvider {
    @Override
    public AbstractLayoutEditPartProvider getLayoutNodeProvider(IGraphicalEditPart partToLayout) {
        DefaultLayoutProvider defaultLayoutProvider = this.getGenericLayoutProvider(partToLayout);
        if (defaultLayoutProvider != null) {
            CompoundLayoutProvider clp = new CompoundLayoutProvider();
            clp.addProvider(defaultLayoutProvider);
            if (defaultLayoutProvider instanceof ExtendableLayoutProvider) {
                ExtendableLayoutProvider layoutProvider = (ExtendableLayoutProvider)((Object)this.getGenericLayoutProvider(partToLayout));
                clp.addProvider(new PinnedElementsLayoutProvider(layoutProvider));
            }
            return new ArrangeSelectionLayoutProvider(clp);
        }
        return null;
    }

    public CustomLayoutConfiguration getLayoutConfiguration(IGraphicalEditPart partToLayout) {
        EditPartQuery editPartQuery = new EditPartQuery(partToLayout);
        DiagramDescription diagramDescription = editPartQuery.getDiagramDescription();
        CustomLayoutConfiguration layoutConfiguration = null;
        if (diagramDescription != null && diagramDescription.getLayout() instanceof CustomLayoutConfiguration) {
            layoutConfiguration = (CustomLayoutConfiguration)diagramDescription.getLayout();
        }
        return layoutConfiguration;
    }

    @Override
    public boolean provides(IGraphicalEditPart container) {
        return this.getGenericLayoutProvider(container) != null;
    }

    @Override
    public boolean isDiagramLayoutProvider() {
        return true;
    }

    private DefaultLayoutProvider getGenericLayoutProvider(IGraphicalEditPart partToLayout) {
        CustomLayoutAlgorithm customLayoutAlgorithm;
        CustomLayoutConfiguration customLayoutConfiguration = this.getLayoutConfiguration(partToLayout);
        if (customLayoutConfiguration != null && (customLayoutAlgorithm = DiagramUIPlugin.getPlugin().getLayoutAlgorithms().get(customLayoutConfiguration.getId())) != null) {
            DefaultLayoutProvider layoutAlgorithmInstance = customLayoutAlgorithm.getLayoutAlgorithmInstance();
            layoutAlgorithmInstance.setLayoutConfiguration(customLayoutConfiguration);
            return layoutAlgorithmInstance;
        }
        return null;
    }
}

