/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Problem State</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IProblemState#getStatus <em>Status</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IProblemState#getMessage <em>Message</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.IProblemState#getNeedinfo <em>Needinfo</em>}</li>
 * </ul>
 *
 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getProblemState()
 * @model
 * @generated
 */
public interface IProblemState extends ILinkable {
	/**
	 * Returns the value of the '<em><b>Status</b></em>' attribute.
	 * The default value is <code>"NEW"</code>.
	 * The literals are from the enumeration {@link org.eclipse.epp.logging.aeri.core.ProblemStatus}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Status</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Status</em>' attribute.
	 * @see org.eclipse.epp.logging.aeri.core.ProblemStatus
	 * @see #setStatus(ProblemStatus)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getProblemState_Status()
	 * @model default="NEW"
	 * @generated
	 */
	ProblemStatus getStatus();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IProblemState#getStatus <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Status</em>' attribute.
	 * @see org.eclipse.epp.logging.aeri.core.ProblemStatus
	 * @see #getStatus()
	 * @generated
	 */
	void setStatus(ProblemStatus value);

	/**
	 * Returns the value of the '<em><b>Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Message</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Message</em>' attribute.
	 * @see #setMessage(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getProblemState_Message()
	 * @model
	 * @generated
	 */
	String getMessage();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.IProblemState#getMessage <em>Message</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Message</em>' attribute.
	 * @see #getMessage()
	 * @generated
	 */
	void setMessage(String value);

	/**
	 * Returns the value of the '<em><b>Needinfo</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Needinfo</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Needinfo</em>' attribute list.
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getProblemState_Needinfo()
	 * @model
	 * @generated
	 */
	EList<String> getNeedinfo();

} // IProblemState
