/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services.about;

import java.io.PrintWriter;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.e4.core.internal.services.about.AboutMessages;
import org.eclipse.e4.core.services.about.ISystemInformation;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;

@Component(service={ISystemInformation.class}, property={"section=section.installed.bundles"})
public class InstalledBundles
implements ISystemInformation {
    @Override
    public void append(PrintWriter writer) {
        Bundle[] bundles = FrameworkUtil.getBundle(InstalledBundles.class).getBundleContext().getBundles();
        Map<String, String> headers = Arrays.stream(bundles).collect(Collectors.toMap(this::identify, this::name));
        Arrays.stream(bundles).sorted(this.createComparator(headers)).forEach(b -> this.writeBundleInfo(writer, (Bundle)b));
    }

    String identify(Bundle bundle) {
        return String.valueOf(bundle.getSymbolicName()) + '_' + bundle.getVersion();
    }

    private String name(Bundle bundle) {
        return (String)bundle.getHeaders(null).get("Bundle-Name");
    }

    private void writeBundleInfo(PrintWriter writer, Bundle bundle) {
        String id = bundle.getSymbolicName();
        String version = bundle.getVersion().toString();
        String name = this.name(bundle);
        String state = this.getStateName(bundle.getState());
        writer.println(String.format(AboutMessages.bundleInfoFormat, id, version, name, state));
    }

    private Comparator<Bundle> createComparator(final Map<String, String> names) {
        final Collator collator = Collator.getInstance(Locale.getDefault());
        return new Comparator<Bundle>(){

            @Override
            public int compare(Bundle o1, Bundle o2) {
                String id2;
                String id1 = InstalledBundles.this.identify(o1);
                if (!id1.equals(id2 = InstalledBundles.this.identify(o2))) {
                    return collator.compare(id1, id2);
                }
                return collator.compare((String)names.get(id1), (String)names.get(id2));
            }
        };
    }

    private String getStateName(int state) {
        switch (state) {
            case 2: {
                return AboutMessages.bundleStateInstalled;
            }
            case 4: {
                return AboutMessages.bundleStateResolved;
            }
            case 8: {
                return AboutMessages.bundleStateStarting;
            }
            case 16: {
                return AboutMessages.bundleStateStopping;
            }
            case 1: {
                return AboutMessages.bundleStateUninstalled;
            }
            case 32: {
                return AboutMessages.bundleStateActive;
            }
        }
        return AboutMessages.bundleStateUnknown;
    }
}

