/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.corext.util.SearchUtils;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResult;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.internal.ui.search.NewSearchResultCollector;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.internal.ui.search.SearchParticipantRecord;
import org.eclipse.dltk.internal.ui.search.SearchParticipantsExtensionPoint;
import org.eclipse.dltk.internal.ui.search.SearchResultUpdater;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.IMatchPresentation;
import org.eclipse.dltk.ui.search.IQueryParticipant;
import org.eclipse.dltk.ui.search.ISearchRequestor;
import org.eclipse.dltk.ui.search.PatternQuerySpecification;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;

public class DLTKSearchQuery
implements ISearchQuery {
    private static final String PERF_SEARCH_PARTICIPANT = "org.eclipse.dltk.ui/perf/search/participants";
    private ISearchResult fResult;
    private final QuerySpecification fPatternData;

    public DLTKSearchQuery(QuerySpecification data) {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.fPatternData = data;
    }

    public IStatus run(IProgressMonitor monitor) {
        DLTKSearchResult textResult = (DLTKSearchResult)this.getSearchResult();
        textResult.removeAll();
        SearchEngine engine = new SearchEngine();
        try {
            SearchPattern pattern;
            String stringPattern;
            int totalTicks = 1000;
            IProject[] projects = DLTKSearchScopeFactory.getInstance().getProjects(this.fPatternData.getScope());
            final SearchParticipantRecord[] participantDescriptors = SearchParticipantsExtensionPoint.getInstance().getSearchParticipants(this.fPatternData.getScope().getLanguageToolkit(), projects);
            final int[] ticks = new int[participantDescriptors.length];
            int i = 0;
            while (i < participantDescriptors.length) {
                final int iPrime = i;
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        ticks[iPrime] = 0;
                        String message = SearchMessages.DLTKSearchQuery_error_participant_estimate;
                        DLTKUIPlugin.log((IStatus)new Status(4, DLTKUIPlugin.getPluginId(), 0, message, exception));
                    }

                    public void run() throws Exception {
                        ticks[iPrime] = participantDescriptors[iPrime].getParticipant().estimateTicks(DLTKSearchQuery.this.fPatternData);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
                totalTicks += ticks[i];
                ++i;
            }
            IDLTKLanguageToolkit toolkit = this.fPatternData.getScope().getLanguageToolkit();
            if (this.fPatternData instanceof ElementQuerySpecification) {
                IModelElement element = ((ElementQuerySpecification)this.fPatternData).getElement();
                stringPattern = ScriptElementLabels.getDefault().getElementLabel(element, ScriptElementLabels.ALL_DEFAULT);
                if (!element.exists()) {
                    return new Status(4, DLTKUIPlugin.getPluginId(), 0, Messages.format(SearchMessages.DLTKSearchQuery_error_element_does_not_exist, stringPattern), null);
                }
                pattern = SearchPattern.createPattern((IModelElement)element, (int)this.fPatternData.getLimitTo(), (int)24, (IDLTKLanguageToolkit)toolkit);
            } else {
                PatternQuerySpecification patternSpec = (PatternQuerySpecification)this.fPatternData;
                stringPattern = patternSpec.getPattern();
                int matchMode = this.getMatchMode(stringPattern) | 0x10;
                if (patternSpec.isCaseSensitive()) {
                    matchMode |= 8;
                }
                pattern = SearchPattern.createPattern((String)patternSpec.getPattern(), (int)patternSpec.getSearchFor(), (int)patternSpec.getLimitTo(), (int)matchMode, (IDLTKLanguageToolkit)toolkit);
            }
            if (pattern == null) {
                return new Status(4, DLTKUIPlugin.getPluginId(), 0, Messages.format(SearchMessages.DLTKSearchQuery_error_unsupported_pattern, stringPattern), null);
            }
            monitor.beginTask(Messages.format(SearchMessages.DLTKSearchQuery_task_label, stringPattern), totalTicks);
            SubProgressMonitor mainSearchPM = new SubProgressMonitor(monitor, 1000);
            boolean ignorePotentials = NewSearchUI.arePotentialMatchesIgnored();
            NewSearchResultCollector collector = new NewSearchResultCollector(textResult, ignorePotentials);
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.fPatternData.getScope(), (org.eclipse.dltk.core.search.SearchRequestor)collector, (IProgressMonitor)mainSearchPM);
            int i2 = 0;
            while (i2 < participantDescriptors.length) {
                final SearchRequestor requestor = new SearchRequestor(participantDescriptors[i2].getParticipant(), textResult);
                SubProgressMonitor participantPM = new SubProgressMonitor(monitor, ticks[i2]);
                final int iPrime = i2++;
                ISafeRunnable runnable = new ISafeRunnable((IProgressMonitor)participantPM){
                    private final /* synthetic */ IProgressMonitor val$participantPM;
                    {
                        this.val$participantPM = iProgressMonitor;
                    }

                    public void handleException(Throwable exception) {
                        participantDescriptors[iPrime].getDescriptor().disable();
                        String message = SearchMessages.DLTKSearchQuery_error_participant_search;
                        DLTKUIPlugin.log((IStatus)new Status(4, DLTKUIPlugin.getPluginId(), 0, message, exception));
                    }

                    public void run() throws Exception {
                        IQueryParticipant participant = participantDescriptors[iPrime].getParticipant();
                        PerformanceStats stats = PerformanceStats.getStats((String)DLTKSearchQuery.PERF_SEARCH_PARTICIPANT, (Object)participant);
                        stats.startRun();
                        participant.search(requestor, DLTKSearchQuery.this.fPatternData, this.val$participantPM);
                        stats.endRun();
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        String message = Messages.format(SearchMessages.DLTKSearchQuery_status_ok_message, String.valueOf(textResult.getMatchCount()));
        return new Status(0, DLTKUIPlugin.getPluginId(), 0, message, null);
    }

    private int getMatchMode(String pattern) {
        if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
            return 2;
        }
        if (SearchUtils.isCamelCasePattern((String)pattern)) {
            return 128;
        }
        return 0;
    }

    public String getLabel() {
        return SearchMessages.DLTKSearchQuery_label;
    }

    public String getResultLabel(int nMatches) {
        if (nMatches == 1) {
            Object[] args = new Object[]{this.getSearchPatternDescription(), this.fPatternData.getScopeDescription()};
            switch (this.fPatternData.getLimitTo()) {
                case 0: {
                    return Messages.format(SearchMessages.DLTKSearchOperation_singularDeclarationsPostfix, args);
                }
                case 1: {
                    return Messages.format(SearchMessages.DLTKSearchOperation_singularReferencesPostfix, args);
                }
                case 2: {
                    return Messages.format(SearchMessages.DLTKSearchOperation_singularOccurrencesPostfix, args);
                }
            }
            return Messages.format(SearchMessages.DLTKSearchOperation_singularOccurrencesPostfix, args);
        }
        Object[] args = new Object[]{this.getSearchPatternDescription(), nMatches, this.fPatternData.getScopeDescription()};
        switch (this.fPatternData.getLimitTo()) {
            case 0: {
                return Messages.format(SearchMessages.DLTKSearchOperation_pluralDeclarationsPostfix, args);
            }
            case 1: {
                return Messages.format(SearchMessages.DLTKSearchOperation_pluralReferencesPostfix, args);
            }
            case 2: {
                return Messages.format(SearchMessages.DLTKSearchOperation_pluralOccurrencesPostfix, args);
            }
        }
        return Messages.format(SearchMessages.DLTKSearchOperation_pluralOccurrencesPostfix, args);
    }

    private String getSearchPatternDescription() {
        if (this.fPatternData instanceof ElementQuerySpecification) {
            IModelElement element = ((ElementQuerySpecification)this.fPatternData).getElement();
            return ScriptElementLabels.getDefault().getElementLabel(element, ScriptElementLabels.ALL_DEFAULT | ScriptElementLabels.ALL_FULLY_QUALIFIED | 0x1000000000000L);
        }
        return ((PatternQuerySpecification)this.fPatternData).getPattern();
    }

    ImageDescriptor getImageDescriptor() {
        if (this.fPatternData.getLimitTo() == 0) {
            return DLTKPluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return DLTKPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new DLTKSearchResult(this);
            new SearchResultUpdater((DLTKSearchResult)this.fResult);
        }
        return this.fResult;
    }

    QuerySpecification getSpecification() {
        return this.fPatternData;
    }

    private static class SearchRequestor
    implements ISearchRequestor {
        private IQueryParticipant fParticipant;
        private DLTKSearchResult fSearchResult;

        @Override
        public void reportMatch(Match match) {
            IMatchPresentation participant = this.fParticipant.getUIParticipant();
            if (participant == null || match.getElement() instanceof IModelElement || match.getElement() instanceof IResource) {
                this.fSearchResult.addMatch(match);
            } else {
                this.fSearchResult.addMatch(match, participant);
            }
        }

        protected SearchRequestor(IQueryParticipant participant, DLTKSearchResult result) {
            this.fParticipant = participant;
            this.fSearchResult = result;
        }
    }
}

