/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client.impl.ser;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwtjsonrpc.client.impl.JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;
import com.google.gwtjsonrpc.client.impl.ser.ObjectSerializer;
import java.util.HashMap;
import java.util.Map;

public class StringMapSerializer<V>
extends JsonSerializer<Map<String, V>>
implements ResultDeserializer<Map<String, V>> {
    private final JsonSerializer<V> valueSerializer;

    public StringMapSerializer(JsonSerializer<V> v) {
        this.valueSerializer = v;
    }

    @Override
    public void printJson(StringBuilder sb, Map<String, V> o) {
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, V> e : o.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(JsonUtils.escapeValue((String)e.getKey()));
            sb.append(':');
            StringMapSerializer.encode(sb, this.valueSerializer, e.getValue());
        }
        sb.append('}');
    }

    private static <T> void encode(StringBuilder sb, JsonSerializer<T> serializer, T item) {
        if (item != null) {
            serializer.printJson(sb, item);
        } else {
            sb.append("null");
        }
    }

    @Override
    public Map<String, V> fromJson(Object o) {
        if (o == null) {
            return null;
        }
        JavaScriptObject jso = (JavaScriptObject)o;
        HashMap r = new HashMap();
        this.copy(r, jso);
        return r;
    }

    @Override
    public Map<String, V> fromResult(JavaScriptObject response) {
        JavaScriptObject result = ObjectSerializer.objectResult(response);
        return result == null ? null : this.fromJson(result);
    }

    private native void copy(Map<String, V> var1, JavaScriptObject var2);

    void copyOne(Map<String, V> r, String k, Object o) {
        r.put(k, this.valueSerializer.fromJson(o));
    }
}

