/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.addon.viewers.runtime.model.patterns;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.viatra.addon.viewers.runtime.notation.Edge;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PVisibility;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.views.traceability.Trace;

/**
 * A pattern-specific query specification that can instantiate Matcher in a type-safe way.
 * 
 * <p>Original source:
 *         <code><pre>
 *         pattern param2edge(source : java Object, target : java Object, trace : Trace, edge : Edge) {
 *         	Trace.params(trace, source);
 *         	Trace.params(trace, target);
 *         	Trace.targets(trace, edge);
 *         } or {
 *         	Trace.objects(trace, source);
 *         	Trace.params(trace, target);
 *         	Trace.targets(trace, edge);
 *         } or {
 *         	Trace.params(trace, source);
 *         	Trace.objects(trace, target);
 *         	Trace.targets(trace, edge);
 *         } or {
 *         	Trace.objects(trace, source);
 *         	Trace.objects(trace, target);
 *         	Trace.targets(trace, edge);
 *         }
 * </pre></code>
 * 
 * @see Matcher
 * @see Match
 * 
 */
@SuppressWarnings("all")
public final class Param2edge extends BaseGeneratedEMFQuerySpecification<Param2edge.Matcher> {
  /**
   * Pattern-specific match representation of the org.eclipse.viatra.addon.viewers.runtime.model.patterns.param2edge pattern,
   * to be used in conjunction with {@link Matcher}.
   * 
   * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
   * Each instance is a (possibly partial) substitution of pattern parameters,
   * usable to represent a match of the pattern in the result of a query,
   * or to specify the bound (fixed) input parameters when issuing a query.
   * 
   * @see Matcher
   * 
   */
  public static abstract class Match extends BasePatternMatch {
    private Object fSource;
    
    private Object fTarget;
    
    private Trace fTrace;
    
    private Edge fEdge;
    
    private static List<String> parameterNames = makeImmutableList("source", "target", "trace", "edge");
    
    private Match(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      this.fSource = pSource;
      this.fTarget = pTarget;
      this.fTrace = pTrace;
      this.fEdge = pEdge;
    }
    
    @Override
    public Object get(final String parameterName) {
      if ("source".equals(parameterName)) return this.fSource;
      if ("target".equals(parameterName)) return this.fTarget;
      if ("trace".equals(parameterName)) return this.fTrace;
      if ("edge".equals(parameterName)) return this.fEdge;
      return null;
    }
    
    public Object getSource() {
      return this.fSource;
    }
    
    public Object getTarget() {
      return this.fTarget;
    }
    
    public Trace getTrace() {
      return this.fTrace;
    }
    
    public Edge getEdge() {
      return this.fEdge;
    }
    
    @Override
    public boolean set(final String parameterName, final Object newValue) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      if ("source".equals(parameterName) && newValue instanceof Object) {
          this.fSource = (Object) newValue;
          return true;
      }
      if ("target".equals(parameterName) && newValue instanceof Object) {
          this.fTarget = (Object) newValue;
          return true;
      }
      if ("trace".equals(parameterName) ) {
          this.fTrace = (Trace) newValue;
          return true;
      }
      if ("edge".equals(parameterName) ) {
          this.fEdge = (Edge) newValue;
          return true;
      }
      return false;
    }
    
    public void setSource(final Object pSource) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      this.fSource = pSource;
    }
    
    public void setTarget(final Object pTarget) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      this.fTarget = pTarget;
    }
    
    public void setTrace(final Trace pTrace) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      this.fTrace = pTrace;
    }
    
    public void setEdge(final Edge pEdge) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      this.fEdge = pEdge;
    }
    
    @Override
    public String patternName() {
      return "org.eclipse.viatra.addon.viewers.runtime.model.patterns.param2edge";
    }
    
    @Override
    public List<String> parameterNames() {
      return Param2edge.Match.parameterNames;
    }
    
    @Override
    public Object[] toArray() {
      return new Object[]{fSource, fTarget, fTrace, fEdge};
    }
    
    @Override
    public Param2edge.Match toImmutable() {
      return isMutable() ? newMatch(fSource, fTarget, fTrace, fEdge) : this;
    }
    
    @Override
    public String prettyPrint() {
      StringBuilder result = new StringBuilder();
      result.append("\"source\"=" + prettyPrintValue(fSource) + ", ");
      result.append("\"target\"=" + prettyPrintValue(fTarget) + ", ");
      result.append("\"trace\"=" + prettyPrintValue(fTrace) + ", ");
      result.append("\"edge\"=" + prettyPrintValue(fEdge));
      return result.toString();
    }
    
    @Override
    public int hashCode() {
      return Objects.hash(fSource, fTarget, fTrace, fEdge);
    }
    
    @Override
    public boolean equals(final Object obj) {
      if (this == obj)
          return true;
      if (obj == null) {
          return false;
      }
      if ((obj instanceof Param2edge.Match)) {
          Param2edge.Match other = (Param2edge.Match) obj;
          return Objects.equals(fSource, other.fSource) && Objects.equals(fTarget, other.fTarget) && Objects.equals(fTrace, other.fTrace) && Objects.equals(fEdge, other.fEdge);
      } else {
          // this should be infrequent
          if (!(obj instanceof IPatternMatch)) {
              return false;
          }
          IPatternMatch otherSig  = (IPatternMatch) obj;
          return Objects.equals(specification(), otherSig.specification()) && Arrays.deepEquals(toArray(), otherSig.toArray());
      }
    }
    
    @Override
    public Param2edge specification() {
      return Param2edge.instance();
    }
    
    /**
     * Returns an empty, mutable match.
     * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
     * 
     * @return the empty match.
     * 
     */
    public static Param2edge.Match newEmptyMatch() {
      return new Mutable(null, null, null, null);
    }
    
    /**
     * Returns a mutable (partial) match.
     * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
     * 
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
     * @return the new, mutable (partial) match object.
     * 
     */
    public static Param2edge.Match newMutableMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      return new Mutable(pSource, pTarget, pTrace, pEdge);
    }
    
    /**
     * Returns a new (partial) match.
     * This can be used e.g. to call the matcher with a partial match.
     * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
     * @return the (partial) match object.
     * 
     */
    public static Param2edge.Match newMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      return new Immutable(pSource, pTarget, pTrace, pEdge);
    }
    
    private static final class Mutable extends Param2edge.Match {
      Mutable(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
        super(pSource, pTarget, pTrace, pEdge);
      }
      
      @Override
      public boolean isMutable() {
        return true;
      }
    }
    
    private static final class Immutable extends Param2edge.Match {
      Immutable(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
        super(pSource, pTarget, pTrace, pEdge);
      }
      
      @Override
      public boolean isMutable() {
        return false;
      }
    }
  }
  
  /**
   * Generated pattern matcher API of the org.eclipse.viatra.addon.viewers.runtime.model.patterns.param2edge pattern,
   * providing pattern-specific query methods.
   * 
   * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
   * e.g. in conjunction with {@link ViatraQueryEngine#on(QueryScope)}.
   * 
   * <p>Matches of the pattern will be represented as {@link Match}.
   * 
   * <p>Original source:
   * <code><pre>
   * pattern param2edge(source : java Object, target : java Object, trace : Trace, edge : Edge) {
   * 	Trace.params(trace, source);
   * 	Trace.params(trace, target);
   * 	Trace.targets(trace, edge);
   * } or {
   * 	Trace.objects(trace, source);
   * 	Trace.params(trace, target);
   * 	Trace.targets(trace, edge);
   * } or {
   * 	Trace.params(trace, source);
   * 	Trace.objects(trace, target);
   * 	Trace.targets(trace, edge);
   * } or {
   * 	Trace.objects(trace, source);
   * 	Trace.objects(trace, target);
   * 	Trace.targets(trace, edge);
   * }
   * </pre></code>
   * 
   * @see Match
   * @see Param2edge
   * 
   */
  public static class Matcher extends BaseMatcher<Param2edge.Match> {
    /**
     * Initializes the pattern matcher within an existing VIATRA Query engine.
     * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
     * 
     * @param engine the existing VIATRA Query engine in which this matcher will be created.
     * @throws ViatraQueryRuntimeException if an error occurs during pattern matcher creation
     * 
     */
    public static Param2edge.Matcher on(final ViatraQueryEngine engine) {
      // check if matcher already exists
      Matcher matcher = engine.getExistingMatcher(querySpecification());
      if (matcher == null) {
          matcher = (Matcher)engine.getMatcher(querySpecification());
      }
      return matcher;
    }
    
    /**
     * @throws ViatraQueryRuntimeException if an error occurs during pattern matcher creation
     * @return an initialized matcher
     * @noreference This method is for internal matcher initialization by the framework, do not call it manually.
     * 
     */
    public static Param2edge.Matcher create() {
      return new Matcher();
    }
    
    private static final int POSITION_SOURCE = 0;
    
    private static final int POSITION_TARGET = 1;
    
    private static final int POSITION_TRACE = 2;
    
    private static final int POSITION_EDGE = 3;
    
    private static final Logger LOGGER = ViatraQueryLoggingUtil.getLogger(Param2edge.Matcher.class);
    
    /**
     * Initializes the pattern matcher within an existing VIATRA Query engine.
     * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
     * 
     * @param engine the existing VIATRA Query engine in which this matcher will be created.
     * @throws ViatraQueryRuntimeException if an error occurs during pattern matcher creation
     * 
     */
    private Matcher() {
      super(querySpecification());
    }
    
    /**
     * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
     * @return matches represented as a Match object.
     * 
     */
    public Collection<Param2edge.Match> getAllMatches(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      return rawStreamAllMatches(new Object[]{pSource, pTarget, pTrace, pEdge}).collect(Collectors.toSet());
    }
    
    /**
     * Returns a stream of all matches of the pattern that conform to the given fixed values of some parameters.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
     * @return a stream of matches represented as a Match object.
     * 
     */
    public Stream<Param2edge.Match> streamAllMatches(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      return rawStreamAllMatches(new Object[]{pSource, pTarget, pTrace, pEdge});
    }
    
    /**
     * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
     * Neither determinism nor randomness of selection is guaranteed.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
     * @return a match represented as a Match object, or null if no match is found.
     * 
     */
    public Optional<Param2edge.Match> getOneArbitraryMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      return rawGetOneArbitraryMatch(new Object[]{pSource, pTarget, pTrace, pEdge});
    }
    
    /**
     * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
     * under any possible substitution of the unspecified parameters (if any).
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
     * @return true if the input is a valid (partial) match of the pattern.
     * 
     */
    public boolean hasMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      return rawHasMatch(new Object[]{pSource, pTarget, pTrace, pEdge});
    }
    
    /**
     * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
     * @return the number of pattern matches found.
     * 
     */
    public int countMatches(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      return rawCountMatches(new Object[]{pSource, pTarget, pTrace, pEdge});
    }
    
    /**
     * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
     * Neither determinism nor randomness of selection is guaranteed.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
     * @param processor the action that will process the selected match.
     * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
     * 
     */
    public boolean forOneArbitraryMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge, final Consumer<? super Param2edge.Match> processor) {
      return rawForOneArbitraryMatch(new Object[]{pSource, pTarget, pTrace, pEdge}, processor);
    }
    
    /**
     * Returns a new (partial) match.
     * This can be used e.g. to call the matcher with a partial match.
     * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
     * @return the (partial) match object.
     * 
     */
    public Param2edge.Match newMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      return Param2edge.Match.newMatch(pSource, pTarget, pTrace, pEdge);
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    protected Stream<Object> rawStreamAllValuesOfsource(final Object[] parameters) {
      return rawStreamAllValues(POSITION_SOURCE, parameters).map(Object.class::cast);
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Object> getAllValuesOfsource() {
      return rawStreamAllValuesOfsource(emptyArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Stream<Object> streamAllValuesOfsource() {
      return rawStreamAllValuesOfsource(emptyArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<Object> streamAllValuesOfsource(final Param2edge.Match partialMatch) {
      return rawStreamAllValuesOfsource(partialMatch.toArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<Object> streamAllValuesOfsource(final Object pTarget, final Trace pTrace, final Edge pEdge) {
      return rawStreamAllValuesOfsource(new Object[]{null, pTarget, pTrace, pEdge});
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Object> getAllValuesOfsource(final Param2edge.Match partialMatch) {
      return rawStreamAllValuesOfsource(partialMatch.toArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Object> getAllValuesOfsource(final Object pTarget, final Trace pTrace, final Edge pEdge) {
      return rawStreamAllValuesOfsource(new Object[]{null, pTarget, pTrace, pEdge}).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    protected Stream<Object> rawStreamAllValuesOftarget(final Object[] parameters) {
      return rawStreamAllValues(POSITION_TARGET, parameters).map(Object.class::cast);
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Object> getAllValuesOftarget() {
      return rawStreamAllValuesOftarget(emptyArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Stream<Object> streamAllValuesOftarget() {
      return rawStreamAllValuesOftarget(emptyArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<Object> streamAllValuesOftarget(final Param2edge.Match partialMatch) {
      return rawStreamAllValuesOftarget(partialMatch.toArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<Object> streamAllValuesOftarget(final Object pSource, final Trace pTrace, final Edge pEdge) {
      return rawStreamAllValuesOftarget(new Object[]{pSource, null, pTrace, pEdge});
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Object> getAllValuesOftarget(final Param2edge.Match partialMatch) {
      return rawStreamAllValuesOftarget(partialMatch.toArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Object> getAllValuesOftarget(final Object pSource, final Trace pTrace, final Edge pEdge) {
      return rawStreamAllValuesOftarget(new Object[]{pSource, null, pTrace, pEdge}).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    protected Stream<Trace> rawStreamAllValuesOftrace(final Object[] parameters) {
      return rawStreamAllValues(POSITION_TRACE, parameters).map(Trace.class::cast);
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Trace> getAllValuesOftrace() {
      return rawStreamAllValuesOftrace(emptyArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Stream<Trace> streamAllValuesOftrace() {
      return rawStreamAllValuesOftrace(emptyArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<Trace> streamAllValuesOftrace(final Param2edge.Match partialMatch) {
      return rawStreamAllValuesOftrace(partialMatch.toArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<Trace> streamAllValuesOftrace(final Object pSource, final Object pTarget, final Edge pEdge) {
      return rawStreamAllValuesOftrace(new Object[]{pSource, pTarget, null, pEdge});
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Trace> getAllValuesOftrace(final Param2edge.Match partialMatch) {
      return rawStreamAllValuesOftrace(partialMatch.toArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Trace> getAllValuesOftrace(final Object pSource, final Object pTarget, final Edge pEdge) {
      return rawStreamAllValuesOftrace(new Object[]{pSource, pTarget, null, pEdge}).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for edge.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    protected Stream<Edge> rawStreamAllValuesOfedge(final Object[] parameters) {
      return rawStreamAllValues(POSITION_EDGE, parameters).map(Edge.class::cast);
    }
    
    /**
     * Retrieve the set of values that occur in matches for edge.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Edge> getAllValuesOfedge() {
      return rawStreamAllValuesOfedge(emptyArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for edge.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Stream<Edge> streamAllValuesOfedge() {
      return rawStreamAllValuesOfedge(emptyArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for edge.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<Edge> streamAllValuesOfedge(final Param2edge.Match partialMatch) {
      return rawStreamAllValuesOfedge(partialMatch.toArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for edge.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<Edge> streamAllValuesOfedge(final Object pSource, final Object pTarget, final Trace pTrace) {
      return rawStreamAllValuesOfedge(new Object[]{pSource, pTarget, pTrace, null});
    }
    
    /**
     * Retrieve the set of values that occur in matches for edge.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Edge> getAllValuesOfedge(final Param2edge.Match partialMatch) {
      return rawStreamAllValuesOfedge(partialMatch.toArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for edge.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<Edge> getAllValuesOfedge(final Object pSource, final Object pTarget, final Trace pTrace) {
      return rawStreamAllValuesOfedge(new Object[]{pSource, pTarget, pTrace, null}).collect(Collectors.toSet());
    }
    
    @Override
    protected Param2edge.Match tupleToMatch(final Tuple t) {
      try {
          return Param2edge.Match.newMatch((Object) t.get(POSITION_SOURCE), (Object) t.get(POSITION_TARGET), (Trace) t.get(POSITION_TRACE), (Edge) t.get(POSITION_EDGE));
      } catch(ClassCastException e) {
          LOGGER.error("Element(s) in tuple not properly typed!",e);
          return null;
      }
    }
    
    @Override
    protected Param2edge.Match arrayToMatch(final Object[] match) {
      try {
          return Param2edge.Match.newMatch((Object) match[POSITION_SOURCE], (Object) match[POSITION_TARGET], (Trace) match[POSITION_TRACE], (Edge) match[POSITION_EDGE]);
      } catch(ClassCastException e) {
          LOGGER.error("Element(s) in array not properly typed!",e);
          return null;
      }
    }
    
    @Override
    protected Param2edge.Match arrayToMatchMutable(final Object[] match) {
      try {
          return Param2edge.Match.newMutableMatch((Object) match[POSITION_SOURCE], (Object) match[POSITION_TARGET], (Trace) match[POSITION_TRACE], (Edge) match[POSITION_EDGE]);
      } catch(ClassCastException e) {
          LOGGER.error("Element(s) in array not properly typed!",e);
          return null;
      }
    }
    
    /**
     * @return the singleton instance of the query specification of this pattern
     * @throws ViatraQueryRuntimeException if the pattern definition could not be loaded
     * 
     */
    public static IQuerySpecification<Param2edge.Matcher> querySpecification() {
      return Param2edge.instance();
    }
  }
  
  private Param2edge() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryRuntimeException if the pattern definition could not be loaded
   * 
   */
  public static Param2edge instance() {
    try{
        return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
        throw processInitializerError(err);
    }
  }
  
  @Override
  protected Param2edge.Matcher instantiate(final ViatraQueryEngine engine) {
    return Param2edge.Matcher.on(engine);
  }
  
  @Override
  public Param2edge.Matcher instantiate() {
    return Param2edge.Matcher.create();
  }
  
  @Override
  public Param2edge.Match newEmptyMatch() {
    return Param2edge.Match.newEmptyMatch();
  }
  
  @Override
  public Param2edge.Match newMatch(final Object... parameters) {
    return Param2edge.Match.newMatch((java.lang.Object) parameters[0], (java.lang.Object) parameters[1], (org.eclipse.viatra.transformation.views.traceability.Trace) parameters[2], (org.eclipse.viatra.addon.viewers.runtime.notation.Edge) parameters[3]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link JvmGenericType: org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edge (visibility: PUBLIC, simpleName: Param2edge, identifier: org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edge, deprecated: <unset>) (abstract: false, static: false, final: true, packageName: org.eclipse.viatra.addon.viewers.runtime.model.patterns) (interface: false, strictFloatingPoint: false, anonymous: false)} to be created 
   *     <b>not</b> at the class load time of the outer class, 
   *     but rather at the first call to {@link JvmGenericType: org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edge (visibility: PUBLIC, simpleName: Param2edge, identifier: org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edge, deprecated: <unset>) (abstract: false, static: false, final: true, packageName: org.eclipse.viatra.addon.viewers.runtime.model.patterns) (interface: false, strictFloatingPoint: false, anonymous: false)#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private static final Param2edge INSTANCE = new Param2edge();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private static final Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternal();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private static final Param2edge.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_source = new PParameter("source", "java.lang.Object", new JavaTransitiveInstancesKey(java.lang.Object.class), PParameterDirection.INOUT);
    
    private final PParameter parameter_target = new PParameter("target", "java.lang.Object", new JavaTransitiveInstancesKey(java.lang.Object.class), PParameterDirection.INOUT);
    
    private final PParameter parameter_trace = new PParameter("trace", "org.eclipse.viatra.transformation.views.traceability.Trace", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")), PParameterDirection.INOUT);
    
    private final PParameter parameter_edge = new PParameter("edge", "org.eclipse.viatra.addon.viewers.runtime.notation.Edge", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_source, parameter_target, parameter_trace, parameter_edge);
    
    private GeneratedPQuery() {
      super(PVisibility.PUBLIC);
    }
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.addon.viewers.runtime.model.patterns.param2edge";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("source","target","trace","edge");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() {
      setEvaluationHints(new QueryEvaluationHint(null, QueryEvaluationHint.BackendRequirement.UNSPECIFIED));
      Set<PBody> bodies = new LinkedHashSet<>();
      {
          PBody body = new PBody(this);
          PVariable var_source = body.getOrCreateVariableByName("source");
          PVariable var_target = body.getOrCreateVariableByName("target");
          PVariable var_trace = body.getOrCreateVariableByName("trace");
          PVariable var_edge = body.getOrCreateVariableByName("edge");
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_source), new JavaTransitiveInstancesKey(java.lang.Object.class));
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_target), new JavaTransitiveInstancesKey(java.lang.Object.class));
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge")));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_source, parameter_source),
             new ExportedParameter(body, var_target, parameter_target),
             new ExportedParameter(body, var_trace, parameter_trace),
             new ExportedParameter(body, var_edge, parameter_edge)
          ));
          // 	Trace.params(trace, source)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "params")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_0_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_0_, var_source);
          // 	Trace.params(trace, target)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "params")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_1_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_1_, var_target);
          // 	Trace.targets(trace, edge)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "targets")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_2_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_2_, var_edge);
          bodies.add(body);
      }
      {
          PBody body = new PBody(this);
          PVariable var_source = body.getOrCreateVariableByName("source");
          PVariable var_target = body.getOrCreateVariableByName("target");
          PVariable var_trace = body.getOrCreateVariableByName("trace");
          PVariable var_edge = body.getOrCreateVariableByName("edge");
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_source), new JavaTransitiveInstancesKey(java.lang.Object.class));
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_target), new JavaTransitiveInstancesKey(java.lang.Object.class));
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge")));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_source, parameter_source),
             new ExportedParameter(body, var_target, parameter_target),
             new ExportedParameter(body, var_trace, parameter_trace),
             new ExportedParameter(body, var_edge, parameter_edge)
          ));
          // 	Trace.objects(trace, source)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "objects")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_0_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EJavaObject")));
          new Equality(body, var__virtual_0_, var_source);
          // 	Trace.params(trace, target)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "params")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_1_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_1_, var_target);
          // 	Trace.targets(trace, edge)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "targets")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_2_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_2_, var_edge);
          bodies.add(body);
      }
      {
          PBody body = new PBody(this);
          PVariable var_source = body.getOrCreateVariableByName("source");
          PVariable var_target = body.getOrCreateVariableByName("target");
          PVariable var_trace = body.getOrCreateVariableByName("trace");
          PVariable var_edge = body.getOrCreateVariableByName("edge");
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_source), new JavaTransitiveInstancesKey(java.lang.Object.class));
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_target), new JavaTransitiveInstancesKey(java.lang.Object.class));
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge")));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_source, parameter_source),
             new ExportedParameter(body, var_target, parameter_target),
             new ExportedParameter(body, var_trace, parameter_trace),
             new ExportedParameter(body, var_edge, parameter_edge)
          ));
          // 	Trace.params(trace, source)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "params")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_0_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_0_, var_source);
          // 	Trace.objects(trace, target)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "objects")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_1_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EJavaObject")));
          new Equality(body, var__virtual_1_, var_target);
          // 	Trace.targets(trace, edge)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "targets")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_2_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_2_, var_edge);
          bodies.add(body);
      }
      {
          PBody body = new PBody(this);
          PVariable var_source = body.getOrCreateVariableByName("source");
          PVariable var_target = body.getOrCreateVariableByName("target");
          PVariable var_trace = body.getOrCreateVariableByName("trace");
          PVariable var_edge = body.getOrCreateVariableByName("edge");
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_source), new JavaTransitiveInstancesKey(java.lang.Object.class));
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_target), new JavaTransitiveInstancesKey(java.lang.Object.class));
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge")));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_source, parameter_source),
             new ExportedParameter(body, var_target, parameter_target),
             new ExportedParameter(body, var_trace, parameter_trace),
             new ExportedParameter(body, var_edge, parameter_edge)
          ));
          // 	Trace.objects(trace, source)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "objects")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_0_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EJavaObject")));
          new Equality(body, var__virtual_0_, var_source);
          // 	Trace.objects(trace, target)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "objects")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_1_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EJavaObject")));
          new Equality(body, var__virtual_1_, var_target);
          // 	Trace.targets(trace, edge)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "targets")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_2_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_2_, var_edge);
          bodies.add(body);
      }
      return bodies;
    }
  }
}
