/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.codeassist.contexts.ClassMemberContext;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class ClassObjMemberContext
extends ClassMemberContext {
    private boolean isThis;
    private boolean isDirectThis;
    private boolean isParent;

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        TextSequence statementText;
        String parentText;
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        if (this.getTriggerType() != ClassMemberContext.Trigger.OBJECT) {
            return false;
        }
        int elementStart = this.getElementStart();
        int lhsIndex = elementStart - "$this".length() - this.getTriggerType().getName().length();
        if (lhsIndex >= 0 && (parentText = (statementText = this.getStatementText()).subSequence(lhsIndex, elementStart - this.getTriggerType().getName().length()).toString()).equals("$this")) {
            this.isDirectThis = true;
            this.isThis = true;
        }
        if (!this.isThis) {
            IEvaluatedType instanceType;
            IContext context;
            ModuleDeclaration moduleDeclaration;
            Object[] types;
            lhsIndex = elementStart - "$parent".length() - this.getTriggerType().getName().length();
            if (lhsIndex >= 0 && (parentText = (statementText = this.getStatementText()).subSequence(lhsIndex, elementStart - this.getTriggerType().getName().length()).toString()).equals("$parent")) {
                this.isParent = true;
            }
            if (ArrayUtils.isNotEmpty((Object[])(types = this.getLhsTypes())) && (moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule)) != null && (context = ASTUtils.findContext(sourceModule, moduleDeclaration, offset)) instanceof MethodContext && (instanceType = ((MethodContext)context).getInstanceType()) instanceof PHPClassType) {
                PHPClassType classType = (PHPClassType)instanceType;
                String namespace = classType.getNamespace();
                if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                    IType currentNamespace;
                    String typeName = classType.getTypeName();
                    int i = typeName.lastIndexOf(92);
                    if (i != -1) {
                        typeName = typeName.substring(i + 1);
                    }
                    if (namespace.charAt(0) == '\\') {
                        namespace = namespace.substring(1);
                    }
                    if ((currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)types[0])) != null) {
                        this.isThis = namespace.equals(currentNamespace.getElementName()) && typeName.equals(types[0].getElementName());
                    }
                } else {
                    this.isThis = classType.getTypeName().equals(types[0].getElementName());
                }
            }
        }
        return true;
    }

    public boolean isThis() {
        return this.isThis;
    }

    public boolean isDirectThis() {
        return this.isDirectThis;
    }

    public boolean isParent() {
        return this.isParent;
    }
}

