/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPVariable;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;

public final class DSPValue
extends DSPDebugElement
implements IValue {
    private Long variablesReference;
    private String name;
    private String value;

    public DSPValue(DSPDebugElement parent, Long variablesReference, String name, String value) {
        super(parent.getDebugTarget());
        this.variablesReference = variablesReference;
        this.name = name;
        this.value = value;
    }

    public IVariable[] getVariables() throws DebugException {
        if (!this.hasVariables()) {
            return new IVariable[0];
        }
        VariablesArguments arguments = new VariablesArguments();
        arguments.setVariablesReference(this.variablesReference);
        Variable[] targetVariables = ((VariablesResponse)DSPValue.complete(this.getDebugTarget().getDebugProtocolServer().variables(arguments))).getVariables();
        ArrayList<DSPVariable> variables = new ArrayList<DSPVariable>();
        Variable[] variableArray = targetVariables;
        int n = targetVariables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            variables.add(new DSPVariable(this, variable.getVariablesReference(), variable.getName(), variable.getValue()));
            ++n2;
        }
        return variables.toArray(new DSPVariable[variables.size()]);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.name;
    }

    public String getValueString() throws DebugException {
        return this.value;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public boolean hasVariables() throws DebugException {
        return this.variablesReference != null && this.variablesReference > 0L;
    }
}

