/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.notifications;

import java.util.Date;
import java.util.List;

import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.swt.graphics.Image;

import com.google.common.base.Optional;

@SuppressWarnings("restriction")
public abstract class Notification extends AbstractUiNotification {

    @Nullable
    private NotificationPopup popup;
    private boolean unhandled = true;
    protected IEventBroker broker;

    public Notification(String eventId, IEventBroker broker) {
        super(eventId);
        // this.bus = bus;
        this.broker = broker;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter(this, adapter);
    }

    @Override
    @Nullable
    public Image getNotificationImage() {
        return null;
    }

    @Override
    @Nullable
    public Image getNotificationKindImage() {
        return null;
    }

    @Override
    public Date getDate() {
        return new Date();
    }

    public String getTitle() {
        return Messages.NOTIFICATION_TITLE_ERROR_REPORTING;
    }

    public void setPopup(NotificationPopup popup) {
        this.popup = popup;
    }

    public Optional<NotificationPopup> getPopup() {
        return Optional.fromNullable(popup);
    }

    /**
     * Returns the list of actions for this notification. The first action (if present) will be selected as default action for the
     * notification and used in {@link #open()}
     */
    public abstract List<NotificationAction> getActions();

    @Override
    public void open() {
        List<NotificationAction> actions = getActions();
        if (!actions.isEmpty()) {
            actions.get(0).execute();
        }
    }

    public void closeWithEvent(@Nullable String topic, @Nullable Object event) {
        unhandled = false;
        NotificationPopup popup = getPopup().orNull();
        if (popup != null) {
            popup.close();
        }
        if (topic != null) {
            fireEvent(topic, event);
        }
    }

    public void fireEvent(String topic, @Nullable Object event) {
        unhandled = false;
        broker.post(topic, event);
    }

    /**
     * Called by the sink when the notification popup was closed.
     */
    public void close() {
        if (unhandled) {
            unhandled();
        }
    }

    public void unhandled() {
    }

}
