/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class RhinoDebugPlugin
extends Plugin {
    public static final int INTERNAL_ERROR = 120;
    public static final String PLUGIN_ID = "org.eclipse.wst.jsdt.debug.rhino";
    private static RhinoDebugPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static RhinoDebugPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static void log(Throwable t) {
        RhinoDebugPlugin.log(RhinoDebugPlugin.newErrorStatus("Error logged from Rhino Debug: ", t));
    }

    public static void logErrorMessage(String message) {
        RhinoDebugPlugin.log(RhinoDebugPlugin.newErrorStatus("Internal message logged from Rhino Debug: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 120, message, exception);
    }

    public static URI fileURI(IPath path) throws URISyntaxException {
        return new URI("file", null, path.makeAbsolute().toString(), null);
    }
}

