/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.grid;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GridDimensionInfo<C extends IControlInfo> {
    protected final IGridLayoutInfo<C> m_layout;
    protected int m_index;

    public GridDimensionInfo(IGridLayoutInfo<C> layout) {
        this.m_layout = layout;
    }

    public final int getIndex() {
        return this.m_index;
    }

    public final void setIndex(int index) {
        this.m_index = index;
    }

    public final String getTitle() throws Exception {
        String tooltip = "";
        Integer alignmentValue = this.getAlignment();
        if (alignmentValue != null) {
            tooltip = this.getAlignmentTitle(alignmentValue);
        }
        if (this.getGrab()) {
            if (tooltip.length() != 0) {
                tooltip = String.valueOf(tooltip) + ", ";
            }
            tooltip = String.valueOf(tooltip) + "grab";
        }
        return tooltip;
    }

    protected abstract boolean getGrab(IGridDataInfo var1);

    protected abstract void setGrab(IGridDataInfo var1, boolean var2) throws Exception;

    public final boolean getGrab() {
        final boolean[] result = new boolean[1];
        this.processControls(new IGridDataProcessor<C>(){

            @Override
            public void process(C control, IGridDataInfo gridData) throws Exception {
                result[0] = result[0] | GridDimensionInfo.this.getGrab(gridData);
            }
        });
        return result[0];
    }

    public final void setGrab(final boolean grab) {
        this.processControls(new IGridDataProcessor<C>(){

            @Override
            public void process(C control, IGridDataInfo gridData) throws Exception {
                GridDimensionInfo.this.setGrab(gridData, grab);
            }
        });
    }

    public final void flipGrab() {
        this.setGrab(!this.getGrab());
    }

    protected abstract String getAlignmentTitle(int var1);

    protected abstract int getAlignment(IGridDataInfo var1);

    protected abstract void setAlignment(IGridDataInfo var1, int var2) throws Exception;

    public final Integer getAlignment() {
        final boolean[] first = new boolean[]{true};
        final Integer[] result = new Integer[1];
        this.processControls(new IGridDataProcessor<C>(){

            @Override
            public void process(C control, IGridDataInfo gridData) throws Exception {
                int alignment = GridDimensionInfo.this.getAlignment(gridData);
                if (first[0]) {
                    result[0] = alignment;
                } else if (result[0] != null && result[0] != alignment) {
                    result[0] = null;
                }
                first[0] = false;
            }
        });
        return result[0];
    }

    public final void setAlignment(final int alignment) {
        this.processControls(new IGridDataProcessor<C>(){

            @Override
            public void process(C control, IGridDataInfo gridData) throws Exception {
                GridDimensionInfo.this.setAlignment(gridData, alignment);
            }
        });
    }

    public abstract void delete() throws Exception;

    private void processControls(final IGridDataProcessor<C> processor) {
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                List toProcess = this.getControlsToProcess();
                for (IControlInfo control : toProcess) {
                    IGridDataInfo gridData = GridDimensionInfo.this.m_layout.getGridData2(control);
                    processor.process(control, gridData);
                }
            }

            private List<C> getControlsToProcess() {
                ArrayList toProcess = Lists.newArrayList();
                for (IControlInfo control : GridDimensionInfo.this.m_layout.getControls()) {
                    IGridDataInfo gridData;
                    if (GridDimensionInfo.this.m_layout.isFiller(control) || !GridDimensionInfo.this.shouldProcessThisControl(gridData = GridDimensionInfo.this.m_layout.getGridData2(control))) continue;
                    toProcess.add(control);
                }
                return toProcess;
            }
        });
    }

    protected abstract boolean shouldProcessThisControl(IGridDataInfo var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface IGridDataProcessor<C extends IControlInfo> {
        public void process(C var1, IGridDataInfo var2) throws Exception;
    }
}

