/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.internal.remote.terminal.Activator;
import org.eclipse.ptp.internal.remote.terminal.MachineManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TerminalInfoView
extends ViewPart {
    private static List<TerminalInfoView> views = new ArrayList<TerminalInfoView>();
    private static final int NENTRIES = 100;
    private TabFolder fTabs;
    private Map<String, TabForm> fTabItems = new HashMap<String, TabForm>();
    private static LinkedList<Command> commands = new LinkedList();

    public TerminalInfoView() {
        TerminalInfoView.addToList(this);
    }

    private static synchronized void addToList(TerminalInfoView view) {
        views.add(view);
    }

    private static synchronized Iterable<TerminalInfoView> getViews() {
        return new ArrayList<TerminalInfoView>(views);
    }

    public void createPartControl(Composite parent) {
        this.fTabs = new TabFolder(parent, 0);
        TerminalInfoView.updateSync(this);
    }

    public void setFocus() {
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void update() {
        if (this.fTabs != null && !this.fTabs.isDisposed() && this.fTabs.isEnabled()) ** GOTO lbl21
        return;
lbl-1000:
        // 1 sources

        {
            c = TerminalInfoView.commands.removeFirst();
            form = this.init(c);
            j = 0;
            i = 0;
            while (i < 99) {
                if (TabRow.access$1(form.rows[i]).getSelection()) {
                    if (i > j) {
                        form.swap(i, j);
                    }
                    ++j;
                }
                ++i;
            }
            i = 99;
            while (i > j) {
                if (!TabRow.access$0(form.rows[i - 1]).getText().equals("")) {
                    form.swap(i, i - 1);
                }
                --i;
            }
            TabRow.access$0(form.rows[j]).setText(c.text.trim());
lbl21:
            // 2 sources

            ** while (TerminalInfoView.commands.size() > 0)
        }
lbl22:
        // 1 sources

        this.fTabs.pack(true);
        this.fTabs.getParent().layout(true);
    }

    private synchronized TabForm init(Command c) {
        TabForm form = this.fTabItems.get(c.connectionName);
        if (form == null) {
            form = new TabForm();
            form.item = new TabItem(this.fTabs, 0);
            form.item.setText(c.connectionName);
            ScrolledComposite scomp = new ScrolledComposite((Composite)this.fTabs, 2560);
            Composite comp = new Composite((Composite)scomp, 0);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            scomp.setExpandHorizontal(true);
            scomp.setAlwaysShowScrollBars(true);
            scomp.setContent((Control)comp);
            FillLayout gl0 = new FillLayout();
            scomp.setLayout((Layout)gl0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 4;
            comp.setLayout((Layout)gl);
            comp.setLayoutData((Object)gd);
            final TabForm finalForm = form;
            int i = 0;
            while (i < 100) {
                final int nn = i;
                form.rows[i] = new TabRow(comp, c.connectionName, i);
                form.rows[i].fDel.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        int j = nn;
                        while (j < 99) {
                            finalForm.swap(j, j + 1);
                            ++j;
                        }
                    }
                });
                ++i;
            }
            form.item.setControl((Control)scomp);
            this.fTabItems.put(c.connectionName, form);
            Composite parent = scomp.getParent();
            parent.setLayout((Layout)gl0);
            comp.pack(true);
            scomp.pack(true);
        }
        return form;
    }

    private static void updateSync(TerminalInfoView view) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                TerminalInfoView.this.update();
            }
        });
    }

    public static synchronized void addToHistory(String connectionName, String cmd) {
        commands.addLast(new Command(connectionName, cmd));
        for (TerminalInfoView view : TerminalInfoView.getViews()) {
            TerminalInfoView.updateSync(view);
        }
    }

    private static class Command {
        final String connectionName;
        final String text;

        Command(String conn, String text) {
            this.connectionName = conn;
            this.text = text;
        }
    }

    private static class TabForm {
        TabItem item;
        TabRow[] rows = new TabRow[100];

        private TabForm() {
        }

        public void swap(int i, int j) {
            boolean sel = this.rows[i].fCheck.getSelection();
            this.rows[i].fCheck.setSelection(this.rows[j].fCheck.getSelection());
            this.rows[j].fCheck.setSelection(sel);
            String txt = this.rows[i].fText.getText();
            this.rows[i].fText.setText(this.rows[j].fText.getText());
            this.rows[j].fText.setText(txt);
        }
    }

    private static class TabRow {
        private Button fGo;
        private Button fCheck;
        private Text fText;
        private Button fDel;

        TabRow(Composite c, final String connectionName, int n) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            int props = n % 2 == 0 ? 2048 : 0;
            GridData gdleft = new GridData();
            GridData gdright = new GridData();
            GridData gdcenter = new GridData();
            gdcenter.horizontalAlignment = 4;
            gdcenter.grabExcessHorizontalSpace = true;
            gdleft.horizontalAlignment = 1;
            gdright.horizontalAlignment = 3;
            gdright.grabExcessHorizontalSpace = false;
            gdleft.grabExcessHorizontalSpace = false;
            this.fGo = new Button(c, props);
            this.fGo.setLayoutData((Object)gdleft);
            this.fGo.setText(Integer.toString(n));
            this.fCheck = new Button(c, props | 0x20);
            this.fCheck.setLayoutData((Object)gdleft);
            this.fText = new Text(c, props);
            this.fText.setLayoutData((Object)gdcenter);
            this.fDel = new Button(c, props);
            this.fDel.setLayoutData((Object)gdright);
            this.fDel.setText("X");
            if (n % 2 == 0) {
                this.fDel.setBackground(display.getSystemColor(9));
                this.fGo.setBackground(display.getSystemColor(9));
                this.fText.setForeground(display.getSystemColor(9));
            }
            this.fGo.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        OutputStream out = MachineManager.getOutputStream(connectionName);
                        out.write((String.valueOf(TabRow.this.fText.getText()) + "\n").getBytes());
                        out.flush();
                    }
                    catch (IOException e) {
                        Activator.log(e);
                    }
                }
            });
            this.fGo.pack();
            this.fCheck.pack();
            this.fText.pack();
            this.fDel.pack();
        }
    }
}

