/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.validation.actions;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pmf.model.checkrules.manager.CheckRuleManager;
import org.eclipse.pmf.pim.presentation.PMFEditor;
import org.eclipse.pmf.validation.internal.l10n.ValidationMessages;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class BatchValidationDelegate
implements IEditorActionDelegate,
IActionDelegate2 {
    protected static final String MESSAGE_EXCEPTION = ValidationMessages.message_exception;
    protected Shell shell = null;
    protected PMFEditor editor = null;
    protected Collection<EObject> selectedEObjects = null;
    private final String title = ValidationMessages.BatchValidationDelegate_title;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedEObjects = null;
        try {
            try {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    this.selectedEObjects = structuredSelection.toList();
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)MESSAGE_EXCEPTION);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            action.setEnabled(this.selectedEObjects != null);
            throw throwable;
        }
        action.setEnabled(this.selectedEObjects != null);
        for (EObject next : this.selectedEObjects) {
            if (next instanceof EObject) continue;
            action.setEnabled(false);
        }
    }

    public void dispose() {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (PMFEditor)targetEditor;
        if (targetEditor != null) {
            this.shell = targetEditor.getSite().getShell();
        }
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        Resource resource = ((EObject)this.selectedEObjects.toArray()[0]).eResource();
        CheckRuleManager manager = new CheckRuleManager(resource);
        manager.invokeModelChecking();
    }
}

