/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.AliasMethod;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseStatementContext;
import org.eclipse.php.internal.core.codeassist.strategies.ElementsStrategy;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class FunctionsStrategy
extends ElementsStrategy {
    public FunctionsStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        String prefix;
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        CompletionRequestor requestor = abstractContext.getCompletionRequestor();
        String string = prefix = abstractContext.getPrefix().isEmpty() ? abstractContext.getPreviousWord() : abstractContext.getPrefix();
        if (StringUtils.isBlank((CharSequence)prefix) || prefix.startsWith("$")) {
            return;
        }
        String nsUseGroupPrefix = null;
        if (context instanceof UseStatementContext) {
            nsUseGroupPrefix = ((UseStatementContext)context).getGroupPrefixBeforeOpeningCurly();
        }
        int extraInfo = this.getExtraInfo();
        if (abstractContext.isAbsoluteName()) {
            extraInfo |= 0x200;
            extraInfo |= 0x400;
        }
        if (abstractContext.isAbsolute()) {
            extraInfo |= 0x200;
        }
        if (nsUseGroupPrefix != null) {
            extraInfo |= 0x40;
            extraInfo |= 0x200;
        }
        ISearchEngine.MatchRule matchRule = ISearchEngine.MatchRule.PREFIX;
        if (requestor.isContextInformationMode()) {
            matchRule = ISearchEngine.MatchRule.EXACT;
        }
        IDLTKSearchScope scope = this.createSearchScope();
        String memberName = abstractContext.getMemberName();
        String namespaceName = abstractContext.getQualifier(true);
        IMethod[] functions = PHPModelAccess.getDefault().findFunctions(namespaceName, memberName, matchRule, 0, 0, scope, null);
        ISourceRange replacementRange = this.getReplacementRange(abstractContext);
        ISourceRange memberReplacementRange = this.getReplacementRangeForMember(abstractContext);
        boolean isAbsoluteMethod = abstractContext.isAbsoluteName() || abstractContext.isAbsolute();
        String suffix = this.getSuffix(abstractContext);
        String namespace = abstractContext.getCurrentNamespace();
        IMethod[] iMethodArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (nsUseGroupPrefix != null) {
                reporter.reportMethod(method, nsUseGroupPrefix, suffix, memberReplacementRange, extraInfo, this.getRelevance(namespace, (IMember)method));
            } else {
                reporter.reportMethod(method, suffix, isAbsoluteMethod ? replacementRange : memberReplacementRange, isAbsoluteMethod ? extraInfo | 0x80 : extraInfo, this.getRelevance(namespace, (IMember)method));
            }
            ++n2;
        }
        this.addAlias(reporter, suffix);
    }

    protected void addAlias(ICompletionReporter reporter, String suffix) throws BadLocationException {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        if (abstractContext.getCompletionRequestor().isContextInformationMode()) {
            return;
        }
        String prefix = abstractContext.getPrefix();
        if (prefix.indexOf(92) != -1) {
            return;
        }
        IModuleSource module = reporter.getModule();
        ISourceModule sourceModule = (ISourceModule)module.getModelElement();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        int offset = abstractContext.getOffset();
        IType namespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
        Map<String, UsePart> result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, offset, namespace, false);
        this.reportAlias(reporter, suffix, abstractContext, module, result);
    }

    protected void reportAlias(ICompletionReporter reporter, String suffix, AbstractCompletionContext abstractContext, IModuleSource module, Map<String, UsePart> result) throws BadLocationException {
        ISourceRange replacementRange = this.getReplacementRange(abstractContext);
        IDLTKSearchScope scope = this.createSearchScope();
        for (Map.Entry<String, UsePart> entry : result.entrySet()) {
            String elementName;
            int i;
            IMethod[] elements;
            String name = entry.getKey();
            String fullName = entry.getValue().getFullUseStatementName();
            if (!fullName.contains("\\")) {
                elements = PHPModelAccess.getDefault().findMethods(null, fullName, ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
                i = 0;
                while (i < elements.length) {
                    elementName = elements[i].getElementName();
                    this.reportAlias(reporter, scope, module, replacementRange, (IMember)elements[i], elementName, elementName.replace(fullName, name), suffix);
                    ++i;
                }
            }
            elements = PHPModelAccess.getDefault().findMethods(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            i = 0;
            while (i < elements.length) {
                elementName = elements[i].getElementName();
                this.reportAlias(reporter, scope, module, replacementRange, (IMember)elements[i], elementName, name, suffix);
                ++i;
            }
        }
    }

    protected void reportAlias(ICompletionReporter reporter, IDLTKSearchScope scope, IModuleSource module, ISourceRange replacementRange, IMember member, String fullName, String alias, String suffix) {
        reporter.reportMethod((IMethod)new AliasMethod((ModelElement)member, fullName, alias), suffix, replacementRange, this.getExtraInfo());
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "(".equals(nextWord) ? "" : "()";
    }

    protected int getExtraInfo() {
        return 9;
    }
}

